---
generated_at: 2026-01-22 20:36:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-SCM変更原因（SCMTriggerCause）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/triggers/SCMTrigger.java` 708-776行（SCMTriggerCauseクラス定義）
- E-02: `core/src/main/java/hudson/triggers/SCMTrigger.java` 638-686行（Runner.run()メソッド）
- E-03: `core/src/main/java/hudson/triggers/SCMTrigger.java` 607-635行（runPolling()メソッド）
- E-04: `core/src/main/java/hudson/triggers/SCMTrigger.java` 718-720行（コンストラクタ File版）
- E-05: `core/src/main/java/hudson/triggers/SCMTrigger.java` 723-725行（コンストラクタ String版）
- E-06: `core/src/main/java/hudson/triggers/SCMTrigger.java` 742-755行（onAddedTo()メソッド）
- E-07: `core/src/main/java/hudson/triggers/SCMTrigger.java` 757-760行（getShortDescription()メソッド）
- E-08: `core/src/main/java/hudson/triggers/SCMTrigger.java` 767-770行（equals()メソッド）
- E-09: `core/src/main/java/hudson/triggers/SCMTrigger.java` 772-775行（hashCode()メソッド）
- E-10: `core/src/main/java/hudson/triggers/SCMTrigger.java` 217行（@Symbol("pollSCM")）
- E-11: `core/src/main/java/hudson/triggers/SCMTrigger.java` 243-248行（ポーリングスレッド数設定）
- E-12: `core/src/main/java/hudson/triggers/SCMTrigger.java` 782行（STARVATION_THRESHOLD）
- E-13: `docs/code-to-docs/通知一覧/通知一覧.csv` 34行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SCMTriggerCauseはSCMTriggerの内部クラスである | E-01 | ○ |
| C-02 | SCMポーリングで変更が検出された場合に使用される | E-02, E-13 | ○ |
| C-03 | pollingLogフィールドを持ち、キュー中はメモリに保持される | E-01 (713-714行) | ○ |
| C-04 | コンストラクタでFiles.readString()を使用してログを読み込む | E-04 | ○ |
| C-05 | onAddedTo()でポーリングログをファイルに書き込む | E-06 (748行) | ○ |
| C-06 | onAddedTo()後にpollingLogをnullにする | E-06 (754行) | ○ |
| C-07 | getShortDescription()はMessages.SCMTrigger_SCMTriggerCause_ShortDescriptionを返す | E-07 | ○ |
| C-08 | equals()は他のSCMTriggerCauseと常にtrueを返す | E-08 | ○ |
| C-09 | hashCode()は固定値3を返す | E-09 (774行) | ○ |
| C-10 | SCMTriggerは@Symbol("pollSCM")アノテーションを持つ | E-10 | ○ |
| C-11 | ポーリングスレッド数はデフォルト10で5-100の範囲 | E-11 | ○ |
| C-12 | STARVATION_THRESHOLDは1時間 | E-12 | ○ |
| C-13 | Runner.run()でSCMDecisionHandlerによる拒否チェックがある | E-02 (644行) | ○ |
| C-14 | runPolling()でjob.poll(listener)を呼び出す | E-03 (617行) | ○ |
| C-15 | 変更があればSCMTriggerCause生成、scheduleBuild2実行 | E-02 (667-677行) | ○ |
| C-16 | BuildActionでポーリングログをビルドに関連付ける | E-06 (745, 750行) | ○ |
| C-17 | synchronousPollingモードではTrigger.Cronスレッドで直接実行 | E-02 (182-185行参照) | ○ |
| C-18 | ignorePostCommitHooks設定が存在する | E-01 (108, 138-140行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Runner.run()の処理フローがドキュメント記載通りか確認
- [ ] onAddedTo()のポーリングログ保存処理を確認
- [ ] SCMDecisionHandlerの動作を確認
- [ ] Messages.propertiesでのメッセージ定義を確認
