---
generated_at: 2026-01-22 20:38:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-ディスク容量モニター（DiskSpaceMonitor）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/node_monitors/DiskSpaceMonitor.java` 47-125行
- E-02: `core/src/main/java/hudson/node_monitors/DiskSpaceMonitorDescriptor.java` 53-297行
- E-03: `core/src/main/java/hudson/node_monitors/AbstractDiskSpaceMonitor.java` 15-100行
- E-04: `core/src/main/java/hudson/node_monitors/NodeMonitor.java` 45-156行
- E-05: `core/src/main/java/hudson/node_monitors/AbstractNodeMonitorDescriptor.java` 56-345行
- E-06: `core/src/main/java/hudson/node_monitors/DiskSpaceMonitorDescriptor.java` 106-281行（DiskSpaceクラス）
- E-07: `core/src/main/java/hudson/node_monitors/DiskSpaceMonitorDescriptor.java` 283-296行（GetUsableSpaceクラス）
- E-08: `core/src/main/java/hudson/node_monitors/DiskSpaceMonitor.java` 100行（@Symbol("diskSpace")）
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 35行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DiskSpaceMonitorはAbstractDiskSpaceMonitorを継承する | E-01 (47行) | ○ |
| C-02 | リモートFSルートのディスク空き容量を監視する | E-01, E-09 | ○ |
| C-03 | デフォルト閾値は1GiB | E-03 (29行) | ○ |
| C-04 | デフォルト警告閾値は2GiB | E-03 (30行) | ○ |
| C-05 | 監視間隔はデフォルト60分 | E-05 (57行) | ○ |
| C-06 | getThresholdBytes()でノード固有または全体の閾値を取得 | E-01 (56-69行) | ○ |
| C-07 | DiskSpaceMonitorNodePropertyでノード固有閾値を設定可能 | E-01 (59-66行) | ○ |
| C-08 | DiskSpaceクラスはMonitorOfflineCauseを継承 | E-06 (106行) | ○ |
| C-09 | DiskSpaceはsize、path、totalSizeを持つ | E-06 (107-111行) | ○ |
| C-10 | DiskSpace.parse()で人間が読める形式を解析 | E-06 (252-278行) | ○ |
| C-11 | isTriggered()でsize <= thresholdを判定 | E-06 (207-209行) | ○ |
| C-12 | isWarning()でsize > threshold && size < warningThresholdを判定 | E-06 (211-214行) | ○ |
| C-13 | GetUsableSpaceでFile.getUsableSpace()を呼び出す | E-07 (288行) | ○ |
| C-14 | monitor()でmarkNodeOfflineOrOnline()を呼び出す | E-02 (72行) | ○ |
| C-15 | markNodeOfflineOrOnline()で閾値比較とオフライン/オンライン処理 | E-02 (78-100行) | ○ |
| C-16 | ディスク容量カラムはJenkins.ADMINISTER権限が必要 | E-01 (92-95行) | ○ |
| C-17 | @Symbol("diskSpace")アノテーションを持つ | E-08 | ○ |
| C-18 | Jenkins 1.123から存在する | E-01 (46行 @since) | ○ |
| C-19 | DiskSpaceのtoString()で詳細メッセージを生成 | E-06 (138-165行) | ○ |
| C-20 | markOffline()でMonitorMarkedNodeOffline.active = trueに設定 | E-05 (253-256行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] DiskSpaceMonitorのgetThresholdBytes()がノード固有設定を正しく参照するか確認
- [ ] markNodeOfflineOrOnline()のオフライン/オンライン切り替えロジックを確認
- [ ] DiskSpace.parse()の単位解析が正しいか確認
- [ ] Messages.propertiesでのメッセージ定義を確認
