---
generated_at: 2026-01-22 20:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-一時領域モニター（TemporarySpaceMonitor）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/node_monitors/TemporarySpaceMonitor.java` 51-151行
- E-02: `core/src/main/java/hudson/node_monitors/TemporarySpaceMonitor.java` 136-150行（GetTempSpaceクラス）
- E-03: `core/src/main/java/hudson/node_monitors/TemporarySpaceMonitor.java` 60-73行（getThresholdBytes）
- E-04: `core/src/main/java/hudson/node_monitors/TemporarySpaceMonitor.java` 75-89行（getWarningThresholdBytes）
- E-05: `core/src/main/java/hudson/node_monitors/TemporarySpaceMonitor.java` 111行（@Symbol("tmpSpace")）
- E-06: `core/src/main/java/hudson/node_monitors/TemporarySpaceMonitor.java` 97-100行（getColumnCaption）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 36行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TemporarySpaceMonitorはAbstractDiskSpaceMonitorを継承する | E-01 (51行) | ○ |
| C-02 | 一時ディレクトリ（java.io.tmpdir）の空き容量を監視する | E-02, E-07 | ○ |
| C-03 | GetTempSpaceでSystem.getProperty("java.io.tmpdir")を使用 | E-02 (141行) | ○ |
| C-04 | GetTempSpaceでFile.getUsableSpace()を呼び出す | E-02 (142行) | ○ |
| C-05 | GetTempSpaceでFile.getTotalSpace()を呼び出す | E-02 (145行) | ○ |
| C-06 | getThresholdBytes()でノード固有または全体の閾値を取得 | E-03 | ○ |
| C-07 | DiskSpaceMonitorNodePropertyのfreeTempSpaceThresholdを参照 | E-03 (66行) | ○ |
| C-08 | getWarningThresholdBytes()で警告閾値を取得 | E-04 | ○ |
| C-09 | DiskSpaceMonitorNodePropertyのfreeTempSpaceWarningThresholdを参照 | E-04 (82行) | ○ |
| C-10 | @Symbol("tmpSpace")アノテーションを持つ | E-05 | ○ |
| C-11 | ディスク情報取得失敗時はnullを返す | E-02 (143行) | ○ |
| C-12 | 一時領域カラムはJenkins.ADMINISTER権限が必要 | E-06 | ○ |
| C-13 | DiskSpaceクラスを使用してデータを表現 | E-02 (144行) | ○ |
| C-14 | DiskSpaceMonitorDescriptorを継承するDescriptorを持つ | E-01 (112行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] GetTempSpace.invoke()のjava.io.tmpdir取得が正しく動作するか確認
- [ ] DiskSpaceMonitorNodePropertyとの連携が正しいか確認
- [ ] Messages.propertiesでのメッセージ定義を確認
