---
generated_at: 2026-01-22 20:42:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-スワップ領域モニター（SwapSpaceMonitor）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/node_monitors/SwapSpaceMonitor.java` 49-198行
- E-02: `core/src/main/java/hudson/node_monitors/SwapSpaceMonitor.java` 57-72行（toHtml()メソッド）
- E-03: `core/src/main/java/hudson/node_monitors/SwapSpaceMonitor.java` 74-82行（toMB()メソッド）
- E-04: `core/src/main/java/hudson/node_monitors/SwapSpaceMonitor.java` 84-88行（getColumnCaption()メソッド）
- E-05: `core/src/main/java/hudson/node_monitors/SwapSpaceMonitor.java` 97-119行（DescriptorImpl）
- E-06: `core/src/main/java/hudson/node_monitors/SwapSpaceMonitor.java` 105-107行（canTakeOffline()）
- E-07: `core/src/main/java/hudson/node_monitors/SwapSpaceMonitor.java` 124-150行（MonitorTaskクラス）
- E-08: `core/src/main/java/hudson/node_monitors/SwapSpaceMonitor.java` 158-198行（MemoryUsage2クラス）
- E-09: `core/src/main/java/hudson/node_monitors/SwapSpaceMonitor.java` 97行（@Symbol("swapSpace")）
- E-10: `core/src/main/java/hudson/node_monitors/SwapSpaceMonitor.java` 48行（@since 1.233）
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 37行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SwapSpaceMonitorはNodeMonitorを継承する | E-01 (49行) | ○ |
| C-02 | スワップ領域の使用状況を監視する | E-01, E-11 | ○ |
| C-03 | toHtml()でavailableSwapSpace == -1の場合は"N/A"を返す | E-02 (59-60行) | ○ |
| C-04 | 空き256MB未満かつ使用率80%超でエラースパン表示 | E-02 (67行) | ○ |
| C-05 | canTakeOffline()がfalseを返す | E-06 | ○ |
| C-06 | @Symbol("swapSpace")アノテーションを持つ | E-09 | ○ |
| C-07 | Jenkins 1.233から存在する | E-10 | ○ |
| C-08 | スワップ領域カラムはJenkins.ADMINISTER権限が必要 | E-04 | ○ |
| C-09 | MemoryUsage2はMemoryUsageを継承する | E-08 (159行) | ○ |
| C-10 | MemoryUsage2は@ExportedBeanアノテーションを持つ | E-08 (158行) | ○ |
| C-11 | MonitorTaskでMemoryMonitor.get()を呼び出す | E-07 (127-129行) | ○ |
| C-12 | 初回エラーのみ例外をスロー、以降はnullを返す | E-07 (138-145行) | ○ |
| C-13 | warned静的フラグでエラー報告を制御 | E-07 (149行) | ○ |
| C-14 | MemoryUsage2でtotalPhysicalMemory、availablePhysicalMemory、totalSwapSpace、availableSwapSpaceを公開 | E-08 (169-196行) | ○ |
| C-15 | Functions.humanReadableByteSize()で人間が読める形式に変換 | E-02 (62行) | ○ |
| C-16 | Util.wrapToErrorSpan()でエラー表示 | E-02 (71行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] toHtml()の警告条件（256MB未満、使用率80%超）が正しいか確認
- [ ] MonitorTaskのエラーハンドリングが適切か確認
- [ ] Messages.propertiesでのメッセージ定義を確認
