---
generated_at: 2026-01-22 20:44:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-応答時間モニター（ResponseTimeMonitor）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/node_monitors/ResponseTimeMonitor.java` 47-235行
- E-02: `core/src/main/java/hudson/node_monitors/ResponseTimeMonitor.java` 163-227行（Dataクラス）
- E-03: `core/src/main/java/hudson/node_monitors/ResponseTimeMonitor.java` 106-124行（Step1クラス）
- E-04: `core/src/main/java/hudson/node_monitors/ResponseTimeMonitor.java` 126-141行（Step2クラス）
- E-05: `core/src/main/java/hudson/node_monitors/ResponseTimeMonitor.java` 143-158行（Step3クラス）
- E-06: `core/src/main/java/hudson/node_monitors/ResponseTimeMonitor.java` 70-97行（monitor()メソッド）
- E-07: `core/src/main/java/hudson/node_monitors/ResponseTimeMonitor.java` 56-58行（@Symbol("responseTime")）
- E-08: `core/src/main/java/hudson/node_monitors/ResponseTimeMonitor.java` 232行（TIMEOUT = 5000）
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 38行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ResponseTimeMonitorはNodeMonitorを継承する | E-01 (47行) | ○ |
| C-02 | 往復応答時間（ラウンドトリップタイム）を監視する | E-01, E-09 | ○ |
| C-03 | DataクラスはMonitorOfflineCauseを継承する | E-02 (164行) | ○ |
| C-04 | past5配列で過去5回分の計測値を保持 | E-02 (168-169行) | ○ |
| C-05 | failureCount()で連続タイムアウト回数を計算 | E-02 (185-190行) | ○ |
| C-06 | hasTooManyTimeouts()で5回連続タイムアウトを判定 | E-02 (206-208行) | ○ |
| C-07 | getAverage()で平均応答時間を計算 | E-02 (196-204行) | ○ |
| C-08 | Step1.writeReplace()でStep2に変換 | E-03 (119-121行) | ○ |
| C-09 | Step2でstart時刻を記録 | E-04 (128行) | ○ |
| C-10 | Step3.readResolve()で往復時間を計算 | E-05 (152-154行) | ○ |
| C-11 | monitor()で5回連続タイムアウト時にc.disconnect()を呼び出す | E-06 (92行) | ○ |
| C-12 | タイムアウト閾値は5000ミリ秒 | E-08 | ○ |
| C-13 | @Symbol("responseTime")アノテーションを持つ | E-07 | ○ |
| C-14 | 監視失敗時は-1でDataを生成 | E-06 (84行) | ○ |
| C-15 | toString()でタイムアウト回数またはms表示 | E-02 (213-219行) | ○ |
| C-16 | getTrigger()でResponseTimeMonitor.classを返す | E-02 (221-224行) | ○ |
| C-17 | isIgnored()の場合は接続切断しない | E-06 (87行) | ○ |
| C-18 | 切断時に警告ログを出力 | E-06 (93行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Step1→Step2→Step3の変換フローが正しく動作するか確認
- [ ] hasTooManyTimeouts()の判定ロジックが正しいか確認
- [ ] c.disconnect()の動作とノードの再接続プロセスを確認
- [ ] Messages.propertiesでのメッセージ定義を確認
