---
generated_at: 2026-01-22 20:36:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-古いデータ警告（OldDataMonitor）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/diagnosis/OldDataMonitor.java`
- E-02: `core/src/main/java/hudson/model/AdministrativeMonitor.java`
- E-03: `core/src/main/resources/hudson/diagnosis/OldDataMonitor/message.jelly`
- E-04: `core/src/main/resources/hudson/diagnosis/OldDataMonitor/manage.jelly`
- E-05: `core/src/main/resources/hudson/diagnosis/Messages.properties`
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv`
- E-07: `test/src/test/java/hudson/diagnosis/OldDataMonitorTest.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | dataマップが空でない場合に有効化 | E-01 (107-109行目: isActivated) | ○ |
| C-02 | ConcurrentHashMapでデータ管理 | E-01 (83行目) | ○ |
| C-03 | report(Saveable, String)でバージョン指定登録 | E-01 (174-189行目) | ○ |
| C-04 | report(UnmarshallingContext, String)でXStream経由登録 | E-01 (197-199行目) | ○ |
| C-05 | report(Saveable, Collection)でエラー情報付き登録 | E-01 (214-247行目) | ○ |
| C-06 | VersionRangeでバージョン範囲管理 | E-01 (249-300行目) | ○ |
| C-07 | SaveableListenerで保存時自動削除 | E-01 (143-149行目) | ○ |
| C-08 | ItemListenerでアイテム削除時自動削除 | E-01 (151-157行目) | ○ |
| C-09 | RunListenerでビルド削除時自動削除 | E-01 (159-165行目) | ○ |
| C-10 | doAct()で@RequirePOST保護 | E-01 (319行目) | ○ |
| C-11 | doUpgrade()で一括アップグレード | E-01 (333-344行目) | ○ |
| C-12 | doDiscard()で読み込み不可データ破棄 | E-01 (350-355行目) | ○ |
| C-13 | saveAndRemoveEntries()で保存と削除 | E-01 (357-385行目) | ○ |
| C-14 | @Extension, @Symbolアノテーションで登録 | E-01 (79行目) | ○ |
| C-15 | Symbol名は"oldData" | E-01 (79行目) | ○ |
| C-16 | ID="OldData" | E-01 (97-99行目) | ○ |
| C-17 | ManagementLinkImplで管理リンク提供 | E-01 (455-491行目) | ○ |
| C-18 | Badge表示でデータ件数表示 | E-01 (484-490行目: getBadge) | ○ |
| C-19 | DisplayNameはMessages.propertiesで定義 | E-05 (4行目) | ○ |
| C-20 | テストファイルが存在 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要な機能・処理フローがソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] report()メソッドの各バリエーションが正しく説明されているか確認
- [ ] リスナーによる自動削除処理が正しく説明されているか確認
- [ ] VersionRangeのバージョン比較ロジックが適切に説明されているか確認
