---
generated_at: 2026-01-22 21:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：41-メモリ使用量モニター

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **MultiStageTimeSeriesの内部実装**：直接参照していないため詳細確認推奨
  2. **グラフ画像サイズ**：Jellyファイルから推測
  3. **ColorPaletteの色定義**：定数参照のみ

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java`
- E-02: `core/src/main/java/jenkins/diagnosis/MemoryUsageMonitorAction.java`
- E-03: `core/src/main/java/hudson/model/PeriodicWork.java`
- E-04: `core/src/main/resources/hudson/diagnosis/MemoryUsageMonitor/index.jelly`
- E-05: `core/src/main/resources/hudson/diagnosis/Messages.properties`
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MemoryUsageMonitorはPeriodicWorkを継承している | E-01 (51行目: `extends PeriodicWork`) | ○ |
| C-02 | 10秒間隔でメモリ使用状況を収集する | E-01 (112-114行目: `TimeUnit.SECONDS.toMillis(10)`) | ○ |
| C-03 | ヒープとノンヒープの2種類のメモリグループを監視 | E-01 (102-108行目: `heap`, `nonHeap`フィールド定義) | ○ |
| C-04 | MemoryPoolMXBeanからCollectionUsageを取得 | E-01 (79行目: `pool.getCollectionUsage()`) | ○ |
| C-05 | メモリ使用量はKB単位に変換される | E-01 (85-87行目: `used /= 1024; max /= 1024;`) | ○ |
| C-06 | グラフ表示にはJenkins.SYSTEM_READまたはJenkins.MANAGE権限が必要 | E-01 (97行目: `Jenkins.get().checkAnyPermission(Jenkins.SYSTEM_READ, Jenkins.MANAGE)`) | ○ |
| C-07 | usedは赤色、maxは青色で表示 | E-01 (62-66行目: `ColorPalette.RED`, `ColorPalette.BLUE`) | ○ |
| C-08 | 3つの時間スケール（sec10/min/hour）をサポート | E-04 (37-62行目: type=sec10/min/hourの条件分岐) | ○ |
| C-09 | デフォルトの時間スケールはmin | E-04 (34行目: `request2.getParameter('type') ?: 'min'`) | ○ |
| C-10 | グラフサイズは500x300ピクセル | E-04 (64行目: `width=500&amp;height=300`) | ○ |
| C-11 | MemoryUsageMonitorActionはversion 2.505以降追加 | E-02 (39行目: `@since 2.505`) | ○ |
| C-12 | MemoryUsageMonitorActionはNoExternalUse制限 | E-02 (42行目: `@Restricted(NoExternalUse.class)`) | ○ |
| C-13 | PeriodicWorkはJenkins起動時にinit()で初期化 | E-03 (104-112行目: `@Initializer(after = JOB_CONFIG_ADAPTED)`) | ○ |
| C-14 | 初期遅延はランダムに設定される | E-03 (89-95行目: `getInitialDelay()` RANDOMを使用) | ○ |
| C-15 | URLパスは`/hudson.diagnosis.MemoryUsageMonitor/` | E-04 (Jellyファイルのパス構造から推定), E-02 (URLName定義) | ○ |
| C-16 | 通知一覧でカテゴリは「システムモニター」 | E-06 (42行目: "システムモニター") | ○ |
| C-17 | Messages.propertiesでUSED/TOTALラベル定義 | E-05 (1-2行目: `MemoryUsageMonitor.USED=Used`, `MemoryUsageMonitor.TOTAL=Total`) | ○ |
| C-18 | MultiStageTimeSeriesの詳細な時間スケール処理 | **根拠なし**（MultiStageTimeSeries.javaを直接参照していない） | △ |

## 4) 不足情報（Unknown / Missing）
- MultiStageTimeSeriesの内部実装詳細
  - 候補：`core/src/main/java/hudson/model/MultiStageTimeSeries.java`を追加参照
- TrendChartの生成アルゴリズム詳細
  - 候補：MultiStageTimeSeries.createTrendChart()の実装確認
- ColorPaletteの色コード具体値
  - 候補：`hudson/util/ColorPalette.java`を参照

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的に根拠が明確で信頼性が高い
- 注意点: MultiStageTimeSeriesの詳細動作は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] MemoryUsageMonitor.javaの行番号が実際のコードと一致するか確認
- [ ] MultiStageTimeSeriesの時間スケール処理の詳細を必要に応じて確認
- [ ] セキュリティ関連の権限チェック実装が正確か確認
