---
generated_at: 2026-01-22 21:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-コントローラーエグゼキュータ警告（ControllerExecutorsNoAgents）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/diagnostics/ControllerExecutorsNoAgents.java`
- E-02: `core/src/main/java/hudson/model/AdministrativeMonitor.java`
- E-03: `core/src/main/resources/jenkins/diagnostics/ControllerExecutorsNoAgents/message.jelly`
- E-04: `core/src/main/resources/jenkins/diagnostics/ControllerExecutorsNoAgents/message.properties`
- E-05: `core/src/main/resources/jenkins/diagnostics/ControllerExecutorsNoAgents/description.properties`
- E-06: `core/src/main/resources/jenkins/diagnostics/Messages.properties`
- E-07: `test/src/test/java/jenkins/diagnostics/ControllerExecutorsNoAgentsTest.java`
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv`
- E-09: `core/src/main/java/jenkins/diagnostics/ControllerExecutorsAgents.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ControllerExecutorsNoAgentsはAdministrativeMonitorを継承 | E-01 (42行目: `extends AdministrativeMonitor`) | ○ |
| C-02 | @Extensionアノテーションで自動登録 | E-01 (39行目: `@Extension`) | ○ |
| C-03 | Symbol名はexecutorsOnBuiltInNodeWithoutAgentsとcontrollerExecutorsWithoutAgents | E-01 (40行目: `@Symbol({"executorsOnBuiltInNodeWithoutAgents", "controllerExecutorsWithoutAgents"})`) | ○ |
| C-04 | NoExternalUse制限がある | E-01 (41行目: `@Restricted(NoExternalUse.class)`) | ○ |
| C-05 | isSecurity()がtrueを返す | E-01 (49-52行目: `return true;`) | ○ |
| C-06 | 開発モードでないことが有効化条件 | E-01 (68行目: `!Main.isDevelopmentMode`) | ○ |
| C-07 | エグゼキュータ数1以上が有効化条件 | E-01 (68行目: `Jenkins.get().getNumExecutors() > 0`) | ○ |
| C-08 | クラウドもエージェントも存在しないことが有効化条件 | E-01 (69行目: `Jenkins.get().clouds.isEmpty() && Jenkins.get().getNodes().isEmpty()`) | ○ |
| C-09 | doAct()は@RequirePOST | E-01 (54行目: `@RequirePOST`) | ○ |
| C-10 | "no"パラメータでdisable(true)実行 | E-01 (56-58行目: `if (req.hasParameter("no"))`) | ○ |
| C-11 | "cloud"パラメータでクラウド設定画面へ遷移 | E-01 (59-60行目: `/manage/cloud/`) | ○ |
| C-12 | "agent"パラメータでエージェント追加画面へ遷移 | E-01 (61-63行目: `/computer/new`) | ○ |
| C-13 | 警告スタイルはjenkins-alert-warning | E-03 (27行目: `class="jenkins-alert jenkins-alert-warning"`) | ○ |
| C-14 | 3つのボタン（Set up agent、Set up cloud、Dismiss）がある | E-03 (29-31行目: `name="agent"`, `name="cloud"`, `name="no"`) | ○ |
| C-15 | 警告メッセージに分散ビルド設定の推奨がある | E-04 (23-25行目: `You should set up distributed builds`) | ○ |
| C-16 | ドキュメントリンクが含まれる | E-04 (25行目: `https://www.jenkins.io/redirect/building-on-controller/`) | ○ |
| C-17 | 説明文はモニターの目的を記述 | E-05 (1行目: `Shows a warning when the built-in node has executors and recommends that agents`) | ○ |
| C-18 | DisplayNameはMessages.propertiesで定義 | E-06 (5行目: `ControllerExecutorsNoAgents.DisplayName=Built-in Node Without Agents Executors Configured Monitor`) | ○ |
| C-19 | テストで初期状態（エージェントなし）でisActivated()がtrue | E-07 (49-53行目: `testInitial()`) | ○ |
| C-20 | テストでエグゼキュータ0の場合isActivated()がfalse | E-07 (55-60行目: `testControllerExecutorsZero()`) | ○ |
| C-21 | テストでエージェント追加時にisActivated()がfalse | E-07 (62-67行目: `testHasAgent()`) | ○ |
| C-22 | No.42 ControllerExecutorsAgentsと排他的関係 | E-01 (69行目: clouds/nodesが空), E-09 (57行目: clouds/nodesが非空) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張にソースコード根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] ControllerExecutorsNoAgents.javaの行番号が実際のコードと一致するか確認
- [ ] message.propertiesの警告メッセージが最新か確認
- [ ] No.42との排他的関係が正しく機能するか確認
- [ ] テストケースがすべてのエッジケースをカバーしているか確認
