---
generated_at: 2026-01-22 20:40:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-リバースプロキシ設定警告（ReverseProxySetupMonitor）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/diagnosis/ReverseProxySetupMonitor.java`
- E-02: `core/src/main/java/hudson/model/AdministrativeMonitor.java`
- E-03: `core/src/main/resources/hudson/diagnosis/ReverseProxySetupMonitor/message.jelly`
- E-04: `core/src/main/resources/hudson/diagnosis/Messages.properties`
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv`
- E-06: `test/src/test/java/hudson/diagnosis/ReverseProxySetupMonitorTest.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isActivated()は常にtrue | E-01 (64-67行目) | ○ |
| C-02 | isActivationFake()はtrue | E-01 (70-72行目) | ○ |
| C-03 | doTest()でテストリクエスト処理 | E-01 (74-95行目) | ○ |
| C-04 | testWithContextパラメータでコンテキストパス考慮 | E-01 (81-89行目) | ○ |
| C-05 | HttpRedirectでテストURLへリダイレクト | E-01 (94行目) | ○ |
| C-06 | getTestForReverseProxySetup()でリダイレクト検証 | E-01 (97-110行目) | ○ |
| C-07 | getRootUrlFromRequest()で推測URL取得 | E-01 (102行目) | ○ |
| C-08 | URL一致で200 OK | E-01 (105行目: HttpResponses.ok()) | ○ |
| C-09 | URL不一致で404 Error | E-01 (107-108行目: errorWithoutStack) | ○ |
| C-10 | getRequiredPermission()でSYSTEM_READ | E-01 (113-115行目) | ○ |
| C-11 | doAct()で@RequirePOST保護 | E-01 (122行目) | ○ |
| C-12 | "yes"でJenkins公式ドキュメントへリダイレクト | E-01 (130行目) | ○ |
| C-13 | @Extension, @Symbolアノテーションで登録 | E-01 (58行目) | ○ |
| C-14 | Symbol名は"reverseProxy" | E-01 (58行目) | ○ |
| C-15 | message.jellyでreverse-proxy__hidden使用 | E-03 (26行目) | ○ |
| C-16 | st:adjunctでJavaScriptリソース読み込み | E-03 (37行目) | ○ |
| C-17 | テストファイルが存在 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要な機能・処理フローがソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] isActivationFake()の特殊な動作が正しく説明されているか確認
- [ ] クライアントサイドJavaScriptテストの流れが正しく説明されているか確認
- [ ] URL検証ロジックが正しく説明されているか確認
