---
generated_at: 2026-01-22 20:44:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-更新サイト警告通知（UpdateSiteWarningsMonitor）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/security/UpdateSiteWarningsMonitor.java`
- E-02: `core/src/main/java/jenkins/security/UpdateSiteWarningsConfiguration.java`
- E-03: `core/src/main/java/hudson/model/UpdateSite.java`
- E-04: `core/src/main/resources/jenkins/security/UpdateSiteWarningsMonitor/message.groovy`
- E-05: `core/src/main/resources/jenkins/security/Messages.properties`
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isSiteDataReady()でサイトデータ準備チェック | E-01 (84行目) | ○ |
| C-02 | getActiveCoreWarnings()でコア警告取得 | E-01 (95-106行目) | ○ |
| C-03 | getActivePluginWarningsByPlugin()でプラグイン警告取得 | E-01 (108-127行目) | ○ |
| C-04 | getActiveWarnings()で適用可能警告から非表示除外 | E-01 (130-141行目) | ○ |
| C-05 | isSecurity()がtrue | E-01 (91-93行目) | ○ |
| C-06 | getRequiredPermission()でSYSTEM_READ | E-01 (170-173行目) | ○ |
| C-07 | doForward()で@RequirePOST保護 | E-01 (146行目) | ○ |
| C-08 | @Extension, @Restrictedアノテーション | E-01 (79-80行目) | ○ |
| C-09 | hasApplicableHiddenWarnings()で非表示警告確認 | E-01 (165-168行目) | ○ |
| C-10 | Warning.type == COREでコア警告判定 | E-01 (99行目) | ○ |
| C-11 | Warning.type == PLUGINでプラグイン警告判定 | E-01 (112行目) | ○ |
| C-12 | UpdateSiteWarningsConfiguration使用 | E-01 (131行目), E-02 | ○ |
| C-13 | getApplicableWarnings()で適用可能警告取得 | E-01 (134行目), E-02 | ○ |
| C-14 | getIgnoredWarnings()で非表示設定取得 | E-01 (135行目), E-02 | ○ |
| C-15 | message.groovyでjenkins-alert-danger使用 | E-04 (67行目) | ○ |
| C-16 | l.isAdmin()で管理者のみボタン表示 | E-04 (69行目) | ○ |
| C-17 | isFixable()で修正可能性判定 | E-04 (35行目) | ○ |
| C-18 | DisplayNameはMessages.propertiesで定義 | E-05 (50行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要な機能・処理フローがソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] isActivated()の条件が正しく説明されているか確認
- [ ] 警告分類（CORE/PLUGIN）が正しく説明されているか確認
- [ ] 非表示設定との連携が正しく説明されているか確認
