---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **対応ブラウザ一覧**：実際の動作確認情報が不足
  2. **ユーザー種別と権限**：認可戦略の詳細設定に依存
  3. **サポート連絡方法**：組織固有の情報が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - プロジェクト概要
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-03: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-07: `docs/code-to-docs/画面設計書/1-ダッシュボード（View一覧）.md` - ダッシュボード画面設計書
- E-08: `docs/code-to-docs/画面設計書/4-ログイン.md` - ログイン画面設計書
- E-09: `docs/code-to-docs/画面設計書/2-新規ジョブ作成.md` - 新規ジョブ作成画面設計書
- E-10: `docs/code-to-docs/画面設計書/11-ジョブ詳細.md` - ジョブ詳細画面設計書
- E-11: `docs/code-to-docs/画面設計書/12-ジョブ設定.md` - ジョブ設定画面設計書
- E-12: `docs/code-to-docs/画面設計書/14-ビルド詳細.md` - ビルド詳細画面設計書
- E-13: `docs/code-to-docs/画面設計書/15-コンソール出力.md` - コンソール出力画面設計書
- E-14: `docs/code-to-docs/画面設計書/21-ノード一覧.md` - ノード一覧画面設計書
- E-15: `docs/code-to-docs/画面設計書/28-Jenkins管理.md` - Jenkins管理画面設計書
- E-16: `docs/code-to-docs/画面設計書/43-ユーザー一覧.md` - ユーザー一覧画面設計書
- E-17: `docs/code-to-docs/画面設計書/51-セットアップウィザード.md` - セットアップウィザード画面設計書

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Jenkinsはオープンソースの自動化サーバー | E-01 | ○ |
| C-02 | 2,000以上のプラグインをサポート | E-01 | ○ |
| C-03 | ビルド、テスト、デプロイの自動化を実現 | E-01, E-04, E-05 | ○ |
| C-04 | CI/CDの業界標準ツール | E-01 | ○ |
| C-05 | ログイン画面のURL形式 | E-08 | ○ |
| C-06 | ログイン画面の入力項目（j_username, j_password） | E-08 | ○ |
| C-07 | Keep me signed in（Remember Me）機能の存在 | E-08 | ○ |
| C-08 | 認証成功後ダッシュボードへ遷移 | E-08 | ○ |
| C-09 | 初期パスワードの保存場所（secrets/initialAdminPassword） | E-17 | ○ |
| C-10 | ダッシュボードの構成要素（ヘッダー、サイドパネル等） | E-07 | ○ |
| C-11 | ジョブ一覧テーブルの表示項目 | E-07 | ○ |
| C-12 | ジョブステータスアイコンの色（青=成功、赤=失敗等） | E-07, E-10 | ○ |
| C-13 | ビルドボタンによる即時実行 | E-07 | ○ |
| C-14 | 新規ジョブ作成画面のURL | E-09 | ○ |
| C-15 | ジョブ名の使用不可文字 | E-09 | ○ |
| C-16 | 既存ジョブからのコピー機能 | E-09 | ○ |
| C-17 | ジョブ設定画面の各セクション | E-11 | ○ |
| C-18 | Job.CONFIGURE権限による編集制限 | E-11 | ○ |
| C-19 | パラメータ付きビルドの入力画面 | E-07, E-10 | ○ |
| C-20 | ビルド実行結果の種類（SUCCESS, FAILURE等） | E-12 | ○ |
| C-21 | コンソール出力のリアルタイム表示 | E-13 | ○ |
| C-22 | コンソール出力のダウンロード・コピー機能 | E-13 | ○ |
| C-23 | ビルド成果物のダウンロード | E-12 | ○ |
| C-24 | ビルド保持機能（ログローテーション除外） | E-12 | ○ |
| C-25 | Jenkins管理画面のアクセス方法 | E-15 | ○ |
| C-26 | Jenkins管理画面のセクション構成 | E-15 | ○ |
| C-27 | 安全な再起動機能 | E-03, E-15 | ○ |
| C-28 | ノード一覧画面の表示項目 | E-14 | ○ |
| C-29 | 新規ノード追加の手順 | E-14 | ○ |
| C-30 | ノードのオフライン設定 | E-14 | ○ |
| C-31 | プラグイン管理画面のタブ構成 | E-02, E-04 | ○ |
| C-32 | ユーザー一覧画面の機能 | E-16 | ○ |
| C-33 | ユーザー作成・削除の手順 | E-16 | ○ |
| C-34 | 自分自身のアカウント削除不可 | E-16 | ○ |
| C-35 | 画面遷移の流れ | E-03 | ○ |
| C-36 | 権限による表示制御（Job.READ, Job.BUILD等） | E-05, E-10, E-11 | ○ |
| C-37 | セットアップウィザードの流れ | E-17 | ○ |
| C-38 | パラメータ種別（文字列、選択、ブール、ファイル） | E-04, E-05 | ○ |
| C-39 | SCMトリガー、タイマートリガーの設定 | E-04, E-05, E-11 | ○ |
| C-40 | ビルドステップの設定項目 | E-04, E-05, E-11 | ○ |
| C-41 | ビルド後の処理の設定項目 | E-04, E-05 | ○ |
| C-42 | エラーメッセージ「Invalid username or password」 | E-08 | ○ |
| C-43 | 対応ブラウザ一覧 | **根拠なし** | △ |
| C-44 | ユーザー種別（管理者、開発者、閲覧者）の詳細 | **根拠不足** | △ |
| C-45 | サポート連絡方法の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **対応ブラウザ一覧（C-43）**
  - 理由：一般的な推奨ブラウザを記載したが、Jenkinsの公式ドキュメントでの動作確認情報が確認できなかった
  - 候補：Jenkins公式ドキュメント / ブラウザ互換性テスト結果 / package.json の browserslist設定

- **ユーザー種別の詳細（C-44）**
  - 理由：ユーザー種別は認可戦略（AuthorizationStrategy）の設定に依存し、実際の権限構成は環境によって異なる
  - 候補：jenkins.model.Jenkins.configure / AuthorizationStrategy実装クラス / 実際の権限マトリックス設定

- **サポート連絡方法（C-45）**
  - 理由：組織固有の情報であり、ソースコードから抽出できない
  - 候補：組織のサポートポリシー / 運用担当者情報 / ヘルプデスクシステム

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 説明 |
|------------|------|------|
| 0 (低) | システム概要 | README.mdおよび画面設計書に基づく正確な記述 |
| 0 (低) | ログイン手順 | ログイン画面設計書に基づく正確な記述 |
| 0 (低) | ダッシュボード説明 | ダッシュボード画面設計書に基づく正確な記述 |
| 0 (低) | ジョブ操作手順 | 複数の画面設計書に基づく正確な記述 |
| 0 (低) | ビルド操作手順 | ビルド関連画面設計書に基づく正確な記述 |
| 1 (中) | 管理者機能 | 権限設定に依存する部分があり、環境により異なる可能性 |
| 1 (中) | ブラウザ互換性 | 一般的な推奨ブラウザを記載、実際の動作確認が必要 |
| 2 (高) | サポート連絡方法 | 組織固有情報のため、実環境に合わせた修正が必要 |

## 6) レビュアーチェックリスト（最小）

- [ ] 1章「システム概要」の機能説明が実際のJenkins機能と一致しているか確認
- [ ] 2章「ログイン手順」の画面項目が実際のログイン画面と一致しているか確認
- [ ] 3章「ダッシュボード」の説明が実際の画面構成と一致しているか確認
- [ ] 4章「ジョブ作成」の手順が実際の操作フローと一致しているか確認
- [ ] 5章「ビルド実行」の手順が実際の操作フローと一致しているか確認
- [ ] 6章「ビルド結果確認」の説明が実際の画面と一致しているか確認
- [ ] 7章「システム管理」の機能が管理者権限で実行可能か確認
- [ ] 8-10章のサポート機能が実際の画面と一致しているか確認
- [ ] 対応ブラウザ一覧を実際の動作確認結果に基づいて更新
- [ ] ユーザー種別と権限の説明を実際の認可戦略設定に合わせて修正
- [ ] サポート連絡方法を組織の実際の連絡先に更新
- [ ] スクリーンショットの追加を検討（操作手順の理解向上のため）
- [ ] 用語集の追加を検討（CI/CD用語の説明のため）
