# Jenkins 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [ダッシュボード（TOP画面）](#3-ダッシュボードtop画面)

**【業務フローに沿った機能】**
4. [【STEP1】ジョブの作成・設定](#4-step1ジョブの作成設定)
5. [【STEP2】ビルドの実行・監視](#5-step2ビルドの実行監視)
6. [【STEP3】ビルド結果の確認](#6-step3ビルド結果の確認)
7. [【STEP4-5】システム管理（管理者向け）](#7-step4-5システム管理管理者向け)

**【サポート機能】**
8. [ノード管理機能](#8-ノード管理機能)
9. [プラグイン管理機能](#9-プラグイン管理機能)
10. [ユーザー管理機能](#10-ユーザー管理機能)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 Jenkinsとは

Jenkinsは、Javaで構築されたオープンソースの自動化サーバーです。2,000以上のプラグインをサポートし、ビルド、テスト、デプロイなど、あらゆる開発ワークフローの自動化を実現します。継続的インテグレーション（CI）および継続的デリバリー（CD）の業界標準ツールとして、世界中で広く採用されています。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **ビルド自動化** | プロジェクトのビルドプロセスを自動化し、コード変更時に自動的にビルドを実行 |
| **テスト実行** | 単体テスト、結合テストを自動実行し、バグや問題を早期に検出 |
| **デプロイメント** | アプリケーションの各種環境への自動デプロイ |
| **監視・通知** | ビルド状態の監視とビルド結果の通知 |
| **分散ビルド** | 複数のノードでビルドを並列実行することでビルド時間を短縮 |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します：

```
+--------------------------------------------------------------------+
|                        CI/CD 業務フロー                              |
+--------------------------------------------------------------------+
|                                                                    |
|  【STEP 1】開発者またはCI管理者がジョブを作成・設定                   |
|      |                                                             |
|      v                                                             |
|  【STEP 2】ビルドの実行（手動または自動トリガー）                      |
|      |                                                             |
|      v                                                             |
|  【STEP 3】ビルド結果の確認（コンソール出力、成果物）                  |
|      |                                                             |
|      v                                                             |
|  【STEP 4】問題があれば修正、なければデプロイ・リリース               |
|      |                                                             |
|      v                                                             |
|  【STEP 5】管理者によるシステム監視・メンテナンス                     |
|                                                                    |
+--------------------------------------------------------------------+
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **管理者** | ジョブの作成・設定、ノード管理、プラグイン管理、ユーザー管理、システム監視 |
| **開発者** | ビルドの実行・監視、ビルド結果の確認、コンソール出力の確認、成果物のダウンロード |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| ジョブ作成・設定 | 新規ジョブの作成、ビルド設定、トリガー設定 | STEP 1 |
| ビルド実行 | 手動実行、パラメータ付きビルド、自動トリガー | STEP 2 |
| コンソール出力 | ビルドログのリアルタイム表示、問題の特定 | STEP 3 |
| 成果物管理 | ビルド成果物の保存、ダウンロード | STEP 3-4 |
| ノード管理 | ビルドエージェントの管理、分散ビルド | STEP 5 |
| プラグイン管理 | 機能拡張プラグインの管理 | STEP 5 |
| ユーザー管理 | ユーザーアカウントと権限の管理 | STEP 5 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| 管理者 | Jenkins全体の設定、ユーザー管理、プラグイン管理などの権限を持つ |
| 開発者 | ジョブの閲覧、ビルドの実行、結果の確認ができる |
| 閲覧者 | ジョブとビルド結果の閲覧のみ可能 |

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

---

## 2. ログイン・ログアウト手順

### 2.1 ログイン方法

1. ブラウザでJenkinsのログインページにアクセスします
   - URL例：`http://your-jenkins-server:8080/login`

2. ログイン画面が表示されます

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| Username | 管理者から付与されたユーザー名を入力 |
| Password | 管理者から付与されたパスワードを入力 |
| Keep me signed in | チェックを入れるとセッションが維持されます |

3. 「Sign in」ボタンをクリックします
4. 認証に成功すると、ダッシュボード画面が表示されます

**注意事項：**
- パスワードを複数回間違えるとアカウントがロックされる場合があります
- ログイン情報を他者と共有しないでください

### 2.2 ログアウト方法

1. 画面右上のユーザー名をクリックします
2. 表示されるドロップダウンメニューから「ログアウト」を選択します
3. ログイン画面に戻ります

### 2.3 パスワードを忘れた場合

パスワードを忘れた場合は、Jenkins管理者に連絡してください。管理者はユーザー管理画面からパスワードをリセットできます。

**初回セットアップ時のパスワード：**
- Jenkinsの初回起動時は、`$JENKINS_HOME/secrets/initialAdminPassword`ファイルに記載された初期パスワードを使用します

---

## 3. ダッシュボード（TOP画面）

### 3.1 ダッシュボード画面の構成

ダッシュボードはJenkinsのメイン画面であり、以下の要素で構成されています：

| エリア | 説明 |
|--------|------|
| ヘッダー | Jenkinsロゴ、検索ボックス、ユーザーメニュー |
| サイドパネル | ナビゲーションメニュー（新規ジョブ作成、ビルド履歴等） |
| メインエリア | ジョブ一覧テーブル |
| Viewタブ | ジョブをグループ化したViewの切り替えタブ |

### 3.2 ジョブ一覧の見方

ジョブ一覧テーブルには以下の情報が表示されます：

| 列名 | 説明 |
|------|------|
| ステータスアイコン | ジョブの最新ビルド状態を示すアイコン（青=成功、赤=失敗、灰=未実行） |
| ジョブ名 | ジョブの名前（クリックでジョブ詳細画面へ） |
| 最終成功ビルド | 最後に成功したビルドの番号と時刻 |
| 最終失敗ビルド | 最後に失敗したビルドの番号と時刻 |
| 最終ビルド時間 | 最後にビルドされた時刻 |
| ビルドボタン | クリックでビルドを即座に開始 |

### 3.3 主な操作

**ジョブ詳細画面への遷移：**
1. ジョブ名をクリックします
2. 該当ジョブの詳細画面が表示されます

**ビルドの即時実行：**
1. 対象ジョブの行にある時計アイコン（ビルドボタン）をクリックします
2. ビルドがキューに追加され、実行が開始されます
3. パラメータ付きジョブの場合は、パラメータ入力画面が表示されます

**Viewの切り替え：**
1. 画面上部のViewタブをクリックします
2. 選択したViewに含まれるジョブのみが表示されます

---

## 4. 【STEP1】ジョブの作成・設定

> **業務フローでの位置**: 開発者またはCI管理者が、自動化したいビルドプロセスを定義するステップです。

### 4.1 新規ジョブの作成手順

1. ダッシュボードのサイドパネルから「新規ジョブ作成」をクリックします
2. 新規ジョブ作成画面が表示されます

**入力項目：**

| 項目 | 説明 | 必須 |
|------|------|------|
| Enter an item name | ジョブの名前を入力（英数字、ハイフン、アンダースコア推奨） | 必須 |
| ジョブタイプ | Freestyle project、Pipelineなどから選択 | 必須 |

3. ジョブ名を入力します
   - 使用不可文字：`/`、`\`、`<`、`>`、`|`、`:`、`?`、`*`
   - 既存のジョブ名と重複しないように注意してください

4. ジョブタイプを選択します
   - **Freestyle project**: 最も汎用的なジョブタイプ
   - **Pipeline**: Jenkinsfileでパイプラインを定義するジョブタイプ
   - **Multi-configuration project**: 複数の設定を並列でビルド
   - **Folder**: ジョブをグループ化するフォルダ

5. 「OK」ボタンをクリックします
6. ジョブ設定画面が表示されます

**既存ジョブからコピーする場合：**
1. 「Copy from」オプションを選択します
2. コピー元のジョブ名を入力します（オートコンプリート対応）
3. 「OK」ボタンをクリックします

### 4.2 ジョブの基本設定

ジョブ設定画面では、以下のセクションを設定します：

**Generalセクション：**
- 説明：ジョブの説明文を入力
- ビルドの無効化：チェックするとビルドが一時停止

**ソースコード管理セクション：**
- Git、Subversionなどのリポジトリを設定
- リポジトリURL、認証情報、ブランチを指定

**ビルドトリガーセクション：**
- 定期的に実行（cron形式）：`H/15 * * * *`（15分ごと）
- SCMをポーリング：ソースコード変更を検知して自動ビルド
- 他のプロジェクトの後にビルド

**ビルドステップセクション：**
- シェルスクリプトの実行
- Mavenビルド
- バッチコマンドの実行

**ビルド後の処理セクション：**
- 成果物のアーカイブ
- テスト結果の公開
- メール通知

### 4.3 設定の保存

1. すべての設定が完了したら「保存」ボタンをクリックします
2. ジョブ詳細画面に遷移します
3. 設定を保存せずに続けて編集する場合は「適用」ボタンをクリックします

**注意事項：**
- 設定変更には`Job.CONFIGURE`権限が必要です
- 設定変更後は必ず動作確認のためテストビルドを実行してください

---

## 5. 【STEP2】ビルドの実行・監視

> **業務フローでの位置**: 設定されたジョブを実行し、ビルドの進行状況を監視するステップです。

### 5.1 ビルドの実行方法

**手動でビルドを実行する（通常のジョブ）：**
1. ジョブ詳細画面のサイドパネルから「ビルド実行」をクリックします
2. ビルドがキューに追加され、実行が開始されます
3. ビルド履歴に新しいビルド番号が表示されます

**手動でビルドを実行する（パラメータ付きジョブ）：**
1. ジョブ詳細画面のサイドパネルから「パラメータ付きビルド」をクリックします
2. パラメータ入力画面が表示されます
3. 必要なパラメータを入力します
   - 文字列パラメータ：テキストを入力
   - 選択パラメータ：ドロップダウンから選択
   - ブールパラメータ：チェックボックスのオン/オフ
   - ファイルパラメータ：ファイルをアップロード
4. 「ビルド」ボタンをクリックします

**ダッシュボードからビルドを実行する：**
1. ダッシュボードのジョブ一覧で、対象ジョブの行にある時計アイコンをクリックします
2. パラメータ付きジョブの場合はパラメータ入力画面へ、それ以外は即座にビルドが開始されます

### 5.2 ビルドの監視

**ビルド状況の確認：**
- ジョブ詳細画面のビルド履歴セクションで、実行中のビルドを確認できます
- ビルド中はアイコンが点滅または回転して表示されます
- 進捗バーでビルドの完了度を確認できます

**リアルタイムでコンソール出力を確認：**
1. ビルド履歴から実行中のビルド番号をクリックします
2. サイドパネルから「コンソール出力」をクリックします
3. ビルドログがリアルタイムで表示されます
4. ビルドが完了するまでログが自動更新されます

### 5.3 ビルドのキャンセル

1. 実行中のビルド番号をクリックしてビルド詳細画面を開きます
2. サイドパネルから「ビルドの中止」をクリックします
3. ビルドが中止され、結果が「ABORTED」になります

---

## 6. 【STEP3】ビルド結果の確認

> **業務フローでの位置**: ビルドが完了した後、結果を確認し、問題があれば対処するステップです。

### 6.1 ビルド結果の種類

| 結果 | アイコン色 | 説明 |
|------|----------|------|
| SUCCESS | 青 | ビルドが正常に完了 |
| UNSTABLE | 黄 | ビルドは完了したがテスト失敗などの問題あり |
| FAILURE | 赤 | ビルドが失敗 |
| ABORTED | 灰 | ビルドが中止された |

### 6.2 ビルド詳細画面の確認

1. ジョブ詳細画面のビルド履歴から、確認したいビルド番号をクリックします
2. ビルド詳細画面が表示されます

**表示される情報：**
- ビルド番号と実行日時
- ビルド所要時間
- ビルド結果（SUCCESS/FAILURE等）
- ビルド説明（設定されている場合）
- 成果物一覧
- 変更履歴（SCM連携時）

### 6.3 コンソール出力の確認

1. ビルド詳細画面のサイドパネルから「コンソール出力」をクリックします
2. ビルドの全ログが表示されます

**コンソール出力画面の操作：**
- 「ダウンロード」ボタン：ログをテキストファイルとしてダウンロード
- 「コピー」ボタン：ログ内容をクリップボードにコピー
- 「プレーンテキストで表示」：装飾なしのテキスト形式で表示

**エラーの特定方法：**
1. コンソール出力を下から上に向かって確認します
2. 「ERROR」「FAILURE」「Exception」などのキーワードを探します
3. エラーメッセージの前後の文脈を確認して原因を特定します

### 6.4 成果物のダウンロード

1. ビルド詳細画面の「ビルド成果物」セクションを確認します
2. ダウンロードしたいファイル名をクリックします
3. ファイルがダウンロードされます

**複数の成果物がある場合：**
- 「成果物一覧」リンクをクリックして一覧画面を表示
- 必要なファイルを個別にダウンロード

### 6.5 ビルドの保持設定

重要なビルドをログローテーションから除外して永久保持する場合：

1. ビルド詳細画面のサイドパネルから「ビルドを保持」をクリックします
2. ビルドが保持状態になり、自動削除されなくなります
3. 解除する場合は同じボタンをクリックします

---

## 7. 【STEP4-5】システム管理（管理者向け）

> **業務フローでの位置**: 管理者がシステム全体の設定・監視・メンテナンスを行うステップです。

### 7.1 Jenkins管理画面へのアクセス

1. ダッシュボードのサイドパネルから「Jenkinsの管理」をクリックします
2. Jenkins管理画面が表示されます

**管理画面のセクション：**

| カテゴリ | 主な機能 |
|---------|---------|
| システム設定 | Jenkinsのグローバル設定、セキュリティ設定 |
| ステータス情報 | システム情報、負荷統計、システムログ |
| トラブルシューティング | スレッドダンプ、メモリ情報 |
| ツール | プラグイン管理、ノード管理、ユーザー管理 |

### 7.2 システム設定

1. Jenkins管理画面から「システム設定」をクリックします
2. グローバル設定画面が表示されます

**主な設定項目：**
- Jenkins URL：外部からアクセスするためのURL
- システム管理者メールアドレス：通知用メールアドレス
- グローバルプロパティ：環境変数の設定
- JDK、Git、Mavenなどのツール設定

3. 設定を変更したら「保存」ボタンをクリックします

### 7.3 セキュリティ設定

1. Jenkins管理画面から「セキュリティ設定」をクリックします
2. セキュリティ設定画面が表示されます

**主な設定項目：**
- セキュリティレルム：認証方式（Jenkins独自、LDAP等）
- 認可戦略：権限管理方式
- CSRF対策：クロスサイトリクエストフォージェリ対策
- エージェント接続設定

### 7.4 システム情報の確認

1. Jenkins管理画面から「システム情報」をクリックします
2. 以下の情報が表示されます：
   - システムプロパティ（Javaバージョン等）
   - 環境変数
   - プラグイン一覧

### 7.5 再起動の実行

**安全な再起動（推奨）：**
1. Jenkins管理画面から「安全な再起動を準備」をクリックします
2. 実行中のジョブが完了するのを待ってから再起動されます
3. 新しいビルドはキューに入り、再起動後に実行されます

**即座の再起動：**
1. Jenkins管理画面から「再起動」をクリックします
2. 確認ダイアログで「はい」をクリックします
3. 実行中のジョブは中断される可能性があります

---

## 8. ノード管理機能

### 8.1 ノード一覧画面

1. Jenkins管理画面から「ノード管理」をクリックします
2. ノード一覧画面が表示されます

**表示される情報：**
| 列名 | 説明 |
|------|------|
| ステータスアイコン | ノードの状態（オンライン/オフライン） |
| ノード名 | ノードの名前 |
| アーキテクチャ | OS、CPUアーキテクチャ |
| ディスク容量 | 利用可能なディスク容量 |
| 応答時間 | ノードとの通信遅延 |

### 8.2 新規ノードの追加

1. ノード一覧画面で「新規ノード」ボタンをクリックします
2. ノード名を入力し、ノードタイプを選択します
3. 「OK」ボタンをクリックします
4. ノード設定画面で以下を設定します：
   - リモートルートディレクトリ
   - ラベル
   - 起動方法（SSH、JNLP等）
   - エグゼキュータ数
5. 「保存」ボタンをクリックします

### 8.3 ノードのオフライン設定

1. ノード一覧からオフラインにするノード名をクリックします
2. サイドパネルから「一時的にオフラインにする」をクリックします
3. オフライン理由を入力します
4. 「オフラインにする」ボタンをクリックします

**オンラインに戻す場合：**
1. オフライン中のノード詳細画面を開きます
2. 「オンラインに戻す」ボタンをクリックします

---

## 9. プラグイン管理機能

### 9.1 インストール済みプラグインの確認

1. Jenkins管理画面から「プラグイン管理」をクリックします
2. 「インストール済み」タブをクリックします
3. インストールされているプラグインの一覧が表示されます

### 9.2 プラグインのインストール

1. プラグイン管理画面で「利用可能」タブをクリックします
2. 検索ボックスでプラグイン名を検索します
3. インストールするプラグインにチェックを入れます
4. 「ダウンロードして再起動後にインストール」または「インストール」をクリックします
5. インストール進捗画面が表示されます

### 9.3 プラグインの更新

1. プラグイン管理画面で「更新」タブをクリックします
2. 更新可能なプラグインの一覧が表示されます
3. 更新するプラグインにチェックを入れます
4. 「ダウンロードして再起動後にインストール」をクリックします

**注意事項：**
- プラグイン更新後は再起動が必要です
- 更新前にバックアップを取ることを推奨します

---

## 10. ユーザー管理機能

### 10.1 ユーザー一覧の確認

1. Jenkins管理画面から「ユーザー管理」をクリックします
2. 登録されているユーザーの一覧が表示されます

**表示される情報：**
- ユーザーID
- 表示名
- アバター画像

### 10.2 新規ユーザーの作成

1. ユーザー一覧画面で「ユーザー作成」ボタンをクリックします
2. ユーザー追加画面が表示されます
3. 以下の情報を入力します：
   - ユーザー名
   - パスワード（確認用含む）
   - フルネーム
   - メールアドレス
4. 「ユーザー作成」ボタンをクリックします

### 10.3 ユーザーの削除

1. ユーザー一覧から削除するユーザーを選択します
2. 削除アイコン（ゴミ箱）をクリックします
3. 確認ダイアログが表示されます
4. 「OK」をクリックして削除を確定します

**注意事項：**
- 自分自身のアカウントは削除できません
- 削除したユーザーは復元できません

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
CI/CD 業務フロー概要（再掲）
============================================================
【STEP 1】開発者またはCI管理者がジョブを作成・設定 -> 4章参照
    |
    v
【STEP 2】ビルドの実行（手動または自動トリガー） -> 5章参照
    |
    v
【STEP 3】ビルド結果の確認（コンソール出力、成果物） -> 6章参照
    |
    v
【STEP 4-5】管理者によるシステム監視・メンテナンス -> 7章参照
============================================================
```

### 11.1 【開発者】日常業務の流れ

**朝の確認作業：**
1. ダッシュボードにアクセスしてジョブの状態を確認します
2. 赤いアイコン（失敗）のジョブがないかチェックします
3. 失敗しているジョブがあれば、コンソール出力を確認して原因を調査します

**コード変更後の作業：**
1. コードをコミット・プッシュします
2. 自動ビルドが設定されている場合は、ビルドが開始されるのを待ちます
3. 手動ビルドの場合は、該当ジョブのビルドを実行します
4. コンソール出力でビルドの進行状況を監視します
5. ビルドが完了したら結果を確認します

**ビルド失敗時の対応：**
1. コンソール出力を確認してエラーの原因を特定します
2. 必要に応じてコードを修正します
3. 修正後、再度ビルドを実行して確認します

### 11.2 【管理者】日常業務の流れ

**朝の確認作業：**
1. ダッシュボードで全体の状況を確認します
2. Jenkins管理画面で管理通知（警告）を確認します
3. ノード一覧でエージェントの状態を確認します
4. プラグインの更新があれば検討します

**定期メンテナンス：**
1. 週次でプラグインの更新状況を確認します
2. 月次でディスク使用量を確認し、不要なビルドを削除します
3. 四半期ごとにJenkins本体の更新を検討します

### 11.3 【管理者】STEP4-5: システム監視

**監視すべき項目：**
- ビルドキューの滞留状況
- ノードのオンライン/オフライン状態
- ディスク使用量
- メモリ使用量
- プラグインの更新状況
- セキュリティ警告

---

## 12. よくある質問と対処法

### 12.1 ログインに関するQ&A

**Q: ログインできません**

A: 以下を確認してください：
1. ユーザー名とパスワードが正しいか確認します
2. Caps Lockがオフになっているか確認します
3. アカウントがロックされていないか管理者に確認します
4. ブラウザのキャッシュとCookieをクリアします

**Q: パスワードを忘れました**

A: Jenkins管理者に連絡して、パスワードのリセットを依頼してください。

### 12.2 ビルドに関するQ&A

**Q: ビルドが実行されません**

A: 以下を確認してください：
1. ジョブが無効化されていないか確認します
2. ビルドがキューに入っているか確認します
3. 利用可能なエグゼキュータがあるか確認します
4. ノードがオンラインであるか確認します

**Q: ビルドが失敗しました**

A: 以下の手順で原因を調査してください：
1. コンソール出力を確認します
2. エラーメッセージを特定します
3. エラーの前後の処理を確認します
4. 必要に応じてコードやビルド設定を修正します

**Q: ビルドが長時間実行されています**

A: 以下を確認してください：
1. コンソール出力で現在の処理を確認します
2. 無限ループやタイムアウト設定を確認します
3. 必要に応じてビルドを中止します

### 12.3 ジョブ設定に関するQ&A

**Q: ジョブの設定を変更できません**

A: `Job.CONFIGURE`権限があるか確認してください。権限がない場合は管理者に依頼してください。

**Q: ジョブを削除したい**

A: ジョブ詳細画面のサイドパネルから「ジョブの削除」をクリックします。削除は取り消しできないため、必要に応じてバックアップを取ってください。

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| Invalid username or password | ログイン情報が不正 | ユーザー名とパスワードを再確認。管理者にアカウント状態を確認 |
| Access Denied | 権限不足 | 必要な権限を管理者に依頼 |
| 404 Not Found | リソースが存在しない | URLが正しいか確認。ジョブやビルドが削除されていないか確認 |
| 500 Internal Server Error | サーバー内部エラー | 管理者に連絡。システムログを確認 |
| Queue is full | ビルドキューが満杯 | 実行中のビルドが完了するのを待つ。不要なビルドをキャンセル |
| No executors available | エグゼキュータ不足 | ノードの状態を確認。管理者にエグゼキュータの追加を依頼 |

### 13.2 よくあるトラブルと解決方法

**ビルドがキューに滞留している場合：**
1. ノード一覧で利用可能なノードがあるか確認します
2. ジョブの制限設定（ラベル指定等）を確認します
3. 他のビルドがエグゼキュータを占有していないか確認します

**ノードがオフラインになった場合：**
1. ノード詳細画面でオフライン理由を確認します
2. ネットワーク接続を確認します
3. エージェントのディスク容量、メモリを確認します
4. 必要に応じてエージェントを再起動します

**プラグインエラーが発生した場合：**
1. Jenkins管理画面で警告を確認します
2. 問題のあるプラグインを無効化または更新します
3. 互換性のあるバージョンに戻します

**ディスク容量が不足している場合：**
1. 古いビルド履歴を削除します
2. ワークスペースをクリーンアップします
3. ログローテーション設定を見直します
4. 必要に応じてディスクを増設します

### 13.3 サポートへの連絡方法

問題が解決しない場合は、以下の情報を添えてJenkins管理者に連絡してください：

1. 問題の発生日時
2. 問題が発生した画面のURL
3. 実行していた操作
4. エラーメッセージ（あれば）
5. 再現手順
6. スクリーンショット（可能であれば）

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-22 | 初版作成 |

---

*本マニュアルは、Jenkins CI/CDサーバーのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
