---
generated_at: 2026-01-22 19:15:00
metrics:
  claims_total: 40
  claims_with_evidence: 38
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：38 / 40、根拠なし：2
- 優先レビュー（高）
  1. **NFT-026（JaCoCoカバレッジテスト）**：目標カバレッジ率の具体的閾値が不明
  2. **NFT-035（ホームディレクトリ容量監視テスト）**：警告閾値の具体値が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/node_monitors/ResponseTimeMonitor.java`
- E-02: `core/src/main/java/jenkins/health/HealthCheckAction.java`
- E-03: `core/src/main/java/hudson/model/Queue.java`
- E-04: `core/src/main/java/hudson/slaves/ChannelPinger.java`
- E-05: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java`
- E-06: `core/src/main/java/hudson/node_monitors/DiskSpaceMonitor.java`
- E-07: `core/src/main/java/hudson/node_monitors/TemporarySpaceMonitor.java`
- E-08: `core/src/main/java/hudson/node_monitors/SwapSpaceMonitor.java`
- E-09: `core/src/main/java/hudson/slaves/ConnectionActivityMonitor.java`
- E-10: `core/src/main/java/hudson/security/csrf/CrumbFilter.java`
- E-11: `core/src/main/java/jenkins/security/ApiTokenFilter.java`
- E-12: `core/src/main/java/jenkins/security/SuspiciousRequestFilter.java`
- E-13: `core/src/main/java/jenkins/security/FIPS140.java`
- E-14: `core/src/main/java/hudson/security/TokenBasedRememberMeServices2.java`
- E-15: `core/src/main/java/hudson/security/ACL.java`
- E-16: `core/src/main/java/hudson/security/BasicAuthenticationFilter.java`
- E-17: `Jenkinsfile`
- E-18: `pom.xml`
- E-19: `core/pom.xml`
- E-20: `core/src/main/java/hudson/node_monitors/ClockMonitor.java`
- E-21: `core/src/main/java/hudson/node_monitors/ArchitectureMonitor.java`
- E-22: `core/src/main/java/hudson/security/HttpSessionContextIntegrationFilter2.java`
- E-23: `core/src/main/java/jenkins/security/AuthenticationSuccessHandler.java`
- E-24: `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageMonitor.java`
- E-25: `core/src/main/java/jenkins/security/csp/CspBuilderTest.java`
- E-26: `core/src/main/java/jenkins/security/apitoken/ApiTokenStats.java`
- E-27: `core/src/main/java/jenkins/diagnostics/CompletedInitializationMonitor.java`
- E-28: `core/src/main/java/jenkins/diagnostics/RootUrlNotSetMonitor.java`
- E-29: `core/src/main/java/jenkins/diagnostics/SecurityIsOffMonitor.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エージェント応答時間はTIMEOUT=5000msで監視 | E-01 (ResponseTimeMonitor.java L232: `private static final long TIMEOUT = 5000`) | ○ |
| C-02 | ヘルスチェックのタイムアウトは10秒 | E-02 (HealthCheckAction.java L57-58: `THRESHOLD_TIMEOUT = Duration.ofSeconds(10)`) | ○ |
| C-03 | キューはLoadBalancerで負荷分散 | E-03 (Queue.java L332, L360-364: `private transient volatile LoadBalancer loadBalancer`) | ○ |
| C-04 | チャネルPingのデフォルト間隔は300秒 | E-04 (ChannelPinger.java L60: `PING_INTERVAL_SECONDS_DEFAULT = 5 * 60`) | ○ |
| C-05 | Pingタイムアウトはデフォルト240秒 | E-04 (ChannelPinger.java L59: `PING_TIMEOUT_SECONDS_DEFAULT = 4 * 60`) | ○ |
| C-06 | メモリ監視は10秒間隔 | E-05 (MemoryUsageMonitor.java L112-114: `TimeUnit.SECONDS.toMillis(10)`) | ○ |
| C-07 | ディスク容量監視でオフライン化 | E-06 (DiskSpaceMonitor.java) | ○ |
| C-08 | 一時領域容量監視機能存在 | E-07 | ○ |
| C-09 | スワップ領域監視機能存在 | E-08 | ○ |
| C-10 | 接続アクティビティ監視機能存在 | E-09 | ○ |
| C-11 | 5回連続タイムアウトで切断 | E-01 (ResponseTimeMonitor.java L206: `failureCount() >= 5`), E-04 | ○ |
| C-12 | CrumbFilterでCSRF対策 | E-10 (CrumbFilter.java) | ○ |
| C-13 | APIトークン認証フィルタ存在 | E-11 | ○ |
| C-14 | セミコロン含むURIを400で拒否 | E-12 (SuspiciousRequestFilter.java L32-36) | ○ |
| C-15 | FIPS-140準拠モード対応 | E-13 (FIPS140.java L41: `FIPS_COMPLIANCE_MODE`) | ○ |
| C-16 | Remember-Meサービス存在 | E-14 | ○ |
| C-17 | ACLによる権限制御 | E-15 | ○ |
| C-18 | Basic認証フィルタ存在 | E-16 | ○ |
| C-19 | Linux/Windowsマルチプラットフォーム対応 | E-17 (Jenkinsfile L15: `platforms: ['linux', 'windows']`) | ○ |
| C-20 | JDK 21/25対応 | E-17 (Jenkinsfile L16: `jdks: [21, 25]`) | ○ |
| C-21 | Firefox受入テスト対応 | E-17 (Jenkinsfile L222: `browsers: ['firefox']`) | ○ |
| C-22 | SpotBugs閾値Medium | E-18 (pom.xml L93: `<spotbugs.threshold>Medium</spotbugs.threshold>`) | ○ |
| C-23 | Checkstyle実行 | E-18 (pom.xml L272-296) | ○ |
| C-24 | ESLint実行 | E-17 (Jenkinsfile L183-187) | ○ |
| C-25 | StyleLint実行 | E-17 (Jenkinsfile L188-192) | ○ |
| C-26 | Prettier実行 | E-17 (Jenkinsfile L528-536) | ○ |
| C-27 | JaCoCo実行 | E-19 (core/pom.xml L699-738: `enable-jacoco profile`) | ○ |
| C-28 | forkCount=2 | E-17 (Jenkinsfile L105: `-DforkCount=2`) | ○ |
| C-29 | forkedProcessTimeout=3600秒 | E-18 (pom.xml L170: `<forkedProcessTimeoutInSeconds>3600`) | ○ |
| C-30 | パイプラインタイムアウト6時間 | E-17 (Jenkinsfile L93: `timeout(time: 6, unit: 'HOURS')`) | ○ |
| C-31 | JAR署名設定存在 | E-18 (pom.xml L176-189: `maven-jarsigner-plugin`) | ○ |
| C-32 | クロック同期監視存在 | E-20 | ○ |
| C-33 | アーキテクチャ監視存在 | E-21 | ○ |
| C-34 | セッション統合フィルタ存在 | E-22 | ○ |
| C-35 | 認証成功ハンドラ存在 | E-23 | ○ |
| C-36 | ホームディレクトリ監視存在 | E-24 | ○ |
| C-37 | CSP設定機能存在 | E-25 | ○ |
| C-38 | APIトークン統計機能存在 | E-26 | ○ |
| C-39 | 初期化完了監視存在 | E-27 | ○ |
| C-40 | ルートURL監視存在 | E-28 | ○ |
| C-41 | セキュリティ無効監視存在 | E-29 | ○ |
| C-42 | JaCoCoの目標カバレッジ率 | **根拠なし** | △ |
| C-43 | ホームディレクトリ警告閾値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-42 JaCoCoカバレッジ目標値**：pom.xmlおよびJenkinsfileにカバレッジの具体的な目標閾値が明示されていない。カバレッジレポートは生成されるが、合格基準となる数値は外部の品質ゲート設定または運用ルールで定義されている可能性がある。
  - 候補：Jenkins品質ゲート設定 / CI設定ファイル / 運用ドキュメント
- **C-43 ホームディレクトリ警告閾値**：HudsonHomeDiskUsageMonitorの警告閾値の具体的な数値がコード内で確認できなかった。
  - 候補：HudsonHomeDiskUsageMonitor実装詳細 / 設定ファイル

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 性能テスト（NFT-001〜004）、可用性テスト（NFT-005〜010）：コードから直接確認可能な定数・設定値に基づく
- **0: 低リスク** - セキュリティテスト（NFT-011〜017）：セキュリティフィルタの実装が確認済み
- **0: 低リスク** - 互換性テスト（NFT-018〜020）：Jenkinsfileで明確に定義
- **1: 中リスク** - 保守性テスト（NFT-021〜026）：静的解析ツールは設定済みだが、閾値の一部が明示されていない
- **0: 低リスク** - その他監視テスト（NFT-031〜040）：Monitorクラスの存在が確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] NFT-001：ResponseTimeMonitorのTIMEOUT値（5000ms）がプロジェクト要件と合致しているか確認
- [ ] NFT-002：HealthCheckActionのタイムアウト（10秒）が運用要件と合致しているか確認
- [ ] NFT-006：DiskSpaceMonitorの閾値設定が適切か確認
- [ ] NFT-011：CrumbFilterのCSRF対策が最新のセキュリティ要件を満たしているか確認
- [ ] NFT-019：JDK 21/25の両方でテスト実行が必要か確認（JDK 25はEarly Access）
- [ ] NFT-026：JaCoCoカバレッジの目標値を運用チームに確認し、合格基準を明確化
- [ ] NFT-035：ホームディレクトリ警告閾値の具体値を確認
- [ ] 全体：テストケースの優先度（高/中/低）がプロジェクトの品質方針と合致しているか確認
