---
generated_at: 2026-01-22 19:15:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **具体的なSLA目標値**：運用環境依存のため根拠なし
  2. **稼働率目標**：コードから特定不可
  3. **計画停止時間**：コードから特定不可

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/ProxyConfiguration.java` (DEFAULT_CONNECT_TIMEOUT_MILLIS定義)
- E-02: `core/src/main/java/hudson/slaves/ChannelPinger.java` (Ping設定定義)
- E-03: `core/src/main/java/hudson/node_monitors/ResponseTimeMonitor.java` (応答タイムアウト定義)
- E-04: `core/src/main/java/jenkins/health/HealthCheckAction.java` (ヘルスチェック設定)
- E-05: `core/src/main/java/hudson/model/UpdateCenter.java` (プラグインダウンロードタイムアウト)
- E-06: `core/src/main/java/hudson/util/Retrier.java` (リトライ設定)
- E-07: `core/src/main/java/jenkins/model/GlobalSCMRetryCountConfiguration.java` (SCMリトライ設定)
- E-08: `core/src/main/java/hudson/security/csrf/CrumbFilter.java` (CSRF対策)
- E-09: `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` (認証実装)
- E-10: `core/src/main/java/hudson/logging/LogRecorderManager.java` (ログ管理)
- E-11: `pom.xml` (ビルド設定、依存関係)
- E-12: `Jenkinsfile` (CI設定、テスト設定)
- E-13: `core/src/main/java/jenkins/model/Jenkins.java` (コア機能)
- E-14: `core/src/main/java/hudson/model/Queue.java` (キュー管理)
- E-15: `war/pom.xml` (WAR設定)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTP接続タイムアウト 20秒 | E-01 (ProxyConfiguration.java:100) | ○ |
| C-02 | エージェントPingタイムアウト 240秒 | E-02 (ChannelPinger.java:59) | ○ |
| C-03 | ノード応答タイムアウト 5,000ms | E-03 (ResponseTimeMonitor.java:232) | ○ |
| C-04 | ヘルスチェックタイムアウト 10秒 | E-04 (HealthCheckAction.java:57-58) | ○ |
| C-05 | プラグインダウンロードタイムアウト 60秒 | E-05 (UpdateCenter.java:173) | ○ |
| C-06 | エージェントPing間隔 300秒 | E-02 (ChannelPinger.java:60) | ○ |
| C-07 | 連続タイムアウト許容回数 5回 | E-03 (ResponseTimeMonitor.java:206) | ○ |
| C-08 | Retrier デフォルト試行回数 3回 | E-06 (Retrier.java:114) | ○ |
| C-09 | Retrier デフォルト待機時間 1,000ms | E-06 (Retrier.java:115) | ○ |
| C-10 | SCMチェックアウトリトライ設定可能 | E-07 (GlobalSCMRetryCountConfiguration.java) | ○ |
| C-11 | CrumbFilterによるCSRF対策 | E-08 (CrumbFilter.java) | ○ |
| C-12 | SecurityRealmによる認証 | E-09, E-13 | ○ |
| C-13 | AuthorizationStrategyによる認可 | E-13 | ○ |
| C-14 | Secret暗号化 | E-01 (ProxyConfiguration.java:125) | ○ |
| C-15 | LogRecorderManagerによるログ管理 | E-10 (LogRecorderManager.java) | ○ |
| C-16 | HealthCheckActionによる監視API | E-04 (HealthCheckAction.java) | ○ |
| C-17 | テストフォークカウント 2 | E-12 (Jenkinsfile:105) | ○ |
| C-18 | HTTPキャッシュドスレッドプール | E-01 (ProxyConfiguration.java:371) | ○ |
| C-19 | UpdateSiteキャッシュドスレッドプール | E-05 (UpdateCenter.java:196-197) | ○ |
| C-20 | インストーラー単一スレッド | E-05 (UpdateCenter.java:190-191) | ○ |
| C-21 | Guava Cacheの使用 | E-14 (Queue.java:34) | ○ |
| C-22 | Extension拡張ポイント | E-13 | ○ |
| C-23 | Guice依存性注入 | E-13 (Jenkins.java:48) | ○ |
| C-24 | XStream2シリアライズ | E-01 (ProxyConfiguration.java:506) | ○ |
| C-25 | java.util.loggingフレームワーク | E-10 | ○ |
| C-26 | slf4j-jdk14バインディング | E-15 (war/pom.xml:106-108) | ○ |
| C-27 | SpotBugs静的解析 | E-11 (pom.xml:266-269) | ○ |
| C-28 | Checkstyle静的解析 | E-11 (pom.xml:273-296) | ○ |
| C-29 | Spotlessフォーマット | E-11 (pom.xml:306-324) | ○ |
| C-30 | ノードモニタリング機能 | E-03 | ○ |
| C-31 | クラウドプロビジョニング対応 | E-13 | ○ |
| C-32 | 双方向Ping実装 | E-02 (ChannelPinger.java:117-126) | ○ |
| C-33 | 具体的なSLA目標値 | **根拠なし** | △ |
| C-34 | 稼働率目標 | **根拠なし** | △ |
| C-35 | 計画停止時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **具体的なSLA目標値**：コードからは設定のデフォルト値のみ特定可能。運用レベルでの目標値は別途定義が必要
  - 候補：運用マニュアル / SLA契約書 / 要件定義書
- **稼働率目標**：コードベースからは稼働率のSLA目標は特定できない
  - 候補：運用要件定義 / SLA定義書
- **計画停止時間（RTO/RPO）**：災害復旧要件はコードからは特定不可
  - 候補：BCP文書 / 災害復旧計画書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - タイムアウト値、リトライ設定（コードから明確に特定）
- 0: 低リスク - セキュリティ機能の実装有無（コードで確認済み）
- 1: 中リスク - 運用レベルの具体的な目標値（運用環境依存）
- 1: 中リスク - プラグインによる追加要件（プラグイン依存）
- 2: 高リスク - SLA/稼働率目標（コードからは特定不可、要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] タイムアウト値が運用要件と合致しているか確認
- [ ] リトライ設定が想定される障害シナリオに対応しているか確認
- [ ] セキュリティ要件（認証・認可）が組織ポリシーを満たしているか確認
- [ ] ロギング設定が監査要件を満たしているか確認
- [ ] 具体的なSLA目標値を別途定義する必要があるか確認
- [ ] プラグインによる追加の非機能要件を洗い出す必要があるか確認
