# 非機能要件定義書

## 概要

本ドキュメントは、Jenkins (バージョン 2.548) の非機能要件を定義します。Jenkinsは継続的インテグレーション/継続的デリバリー(CI/CD)サーバーであり、本書ではパフォーマンス、可用性、セキュリティ、拡張性、保守性、運用・監視に関する要件を記載します。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| HTTP接続タイムアウト | 20秒以内 | `ProxyConfiguration.DEFAULT_CONNECT_TIMEOUT_MILLIS` で設定。システムプロパティ `hudson.ProxyConfiguration.DEFAULT_CONNECT_TIMEOUT_MILLIS` で変更可能 |
| エージェントPingタイムアウト | 240秒 (4分) | `ChannelPinger.PING_TIMEOUT_SECONDS_DEFAULT` で設定。システムプロパティで変更可能 |
| ノード応答タイムアウト | 5,000ミリ秒 | `ResponseTimeMonitor.TIMEOUT` で設定 |
| ヘルスチェックタイムアウト | 10秒 | `HealthCheckAction.thresholdTimeout` システムプロパティで変更可能 |
| プラグインダウンロード読み取りタイムアウト | 60秒 | `UpdateCenter.pluginDownloadReadTimeoutSeconds` システムプロパティで変更可能 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| テストフォークカウント | 2 | ビルド時のSurefireプラグイン設定 (`-DforkCount=2`) |
| HTTP接続プール | キャッシュドスレッドプール | `ProxyConfiguration.httpClientExecutor` で管理 |
| UpdateSiteデータダウンロード | キャッシュドスレッドプール | 並列ダウンロードをサポート |
| インストールスレッド | 最大1スレッド | `UpdateCenter.installerService` で単一スレッド実行を保証 |

### キャッシュ設定

| キャッシュ対象 | 設定 | 備考 |
| --- | --- | --- |
| Queueキャッシュ | Guava Cache | `Queue` クラスで使用 |
| UserDetailsキャッシュ | 有効 | `jenkins.security.UserDetailsCache` で管理 |
| ClassLoader キャッシュ | 有効 | `CachingClassLoader` で実装 |
| SCM Browser キャッシュ | 有効 | `AutoBrowserHolder` で実装 |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| エージェントPing間隔 | 300秒 (5分) | `ChannelPinger.PING_INTERVAL_SECONDS_DEFAULT` で設定。接続維持のための定期的な疎通確認 |
| 連続タイムアウト許容回数 | 5回 | `ResponseTimeMonitor.Data.hasTooManyTimeouts()` で判定。5回連続タイムアウトでエージェント切断 |
| SCMチェックアウトリトライ回数 | 設定可能 | `GlobalSCMRetryCountConfiguration` で設定 |
| ビルドログ保持 | 設定可能 | `buildDiscarder` で保持期間/数を制御 |

### リトライ設定

| 項目 | デフォルト値 | 備考 |
| --- | --- | --- |
| Retryer デフォルト試行回数 | 3回 | `Retrier.Builder.attempts` |
| Retryer デフォルト待機時間 | 1,000ミリ秒 | `Retrier.Builder.delay` |

### 冗長構成

| 機能 | 説明 |
| --- | --- |
| エージェント分散 | マスター/エージェント構成によるビルド実行の分散 |
| クラウドプロビジョニング | `Cloud` 拡張ポイントによる動的エージェント生成 |
| ノードモニタリング | `ResponseTimeMonitor` によるエージェント健全性監視 |
| チャネルPing | 双方向Pingによる接続維持と障害検知 |

## セキュリティ要件

### 認証・認可

| 項目 | 実装 |
| --- | --- |
| 認証レルム | `SecurityRealm` 拡張ポイント（LDAP、Active Directory、Jenkins内蔵等） |
| 認可戦略 | `AuthorizationStrategy` 拡張ポイント（マトリックス、ロールベース等） |
| パスワードエンコーディング | BCrypt (FIPS-140準拠モードでは SHA-256/PBKDF2) |
| APIトークン | `ApiTokenProperty` によるユーザー別トークン管理 |
| Remember Me | `TokenBasedRememberMeServices2` による永続化認証 |

### CSRF対策

| 項目 | 実装 |
| --- | --- |
| Crumb発行 | `CrumbIssuer` インターフェースによる実装 |
| Crumbフィルター | `CrumbFilter` による全POSTリクエストの検証 |
| Crumb除外 | `CrumbExclusion` による特定パスの除外設定 |

### 機密情報保護

| 項目 | 実装 |
| --- | --- |
| シークレット暗号化 | `Secret` クラスによる暗号化保存 |
| 機密鍵管理 | `ConfidentialStore` による鍵の安全な保管 |
| 暗号化キー | `CryptoConfidentialKey` によるAES暗号化 |
| RSAデジタル署名 | `RSADigitalSignatureConfidentialKey` による署名検証 |

### アクセス制御

| 項目 | 実装 |
| --- | --- |
| ACL | `ACL` クラスによる権限チェック |
| Permission | 階層的な権限モデル（Jenkins/Item/Build/Runレベル） |
| Stapler保護 | `@StaplerDispatchable` / `@StaplerNotDispatchable` アノテーション |

## 拡張性要件

| 項目 | 実装 |
| --- | --- |
| プラグインアーキテクチャ | `@Extension` アノテーションによる拡張ポイント |
| 依存性注入 | Guiceによる依存性管理 |
| 拡張ポイント | `ExtensionPoint` インターフェースによる拡張性確保 |
| 動的プラグインロード | `PluginManager` による実行時プラグイン管理 |
| Descriptor/Describable | 設定可能なコンポーネントのパターン化 |
| クラウド統合 | `Cloud` 拡張ポイントによる各種クラウドプロバイダー対応 |

## 保守性要件

| 項目 | 実装 |
| --- | --- |
| 設定永続化 | XStream2による XML シリアライズ |
| 設定移行 | `OldDataMonitor` による旧データ検出・変換 |
| 管理モニター | `AdministrativeMonitor` によるシステム状態警告 |
| バージョン管理 | Mavenによる依存関係管理、BOMによるバージョン統一 |
| 静的解析 | SpotBugs、Checkstyle、ESLint、StyleLintの統合 |
| コードフォーマット | Spotless Mavenプラグインによる自動フォーマット |

## 運用・監視要件

### ロギング

| 項目 | 実装 |
| --- | --- |
| ロギングフレームワーク | java.util.logging (JUL) |
| SLF4J統合 | slf4j-jdk14バインディング |
| カスタムロガー | `LogRecorderManager` による動的ログ設定 |
| ログレベル | システムプロパティおよびUI経由で変更可能 |
| ビルドコンソール出力 | `AnnotatedLargeText` によるアノテーション付きログ |

### 監視・ヘルスチェック

| 項目 | 実装 |
| --- | --- |
| ヘルスチェックAPI | `/health` エンドポイント (`HealthCheckAction`) |
| ノード監視 | `NodeMonitor` 拡張ポイント（ディスク使用量、メモリ、応答時間等） |
| キュー監視 | `Queue` の状態確認API |
| ビルド統計 | `LoadStatistics` によるビルド負荷監視 |

### システムプロパティによる設定

主要なシステムプロパティによるチューニング項目：

| プロパティ | 説明 | デフォルト値 |
| --- | --- | --- |
| `hudson.ProxyConfiguration.DEFAULT_CONNECT_TIMEOUT_MILLIS` | HTTP接続タイムアウト | 20,000ms |
| `hudson.slaves.ChannelPinger.pingTimeoutSeconds` | Pingタイムアウト | 240秒 |
| `hudson.slaves.ChannelPinger.pingIntervalSeconds` | Ping間隔 | 300秒 |
| `jenkins.health.HealthCheckAction.thresholdTimeout` | ヘルスチェックタイムアウト | 10秒 |
| `hudson.model.UpdateCenter.pluginDownloadReadTimeoutSeconds` | プラグインダウンロードタイムアウト | 60秒 |

## 備考

- 本書はJenkins バージョン 2.548 のソースコード解析に基づいて作成
- 具体的な数値目標（SLA等）は運用環境に応じて別途定義が必要
- 多くの設定値はシステムプロパティにより実行時に変更可能
- プラグインにより追加の非機能要件が発生する可能性あり
