---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **jl_eval_stringのエラー時NULL戻り値**：ヘッダーのシグネチャからは戻り値がNULLになることは明示されていない。慣例的な使用方法であるが、ヘッダーファイルからの直接的根拠不足
  2. **jl_callシリーズの例外時NULL戻り値**：同上。実装依存の動作
  3. **jl_string_ptrのNUL終端保証**：ヘッダーファイルにNUL終端保証の記述がない。Julia文字列の内部仕様に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/julia.h` 行 2161 - `jl_init` 宣言
- E-02: `src/julia.h` 行 2162-2163 - `jl_init_with_image_file` 宣言
- E-03: `src/julia.h` 行 2166 - `jl_is_initialized` 宣言
- E-04: `src/julia.h` 行 2167 - `jl_atexit_hook` 宣言
- E-05: `src/julia.h` 行 2173 - `jl_adopt_thread` 宣言
- E-06: `src/julia.h` 行 2229 - `jl_eval_string` 宣言（コメント: "embedding interface"）
- E-07: `src/julia.h` 行 2288-2296 - `jl_call`/`jl_call0`-`jl_call4` 宣言
- E-08: `src/julia.h` 行 2278 - `jl_apply_generic` 宣言
- E-09: `src/julia.h` 行 2227 - `jl_toplevel_eval_in` 宣言
- E-10: `src/julia.h` 行 1612 - `jl_subtype` 宣言
- E-11: `src/julia.h` 行 1805 - `jl_isa` 宣言
- E-12: `src/julia.h` 行 1770 - `jl_egal` 宣言（JL_NOTSAFEPOINT, JL_MAYBE_UNROOTED アノテーション付き）
- E-13: `src/julia.h` 行 1774 - `jl_object_id` 宣言
- E-14: `src/julia.h` 行 1894-1922 - `jl_box_*`/`jl_unbox_*` 関数群の宣言
- E-15: `src/julia.h` 行 1926-1944 - プラットフォーム依存マクロ定義（`_P64`条件分岐）
- E-16: `src/julia.h` 行 1966-1969 - `jl_alloc_array_*` 関数群の宣言
- E-17: `src/julia.h` 行 1961-1962 - `jl_ptr_to_array_1d` 宣言
- E-18: `src/julia.h` 行 1976-1977 - `jl_array_grow_end`/`jl_array_del_end` 宣言
- E-19: `src/julia.h` 行 1972 - `jl_cstr_to_string` 宣言
- E-20: `src/julia.h` 行 2009 - `jl_string_ptr` 宣言
- E-21: `src/julia.h` 行 1876 - `jl_symbol` 宣言（JL_NOTSAFEPOINT付き）
- E-22: `src/julia.h` 行 2012 - `jl_new_module` 宣言
- E-23: `src/julia.h` 行 2037-2038 - `jl_get_global`/`jl_set_global` 宣言（GCアノテーション付き）
- E-24: `src/julia.h` 行 2039 - `jl_set_const` 宣言
- E-25: `src/julia.h` 行 1948, 1952 - `jl_get_nth_field`/`jl_set_nth_field` 宣言
- E-26: `src/julia.h` 行 1955 - `jl_get_field` 宣言
- E-27: `src/julia.h` 行 1158 - `jl_gc_add_finalizer` 宣言
- E-28: `src/julia.h` 行 1159 - `jl_gc_add_ptr_finalizer` 宣言
- E-29: `src/julia.h` 行 1168 - `jl_gc_new_weakref` 宣言
- E-30: `src/julia.h` 行 1170 - `jl_gc_safepoint` 宣言
- E-31: `src/julia.h` 行 2323 - `jl_new_task` 宣言
- E-32: `src/julia.h` 行 2631 - `jl_get_current_task` 宣言（JL_GLOBALLY_ROOTED, JL_NOTSAFEPOINT付き）
- E-33: `src/julia.h` 行 2086-2087 - `jl_error`/`jl_errorf` 宣言（JL_NORETURN付き）
- E-34: `src/julia.h` 行 2327 - `jl_throw` 宣言（JL_NORETURN, JL_MAYBE_UNROOTED付き）
- E-35: `src/julia.h` 行 2349-2350 - `jl_exception_occurred`/`jl_exception_clear` 宣言
- E-36: `src/julia.h` 行 2191-2192 - `jl_parse_all` 宣言
- E-37: `src/julia.h` 行 2220-2223 - 動的ライブラリ関数群の宣言
- E-38: `src/julia.h` 行 2204-2217 - `JL_RTLD_*` 定数定義
- E-39: `src/julia.h` 行 2065-2066 - `jl_cpu_threads`/`jl_effective_threads` 宣言
- E-40: `src/julia.h` 行 2613-2617 - `jl_ver_*` 関数群の宣言
- E-41: `src/julia.h` 行 2485-2488 - `jl_uv_puts`/`jl_printf` 宣言
- E-42: `src/julia.h` 行 2507 - `jl_static_show` 宣言
- E-43: `src/julia.h` 行 2301-2302 - `jl_sigatomic_begin`/`jl_sigatomic_end` 宣言
- E-44: `src/julia_gcext.h` 行 28-31 - GCコールバック設定関数群の宣言
- E-45: `src/julia_gcext.h` 行 47-54 - `jl_new_foreign_type` 宣言
- E-46: `src/julia_gcext.h` 行 77 - `jl_gc_alloc_typed` 宣言
- E-47: `src/julia_gcext.h` 行 82-84 - `jl_gc_mark_queue_obj`/`jl_gc_mark_queue_objarray` 宣言
- E-48: `src/julia_gcext.h` 行 116 - `jl_gc_enable_conservative_gc_support` 宣言
- E-49: `src/julia.h` 行 1100-1154 - `JL_GC_PUSH*`/`JL_GC_POP` マクロ定義
- E-50: `src/julia.h` 行 2429-2441 - `JL_TRY`/`JL_CATCH` マクロ定義
- E-51: `src/julia.h` - `JL_DLLEXPORT` マーカーによるエクスポート（388件のgrep一致）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | jl_init はパラメータなしでJuliaランタイムを初期化する | E-01 | ○ |
| C-02 | jl_init_with_image_file はjulia_bindirとimage_pathの2パラメータを取る | E-02 | ○ |
| C-03 | jl_is_initialized は初期化済みかどうかを返す | E-03 | ○ |
| C-04 | jl_atexit_hook はstatus引数を取る | E-04 | ○ |
| C-05 | jl_adopt_thread はjl_gcframe_t**を返す | E-05 | ○ |
| C-06 | jl_eval_string は埋め込みインターフェースである | E-06 | ○ |
| C-07 | jl_eval_string はエラー時にNULLを返す | **根拠なし** | △ |
| C-08 | jl_callシリーズは引数にJL_MAYBE_UNROOTEDアノテーションを持つ | E-07 | ○ |
| C-09 | jl_callシリーズは例外発生時にNULLを返す | **根拠なし** | △ |
| C-10 | jl_apply_generic はF, args, nargsの3パラメータを取る | E-08 | ○ |
| C-11 | jl_toplevel_eval_in はモジュールと式を引数に取る | E-09 | ○ |
| C-12 | jl_subtype は2つの型のサブタイプ関係を判定する | E-10 | ○ |
| C-13 | jl_isa は値と型のインスタンス関係を判定する | E-11 | ○ |
| C-14 | jl_egal はJL_NOTSAFEPOINT かつ JL_MAYBE_UNROOTED である | E-12 | ○ |
| C-15 | jl_object_id はuintptr_tを返す | E-13 | ○ |
| C-16 | ボックス化関数群はjulia.h行1894-1922に定義されている | E-14 | ○ |
| C-17 | プラットフォーム依存マクロは_P64条件で切り替わる | E-15 | ○ |
| C-18 | 配列割り当て関数は1D/2D/3D/NDの4バリアントがある | E-16 | ○ |
| C-19 | jl_ptr_to_array_1dはown_bufferパラメータを持つ | E-17 | ○ |
| C-20 | jl_array_grow_end/jl_array_del_endは配列と増減数を引数に取る | E-18 | ○ |
| C-21 | jl_cstr_to_stringはNUL終端C文字列を受け取る | E-19 | ○ |
| C-22 | jl_string_ptrはconst char*を返す | E-20 | ○ |
| C-23 | jl_string_ptrはNUL終端を保証する | **根拠なし** | △ |
| C-24 | jl_symbolはJL_NOTSAFEPOINTである | E-21 | ○ |
| C-25 | jl_new_moduleはnameとparentの2パラメータを取る | E-22 | ○ |
| C-26 | jl_set_globalはJL_ROOTING_ARGUMENT/JL_ROOTED_ARGUMENTアノテーションを持つ | E-23 | ○ |
| C-27 | jl_set_constはモジュール、変数名、値の3パラメータを取る | E-24 | ○ |
| C-28 | jl_get_nth_fieldはフィールドインデックスが0始まり | E-25 | ○ |
| C-29 | jl_get_fieldはフィールド名(文字列)で値を取得する | E-26 | ○ |
| C-30 | jl_gc_add_finalizerはJL_NOTSAFEPOINTである | E-27 | ○ |
| C-31 | jl_gc_add_ptr_finalizerはptls, v, fの3パラメータを取る | E-28 | ○ |
| C-32 | jl_gc_new_weakrefはjl_weakref_t*を返す | E-29 | ○ |
| C-33 | jl_gc_safepointはvoidを返す | E-30 | ○ |
| C-34 | jl_new_taskは3パラメータ（start, completion_future, ssize）を取る | E-31 | ○ |
| C-35 | jl_get_current_taskはJL_GLOBALLY_ROOTED かつ JL_NOTSAFEPOINT | E-32 | ○ |
| C-36 | jl_error/jl_errorfはJL_NORETURN属性を持つ | E-33 | ○ |
| C-37 | jl_throwはJL_NORETURN かつ JL_MAYBE_UNROOTEDである | E-34 | ○ |
| C-38 | jl_exception_occurredはjl_value_t*を返す | E-35 | ○ |
| C-39 | jl_parse_allは5パラメータ（text, text_len, filename, filename_len, lineno） | E-36 | ○ |
| C-40 | 動的ライブラリAPIは4関数（load, open, close, sym） | E-37 | ○ |
| C-41 | JL_RTLD_DEFAULT = JL_RTLD_LAZY \| JL_RTLD_DEEPBIND | E-38 | ○ |
| C-42 | jl_cpu_threadsはJL_NOTSAFEPOINTである | E-39 | ○ |
| C-43 | jl_ver_*は5つのバリアント（string, major, minor, patch, is_release） | E-40 | ○ |
| C-44 | jl_printfはuv_stream_sを第一引数に取る | E-41 | ○ |
| C-45 | jl_static_showはJL_NOTSAFEPOINTである | E-42 | ○ |
| C-46 | jl_sigatomic_begin/endはvoidを返す | E-43 | ○ |
| C-47 | GCコールバック設定関数はcbとenableの2パラメータ | E-44 | ○ |
| C-48 | jl_new_foreign_typeは7パラメータを取る | E-45 | ○ |
| C-49 | jl_gc_alloc_typedはptls, sz, tyの3パラメータ | E-46 | ○ |
| C-50 | libjuliaは388個のJL_DLLEXPORT関数を含む | E-51 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-07 / C-09: `jl_eval_string`および`jl_call`系関数のエラー時のNULL戻り値について、ヘッダーファイルのシグネチャからは直接確認できない。これはJulia公式ドキュメント（Embedding章）やランタイム実装（`src/jlapi.c`等）に記載されている可能性がある。
  - 候補: `src/jlapi.c` / Julia公式ドキュメントEmbedding章 / テストコード
- C-23: `jl_string_ptr`のNUL終端保証について、ヘッダーファイルにはこの保証に関する記述がない。Juliaの文字列内部仕様（`src/strings/string.jl`, `src/array.c`等）を確認する必要がある。
  - 候補: `base/strings/string.jl` / `src/array.c` / Julia公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 初期化・終了API（jl_init, jl_atexit_hook等）- ヘッダーから完全に確認可能
- 0: ボックス化・アンボックス化API - ヘッダーから完全に確認可能
- 0: GC拡張API（julia_gcext.h）- ヘッダーのコメントが充実しており確認可能
- 1: 評価・実行API（jl_eval_string, jl_call等）のエラー時動作 - 実装依存の動作があり要確認
- 1: jl_string_ptrのNUL終端保証 - 内部実装仕様に依存
- 0: 型・値操作API - ヘッダーから完全に確認可能
- 0: モジュール・バインディングAPI - GCアノテーションを含め確認可能
- 1: 本書はjulia.hの388個のJL_DLLEXPORT関数のうち約50個を選定して記載。網羅性は部分的

## 6) レビュアーチェックリスト（最小）
- [ ] jl_eval_string のエラー時動作（NULL戻り値）が実装と一致するか `src/jlapi.c` を確認
- [ ] jl_call系関数の例外時動作が実装と一致するか確認
- [ ] jl_string_ptr のNUL終端保証について Julia文字列の内部仕様を確認
- [ ] API関数の選定（50個/388個）が主要なEmbedding用途に対して十分か確認
- [ ] jl_new_task のパラメータ名（start, completion_future, ssize）がヘッダーでは型のみ記載されているため、実装との一致を確認
- [ ] GCルーティング規約の説明が最新のコードベースと一致するか確認
