# Julia

## 概要

Julia は、科学技術計算向けに設計された高水準・高性能な動的プログラミング言語である。C/C++ に匹敵する実行速度と、Python や R のような記述の容易さを両立することを目指して開発されている。本リポジトリは Julia 言語本体のソースコードであり、コンパイラ、ランタイム、Base 標準ライブラリ、および各種 stdlib パッケージを含む。現在のバージョンは 1.14.0-DEV（開発版）である。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| 多重ディスパッチ | 引数の型の組み合わせに基づく関数ディスパッチにより、柔軟かつ高性能なコードを記述できる |
| JIT コンパイル | LLVM ベースの JIT コンパイラにより、動的言語でありながらネイティブコードに近い実行速度を実現する |
| 型システム | パラメトリック型やユニオン型を含む表現力の高い型システムを提供する |
| マクロ・メタプログラミング | Lisp に着想を得たマクロシステムにより、コード生成やDSL構築が可能である |
| 並列・並行処理 | マルチスレッド、分散コンピューティング、非同期タスクなど複数の並列処理モデルをサポートする |
| パッケージマネージャ | 組み込みのパッケージマネージャ (Pkg) により、パッケージの管理・再現性を確保する |
| C/Fortran 呼び出し | `ccall` を通じて C や Fortran のライブラリを直接呼び出せる（ラッパー不要） |
| REPL | 対話的な実行環境（REPL）を標準搭載し、探索的なプログラミングをサポートする |
| Unicode サポート | 変数名やシンボルに Unicode 文字を使用でき、数学的な表記に近いコードを記述可能にする |
| ガベージコレクション | 世代別 GC（stock GC）および MMTk ベースの GC をサポートする |

## 技術スタック

### コア

- 言語: Julia, C, C++, Scheme (flisp)
- コンパイラバックエンド: LLVM
- ビルドシステム: GNU Make
- ランタイム: libuv（非同期I/O）、libunwind（スタックトレース）

### 主要ライブラリ・依存関係

- OpenBLAS / libblastrampoline: 線形代数演算
- GMP: 多倍長整数演算
- MPFR: 多倍長浮動小数点演算
- PCRE2: 正規表現エンジン
- SuiteSparse: 疎行列ライブラリ群
- LibGit2: Git 操作
- LibSSH2: SSH プロトコル
- LibCURL / nghttp2: HTTP クライアント
- OpenSSL: 暗号化・TLS
- OpenLibm: 数学関数ライブラリ
- dSFMT: 高速メルセンヌ・ツイスタ乱数生成器
- utf8proc: Unicode テキスト処理
- zlib / Zstd: データ圧縮
- p7zip: アーカイブ展開

## ディレクトリ構成

```
julia-master/
├── base/           # Base モジュール（起動時にロードされるコア標準ライブラリ）
├── cli/            # コマンドラインインターフェース・ローダー
├── Compiler/       # Julia コンパイラモジュール（独立して差し替え可能）
├── contrib/        # ビルド補助スクリプト・ユーティリティ群
├── deps/           # 外部依存ライブラリのビルド定義・パッチ
├── doc/            # ユーザーマニュアル・ドキュメント
├── etc/            # startup.jl 等の設定ファイル
├── src/            # C/C++ ランタイム・LLVM コード生成
│   ├── flisp/      # flisp（Scheme 方言）インタープリタ
│   └── support/    # プラットフォームサポートユーティリティ
├── stdlib/         # 標準ライブラリパッケージ群
├── test/           # テストスイート
├── JuliaLowering/  # Julia AST lowering
├── JuliaSyntax/    # Julia パーサー
├── Makefile        # トップレベルビルド定義
├── Make.inc        # ビルドオプション・設定
└── VERSION         # バージョンファイル（現在: 1.14.0-DEV）
```

## セットアップ

### 必要条件

- GNU Make
- GCC または Clang（C/C++ コンパイラ）
- Python（一部ビルドスクリプト用）
- 約 2GiB のディスク空き容量
- 約 4GiB の仮想メモリ

### バイナリインストール（推奨）

`juliaup` を使用することで、最新の安定版 Julia を簡単にインストールできる。

```bash
# juliaup のインストール（公式サイト https://julialang.org/downloads/ を参照）
# インストール後:
julia
```

### ソースからのビルド

```bash
git clone https://github.com/JuliaLang/julia.git
cd julia
git checkout v1.12.2  # 安定版を使う場合
make -j
./julia
```

ビルドディレクトリのパスにスペースやシェルメタ文字（`$`, `:` 等）を含めないこと。

### アンインストール

Julia はクローンしたディレクトリと `~/.julia` の外にはファイルをインストールしない。これらの2つのディレクトリを削除すれば完全にアンインストールできる。

## 開発

### テストの実行

```bash
# 全テストの実行
make testall

# 個別テストの実行（例: arrayops テスト）
make test-revise-arrayops

# Revise を使ったテスト（Base の変更を再ビルドなしで反映）
JULIA_TEST_FAILFAST=1 ./julia -e 'using Revise; Revise.track(Base); include("test.jl")'
```

### コード品質チェック

```bash
# ホワイトスペースの修正
make fix-whitespace

# C/C++ ファイルの静的解析（初回のみ依存関係インストールが必要）
make -C src install-analysis-deps
make -C src analyze-<filename> --output-sync -j8
```

### ドキュメントビルド

```bash
# ドキュメントのビルドとdoctest実行
make -C doc doctest=true revise=true
```

### エディタ・IDE サポート

- VS Code: julia-vscode プラグイン（推奨）
- Emacs: julia-emacs
- Vim: julia-vim
- Sublime Text: Julia-sublime
- Jupyter Notebook: IJulia パッケージ
- Pluto Notebook: Pluto.jl パッケージ
