---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **C-22 ディスク・メモリ要件の具体値**：README.md の記述に依拠しており最新ハードウェア要件の検証が必要
  2. **C-29 安定版バージョン番号 v1.12.2**：README.md の記述に依拠しており実際の最新安定版と一致するか確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md`（プロジェクトルートの公式 README）
- E-02: `VERSION`（バージョンファイル、内容: `1.14.0-DEV`）
- E-03: `LICENSE.md`（MIT License）
- E-04: `AGENTS.md`（AI エージェント向けモジュール構成・ビルド手順）
- E-05: `Makefile`（トップレベルビルド定義）
- E-06: `Make.inc`（ビルドオプション・依存ライブラリフラグ）
- E-07: `CONTRIBUTING.md`（貢献者ガイド）
- E-08: `src/` ディレクトリ内容（C/C++/Scheme ソースファイル一覧）
- E-09: `base/` ディレクトリ内容（Julia Base モジュールソース一覧）
- E-10: `stdlib/` ディレクトリ内容（標準ライブラリパッケージ一覧）
- E-11: `deps/` ディレクトリ内容（外部依存ライブラリビルド定義一覧）
- E-12: `cli/` ディレクトリ内容（CLI ローダーソース一覧）
- E-13: `Compiler/` ディレクトリ内容（コンパイラモジュール構成）
- E-14: `doc/` ディレクトリ内容（ドキュメントディレクトリ構成）
- E-15: `test/` ディレクトリ内容（テストスイートファイル一覧）
- E-16: `etc/` ディレクトリ内容（`startup.jl`）
- E-17: `contrib/` ディレクトリ内容（補助スクリプト一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Julia は科学技術計算向けの高水準・高性能な動的プログラミング言語である | E-01 | ○ |
| C-02 | 現在のバージョンは 1.14.0-DEV である | E-02 | ○ |
| C-03 | 多重ディスパッチによる柔軟な関数ディスパッチを提供する | E-01, E-09 | ○ |
| C-04 | LLVM ベースの JIT コンパイルを使用する | E-01, E-08, E-11 | ○ |
| C-05 | パラメトリック型やユニオン型を含む型システムを提供する | E-09 | ○ |
| C-06 | マクロ・メタプログラミング機能を持つ | E-08, E-09 | ○ |
| C-07 | マルチスレッド・分散コンピューティング・非同期タスクをサポートする | E-06, E-09, E-10 | ○ |
| C-08 | 組み込みパッケージマネージャ (Pkg) を持つ | E-10 | ○ |
| C-09 | ccall で C/Fortran ライブラリを直接呼び出せる | E-04, E-08 | ○ |
| C-10 | REPL を標準搭載する | E-01, E-10 | ○ |
| C-11 | Unicode サポートを持つ | E-09, E-11 | ○ |
| C-12 | 世代別 GC および MMTk ベースの GC をサポートする | E-08 | ○ |
| C-13 | 言語は Julia, C, C++, Scheme (flisp) で実装されている | E-08, E-09 | ○ |
| C-14 | コンパイラバックエンドとして LLVM を使用する | E-05, E-06, E-11 | ○ |
| C-15 | ビルドシステムに GNU Make を使用する | E-05, E-06 | ○ |
| C-16 | ランタイムに libuv を使用する | E-06, E-11 | ○ |
| C-17 | OpenBLAS / libblastrampoline を線形代数演算に使用する | E-06, E-11 | ○ |
| C-18 | GMP, MPFR, PCRE2, SuiteSparse 等の外部依存ライブラリを使用する | E-06, E-11 | ○ |
| C-19 | base/ は起動時にロードされるコア標準ライブラリである | E-04, E-09 | ○ |
| C-20 | Compiler/ は独立して差し替え可能なコンパイラモジュールである | E-04, E-13 | ○ |
| C-21 | src/ に C/C++ ランタイムと LLVM コード生成が含まれる | E-04, E-08 | ○ |
| C-22 | ビルドに約 2GiB のディスクと約 4GiB の仮想メモリが必要 | E-01 | △ |
| C-23 | juliaup でバイナリインストールできる | E-01 | ○ |
| C-24 | make -j でソースからビルドできる | E-01, E-04 | ○ |
| C-25 | make testall で全テストを実行できる | E-01 | ○ |
| C-26 | make test-revise-<name> で個別テストを実行できる | E-04 | ○ |
| C-27 | make fix-whitespace でホワイトスペース修正ができる | E-04 | ○ |
| C-28 | make -C src analyze-<filename> で静的解析ができる | E-04 | ○ |
| C-29 | 安定版チェックアウトコマンドとして git checkout v1.12.2 を記載 | E-01 | △ |
| C-30 | VS Code julia-vscode プラグインが推奨 IDE である | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-22**: ディスク・メモリ要件の具体値（2GiB / 4GiB）は README.md の記述をそのまま転記しているが、実際のビルド環境やバージョンによって変動する可能性がある。ビルドドキュメント（`doc/src/devdocs/build/build.md`）で最新値を確認することが望ましい。
  - 候補：`doc/src/devdocs/build/build.md` / CI ログ / 開発者ヒアリング
- **C-29**: `v1.12.2` は README.md に記載されている安定版バージョンであるが、開発版が `1.14.0-DEV` であることから、最新の安定版リリースが異なる可能性がある。GitHub Releases ページで最新版を確認することが望ましい。
  - 候補：GitHub Releases ページ / julialang.org/downloads

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全体的に公式 README.md、AGENTS.md、ソースコードディレクトリ構造から直接的に根拠を取得できており、大きな逸脱はない
- 1（中リスク）：ディスク・メモリ要件（C-22）および安定版バージョン番号（C-29）は時期によって変動するため、定期的な更新確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 概要セクションが Julia の公式説明と整合しているか確認する
- [ ] バージョン番号（1.14.0-DEV）が現在の開発版と一致するか確認する
- [ ] 主な機能一覧が Julia の主要な特徴を網羅しているか確認する
- [ ] 技術スタックの依存ライブラリ一覧が deps/ ディレクトリの内容と一致するか確認する
- [ ] ディレクトリ構成が実際のリポジトリ構造を正確に反映しているか確認する
- [ ] セットアップ手順（ビルドコマンド等）が最新のビルドドキュメントと整合しているか確認する
- [ ] 安定版バージョン（v1.12.2）が最新の安定版リリースと一致するか確認する
