---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **C-28: JuliaLoweringの新しいlowering実装の説明**: JuliaLoweringディレクトリは存在を確認したが内容の詳細解析が不足
  2. **C-35: LLVM ORC JITの具体的な利用方法**: jitlayers.cppのinclude文から推定しているが実装詳細は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要
- E-02: `VERSION` - バージョン番号 (1.14.0-DEV)
- E-03: `AGENTS.md` - モジュール構成説明
- E-04: `base/Base_compiler.jl` - Baseモジュール初期定義
- E-05: `base/Base.jl` - Baseモジュール主要定義
- E-06: `base/boot.jl` - 型擬似定義
- E-07: `base/array.jl` - 配列実装
- E-08: `base/broadcast.jl` - ブロードキャストモジュール
- E-09: `base/essentials.jl` - 基本操作
- E-10: `base/loading.jl` - パッケージ読込実装
- E-11: `base/client.jl` - REPL/クライアント処理
- E-12: `base/exports.jl` - エクスポート一覧
- E-13: `base/task.jl` - タスクAPI
- E-14: `src/julia.h` - 主要公開ヘッダ
- E-15: `src/init.c` - システム初期化
- E-16: `src/gf.c` - 総称関数/ディスパッチ
- E-17: `src/jltypes.c` - 型システム実装
- E-18: `src/builtins.c` - 組み込み関数
- E-19: `src/codegen.cpp` - LLVM IR生成
- E-20: `src/jitlayers.cpp` - JITレイヤー
- E-21: `src/gc-stock.c` - 標準GC実装
- E-22: `src/task.c` - タスク（コルーチン）
- E-23: `src/interpreter.c` - インタプリタ
- E-24: `src/toplevel.c` - トップレベル式評価
- E-25: `cli/loader_exe.c` - 実行ファイルエントリーポイント
- E-26: `cli/loader_lib.c` - ライブラリローダ
- E-27: `Compiler/src/Compiler.jl` - コンパイラモジュール
- E-28: `Compiler/src/abstractinterpretation.jl` - 抽象解釈
- E-29: `Compiler/src/optimize.jl` - 最適化パス
- E-30: `Compiler/src/typeinfer.jl` - 型推論
- E-31: `CONTRIBUTING.md` - コントリビューションガイド
- E-32: `Makefile` - ビルドシステム
- E-33: `src/flisp/` ディレクトリ一覧 - femlispパーサ確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Juliaは動的型付け高水準言語で技術計算向け | E-01 | ○ |
| C-02 | バージョンは1.14.0-DEV | E-02 | ○ |
| C-03 | プロジェクトは5層構造（ランタイム、標準ライブラリ、コンパイラ、パーサ、JIT） | E-03, E-14, E-27, E-19 | ○ |
| C-04 | 全ファイルにMITライセンスヘッダが存在 | E-04, E-15, E-25 | ○ |
| C-05 | boot.jlにCランタイム実装の型擬似定義が存在 | E-06 | ○ |
| C-06 | 型エイリアス（AbstractVector等）がarray.jlに定義 | E-07 | ○ |
| C-07 | jl_value_tが全Julia値の基底型 | E-14 | ○ |
| C-08 | プラットフォーム切替に_OS_WINDOWS_等のマクロ使用 | E-15, E-25, E-26 | ○ |
| C-09 | 多重ディスパッチで同名関数に複数メソッド定義 | E-04, E-09 | ○ |
| C-10 | JL_DLLEXPORTでAPI関数をエクスポート | E-16 | ○ |
| C-11 | using/import/exportのモジュールシステム | E-08 | ○ |
| C-12 | World Ageカウンタがgf.cに定義 | E-16 | ○ |
| C-13 | ブートストラップがCore->Base_compiler->Baseの順 | E-04, E-05, E-06 | ○ |
| C-14 | ccallでJuliaからC関数を呼び出し | E-04, E-10 | ○ |
| C-15 | GCにstock実装とMMTk実装の2種 | E-21, ディレクトリ一覧 | ○ |
| C-16 | Mark-and-sweepベースのGC | E-21 | ○ |
| C-17 | LLVMベースのJITコンパイラ | E-19, E-20 | ○ |
| C-18 | コンパイラが抽象解釈ベースで型推論 | E-28, E-30 | ○ |
| C-19 | @nospecializeで型特殊化を抑制 | E-09, E-28 | ○ |
| C-20 | 起動はcli/loader_exe.cのmain()から開始 | E-25 | ○ |
| C-21 | jl_load_repl()がlibjuliaをロード | E-25, E-26 | ○ |
| C-22 | 総称関数ディスパッチがgf.cに実装 | E-16 | ○ |
| C-23 | IR_FLAGビットフラグがoptimize.jlに定義 | E-29 | ○ |
| C-24 | GCの並列マーキングサポート | E-21 | ○ |
| C-25 | タスクが軽量コルーチンとして実装 | E-22, E-13 | ○ |
| C-26 | loading.jlがimport文の実装 | E-10 | ○ |
| C-27 | Base.jlが約150ファイルをinclude | E-05 | ○ |
| C-28 | JuliaLoweringが新しいlowering実装 | **根拠不足** | △ |
| C-29 | テスト実行はmake test-revise-xxxで可能 | E-03 | ○ |
| C-30 | flisp（femtolisp）がパーサとして使用 | E-33 | ○ |
| C-31 | 外部依存はdeps/配下の.mkと.versionで管理 | E-32, depsディレクトリ | ○ |
| C-32 | Clang静的解析でGC保護を検証可能 | E-03 | ○ |
| C-33 | Reviseでリビルドなしの変更反映が可能 | E-03 | ○ |
| C-34 | interpreter.cがJITなしのIR解釈実行を提供 | E-23 | ○ |
| C-35 | LLVM ORC JIT APIの使用 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-28: JuliaLoweringディレクトリの存在は確認したが、内部のファイル構成や具体的な実装内容を詳細に解析していない。JuliaSyntaxも同様に内部の詳細は未確認。
  - 候補：`JuliaLowering/` 内のソースファイル読み込み / Julia公式ドキュメントの開発者向けセクション
- C-35: `jitlayers.cpp` のインクルード文からLLVM ORC JITの使用を推定しているが、具体的なORC JIT APIの呼び出し箇所は詳細に確認していない。
  - 候補：`src/jitlayers.cpp` の全体読み込み / LLVM ORC JIT公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 言語基礎、命名規則、ディレクトリ構造の説明（直接コードから確認可能）
- 0: 低リスク - エントリーポイント、型システム、GCの説明（コードで直接確認）
- 1: 中リスク - アーキテクチャ全体像（複数コンポーネント間の関係は推定を含む）
- 0: 低リスク - パターン説明（実コードからの引用で裏付け済み）
- 1: 中リスク - 業務フロー追跡（起動フローの一部ステップは推定）

## 6) レビュアーチェックリスト（最小）
- [ ] 言語基礎セクションのコード引用が最新のソースコードと一致しているか
- [ ] アーキテクチャ図のレイヤー構成がプロジェクト実態と一致しているか
- [ ] JuliaLoweringとJuliaSyntaxの説明が現在の実装状況と合致しているか
- [ ] GCの2実装（stock/MMTk）の説明が正確か
- [ ] 起動フローの説明（loader_exe -> loader_lib -> init -> client）が実際の呼び出し順序と一致しているか
- [ ] 用語集の定義が正確であるか
- [ ] 参照ファイルパスと行番号が実際のソースコードと一致しているか
