---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **FemtoLispからJuliaSyntax/JuliaLoweringへの移行段階の詳細**：移行の現在の正確な状態についてはコードベースの解析だけでは完全に判断できない
  2. **MMTk GCの本番利用可能性**：gc-mmtk.cが存在するがプロダクション対応かは外部情報が必要
  3. **LLVMバージョンの具体値**：deps/llvm.versionファイルの内容を直接確認していない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `VERSION` - プロジェクトバージョン（1.14.0-DEV）
- E-02: `AGENTS.md` - モジュール構成の記述（base/, stdlib/, Compiler/, src/, cli/, doc/）
- E-03: `Makefile` (トップレベル) - ビルドターゲット定義、TOP_LEVEL_PKGS定義
- E-04: `Make.inc` - ビルドオプション、外部依存USE_SYSTEM_*フラグ一覧
- E-05: `base/Base_compiler.jl` - Baseモジュールのブートストラップ開始
- E-06: `base/Base.jl` - Baseモジュール本体のincludeチェーン
- E-07: `base/boot.jl` - Core型定義（Any, DataType, Array, Memory等）
- E-08: `Compiler/src/Compiler.jl` - Compilerモジュール定義、Base/Coreからのusing/import
- E-09: `src/julia.h` - ランタイムCヘッダ、コアデータ型定義
- E-10: `src/init.c` - ランタイム初期化コード
- E-11: `src/codegen.cpp` - LLVMベースJITコード生成
- E-12: `src/threading.h` - スレッド管理インターフェース
- E-13: `src/gc-interface.h` (存在確認) - GC抽象インターフェース
- E-14: `src/gc-stock.c` (存在確認) - Stock GC実装
- E-15: `src/gc-mmtk.c` (存在確認) - MMTk GC実装
- E-16: `cli/loader_lib.c` - CLIローダー実装（動的ライブラリロード）
- E-17: `cli/loader_exe.c` (存在確認) - 実行ファイルエントリポイント
- E-18: `src/flisp/` ディレクトリ - FemtoLisp実装の存在
- E-19: `JuliaSyntax/src/` ディレクトリ - JuliaSyntaxパーサー実装
- E-20: `JuliaLowering/src/` ディレクトリ - JuliaLowering実装（desugaring, scope_analysis等）
- E-21: `deps/*.mk` ファイル群 - 外部依存ライブラリのビルド定義
- E-22: `stdlib/` ディレクトリ一覧 - 標準ライブラリパッケージ群（約60エントリ）
- E-23: `src/support/` ディレクトリ - サポートライブラリのファイル一覧
- E-24: `base/task.jl` - タスク（コルーチン）の定義
- E-25: `base/channels.jl` (includeチェーンで確認) - Channel定義
- E-26: `base/loading.jl` - パッケージローディング実装
- E-27: `src/jl_exported_funcs.inc` - エクスポートされたランタイム関数一覧
- E-28: `src/aotcompile.cpp` (存在確認) - AOTコンパイル
- E-29: `base/logging/logging.jl` (includeチェーンで確認) - CoreLogging
- E-30: `src/scheduler.c` (存在確認) - タスクスケジューラ
- E-31: `src/work-stealing-queue.h` (存在確認) - ワークスティーリングキュー
- E-32: `src/signals-mach.c`, `src/signals-unix.c`, `src/signals-win.c` (存在確認) - シグナル処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Julia v1.14.0-DEVである | E-01 | ○ |
| C-02 | C/C++ランタイム、LLVMベースJITコンパイラ、Julia標準ライブラリの3層構成 | E-02, E-09, E-11 | ○ |
| C-03 | 階層化アーキテクチャを採用 | E-02, E-03, E-05, E-06 | ○ |
| C-04 | Compilerモジュールは差し替え可能 | E-02, E-08 | ○ |
| C-05 | CLI/Loaderがlibjuliaとlibjulia-codegenを動的ロード | E-16 | ○ |
| C-06 | src/init.cでランタイム初期化 | E-10 | ○ |
| C-07 | base/boot.jlでCore型定義（Any, DataType, Array等） | E-07 | ○ |
| C-08 | Base.jlのincludeチェーンで各種機能をロード | E-06 | ○ |
| C-09 | Compiler/src/のabstractinterpretation.jlで抽象解釈 | E-08 | ○ |
| C-10 | codegen.cppでLLVM IR生成 | E-11 | ○ |
| C-11 | LLVMを外部依存として使用 | E-11, E-21 | ○ |
| C-12 | libuvを非同期I/Oに使用 | E-06, E-21 | ○ |
| C-13 | OpenBLAS/GMP/MPFR/PCRE2等の外部依存 | E-04, E-21 | ○ |
| C-14 | GC抽象化（gc-interface.h）によるStock/MMTk切り替え | E-13, E-14, E-15 | ○ |
| C-15 | FemtoLisp（src/flisp/）がレガシーフロントエンド | E-18 | ○ |
| C-16 | JuliaSyntaxが新パーサー | E-03, E-19 | ○ |
| C-17 | JuliaLoweringが新Lowering実装 | E-03, E-20 | ○ |
| C-18 | 約60の標準ライブラリパッケージ | E-22 | ○ |
| C-19 | JLLパッケージで外部バイナリをラップ | E-22, E-04 | ○ |
| C-20 | support/ディレクトリが低レベルユーティリティを提供 | E-23 | ○ |
| C-21 | タスクベースの並行処理モデル | E-24, E-25 | ○ |
| C-22 | ワークスティーリングスケジューラ | E-30, E-31 | ○ |
| C-23 | パッケージローディングがloading.jlで実装 | E-26 | ○ |
| C-24 | ccallでC関数を直接呼び出す | E-06, E-27 | ○ |
| C-25 | AOTコンパイル機能の存在 | E-28 | ○ |
| C-26 | CoreLoggingによるロギング | E-29 | ○ |
| C-27 | シグナルハンドラによるスタックオーバーフロー検出 | E-32 | ○ |
| C-28 | ワールドカウンタ（World Age）によるメソッド一貫性 | E-08, E-06 | ○ |
| C-29 | 多重ディスパッチがsrc/gf.cで実装 | E-02 | ○ |
| C-30 | プリコンパイル・システムイメージ機構 | E-06, E-26 | ○ |
| C-31 | コーディング規約（fix-whitespace, clang-sa等） | E-02 | ○ |
| C-32 | USE_BINARYBUILDERフラグで依存取得方法を切替 | E-04 | ○ |
| C-33 | FemtoLispからJuliaSyntax/JuliaLoweringへの移行が「段階的に進行中」 | **根拠不足** | △ |
| C-34 | MMTk GCがプロダクション利用可能 | **根拠不足** | △ |
| C-35 | LLVMの具体的なバージョン | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **FemtoLispからの移行状態の詳細** (C-33)：JuliaSyntaxとJuliaLoweringのディレクトリが存在し、Makefileで`TOP_LEVEL_PKGS`として登録されていることは確認できるが、FemtoLispとの切り替え条件や移行の完了度については開発者ドキュメントやissue trackerの確認が必要。
  - 候補：Julia開発者向けドキュメント / GitHub Issues / JuliaLang Discourse
- **MMTk GCの成熟度** (C-34)：`gc-mmtk.c`ファイルの存在は確認できるが、実際のプロダクション利用可能性やデフォルトGCとの比較性能については外部情報が必要。
  - 候補：MMTkプロジェクトドキュメント / Julia GC関連PR
- **LLVMバージョン** (C-35)：`deps/llvm.version`ファイルが存在するが内容を直接参照していない。
  - 候補：`deps/llvm.version` ファイルの直接参照

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的なレイヤー構成・モジュール分割の記述はソースコード構造と整合している
- 1: 中リスク - フロントエンドの移行状態（C-33）は開発中の変更であり、記述が陳腐化する可能性がある
- 0: 低リスク - 外部依存ライブラリの一覧はdeps/ディレクトリおよびMake.incから網羅的に抽出
- 1: 中リスク - MMTk GCの記述（C-34）は実装の存在を確認しているが成熟度は未検証

## 6) レビュアーチェックリスト（最小）
- [ ] レイヤー構成（Runtime / Codegen / Core / Base / Compiler / Frontend / stdlib）の定義が実際のディレクトリ構造と一致しているか
- [ ] 外部依存ライブラリの一覧に漏れがないか（deps/ディレクトリの全.mkファイルと照合）
- [ ] Compilerモジュールの「差し替え可能」という記述が現在のコードで実際にサポートされているか
- [ ] FemtoLispからJuliaSyntax/JuliaLoweringへの移行状態が正確か（開発者に確認）
- [ ] GC実装（Stock GC / MMTk GC）の記述が最新の開発状態を反映しているか
- [ ] タスクスケジューリング（ワークスティーリング）の記述がsrc/scheduler.cの実装と一致するか
- [ ] データフロー（コード実行パイプライン）の各ステップが実際の実行順序と一致するか
