# アーキテクチャ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph UserSpace["ユーザー空間"]
        UserCode["ユーザーコード<br/>(scripts / REPL入力)"]
    end

    subgraph StdLib["標準ライブラリ (stdlib/)"]
        Dates["Dates"]
        Random["Random"]
        TestLib["Test"]
        REPL["REPL"]
        PkgLib["Pkg"]
        Profile["Profile"]
        Printf["Printf"]
        Sockets["Sockets"]
        Serialization["Serialization"]
        StdLibOther["...約60パッケージ"]
    end

    subgraph JLLPackages["JLLバイナリラッパー (stdlib/*_jll/)"]
        OpenBLAS_jll["OpenBLAS_jll"]
        GMP_jll["GMP_jll"]
        MPFR_jll["MPFR_jll"]
        LibCURL_jll["LibCURL_jll"]
        LibGit2_jll["LibGit2_jll"]
        LLVM_jll["libLLVM_jll"]
        JLLOther["...その他JLL"]
    end

    subgraph BaseLayer["Base モジュール (base/)"]
        BaseCore["Core型・基本関数<br/>(boot.jl, essentials.jl)"]
        Collections["データ構造<br/>(array.jl, dict.jl, set.jl)"]
        IOSystem["I/Oシステム<br/>(io.jl, stream.jl, filesystem.jl)"]
        Concurrency["並行処理<br/>(task.jl, channels.jl, threads.jl)"]
        Loading["パッケージローディング<br/>(loading.jl, linking.jl)"]
        MathBase["数値演算<br/>(math.jl, float.jl, gmp.jl, mpfr.jl)"]
        StringProc["文字列処理<br/>(strings/, regex.jl)"]
    end

    subgraph CompilerLayer["Compiler モジュール (Compiler/src/)"]
        TypeInfer["型推論<br/>(typeinfer.jl)"]
        AbsInterp["抽象解釈<br/>(abstractinterpretation.jl)"]
        Optimize["最適化<br/>(optimize.jl)"]
        SSAIR["SSA IR<br/>(ssair/)"]
        TFuncs["型転送関数<br/>(tfuncs.jl)"]
    end

    subgraph FrontendLayer["フロントエンド"]
        JuliaSyntax["JuliaSyntax<br/>(パーサー)"]
        JuliaLowering["JuliaLowering<br/>(Lowering)"]
        FemtoLisp["FemtoLisp<br/>(レガシーフロントエンド)<br/>src/flisp/"]
    end

    subgraph RuntimeLayer["C/C++ ランタイム (src/)"]
        subgraph RuntimeCore["ランタイムコア (libjulia)"]
            Init["初期化<br/>(init.c)"]
            TypeSystem["型システム<br/>(jltypes.c, datatype.c)"]
            GF["ジェネリック関数ディスパッチ<br/>(gf.c)"]
            TaskSched["タスクスケジューラ<br/>(task.c, scheduler.c)"]
            Threading["スレッド管理<br/>(threading.c)"]
            Builtins["組み込み関数<br/>(builtins.c)"]
            Signals["シグナル処理<br/>(signals-*.c)"]
            AST["AST処理<br/>(ast.c)"]
        end

        subgraph GCLayer["ガベージコレクタ"]
            GCInterface["GCインターフェース<br/>(gc-interface.h)"]
            GCStock["Stock GC<br/>(gc-stock.c)"]
            GCMMTk["MMTk GC<br/>(gc-mmtk.c)"]
        end

        subgraph CodegenLayer["コード生成 (libjulia-codegen)"]
            Codegen["JITコード生成<br/>(codegen.cpp)"]
            AOT["AOTコンパイル<br/>(aotcompile.cpp)"]
            CGUtils["コード生成ユーティリティ<br/>(cgutils.cpp)"]
            CCall["ccallコード生成<br/>(ccall.cpp)"]
            JITLayers["JITレイヤー管理<br/>(jitlayers.cpp)"]
            LLVMPasses["LLVMカスタムパス<br/>(llvm-*.cpp)"]
        end

        SupportLib["サポートライブラリ<br/>(src/support/)"]
    end

    subgraph CLILayer["CLI / Loader (cli/)"]
        LoaderExe["loader_exe.c<br/>(エントリポイント)"]
        LoaderLib["loader_lib.c<br/>(ライブラリローダー)"]
    end

    subgraph ExternalDeps["外部依存ライブラリ (deps/)"]
        LLVM["LLVM"]
        LibUV["libuv"]
        OpenBLAS["OpenBLAS"]
        GMP["GMP"]
        MPFR["MPFR"]
        PCRE2["PCRE2"]
        LibGit2["libgit2"]
        LibSSH2["libssh2"]
        OpenSSL["OpenSSL"]
        UTF8Proc["utf8proc"]
        LibUnwind["libunwind"]
        OpenLibm["OpenLibm"]
        DSFMT["dSFMT"]
        SuiteSparse["SuiteSparse"]
    end

    UserCode --> StdLib
    UserCode --> BaseLayer
    StdLib --> BaseLayer
    StdLib --> JLLPackages
    JLLPackages -.->|バイナリ提供| ExternalDeps
    BaseLayer --> CompilerLayer
    BaseLayer --> FrontendLayer
    CompilerLayer --> RuntimeLayer
    FrontendLayer --> RuntimeLayer
    BaseLayer -->|ccall| RuntimeLayer
    RuntimeCore --> GCLayer
    RuntimeCore --> SupportLib
    CodegenLayer --> LLVM
    RuntimeCore --> LibUV
    CLILayer -->|動的ロード| RuntimeCore
    CLILayer -->|動的ロード| CodegenLayer
    GCInterface --> GCStock
    GCInterface --> GCMMTk
```

## レイヤー依存関係図

```mermaid
graph TD
    CLI["CLI / Loader<br/>(cli/)"]
    RT["Runtime - libjulia<br/>(src/ C/C++)"]
    CG["Codegen - libjulia-codegen<br/>(src/ C++/LLVM)"]
    Support["Support Library<br/>(src/support/)"]
    Core["Core Module<br/>(base/boot.jl)"]
    Base["Base Module<br/>(base/)"]
    Comp["Compiler Module<br/>(Compiler/)"]
    FE["Frontend<br/>(JuliaSyntax / JuliaLowering)"]
    Stdlib["Standard Library<br/>(stdlib/)"]
    User["User Code"]

    CLI -->|動的ロード| RT
    CLI -->|動的ロード| CG
    RT --> Support
    CG --> RT
    Core -->|ccall| RT
    Base --> Core
    Comp --> Base
    Comp --> Core
    FE --> Base
    FE --> Core
    Stdlib --> Base
    User --> Stdlib
    User --> Base

    style CLI fill:#e1f5fe
    style RT fill:#fff3e0
    style CG fill:#fff3e0
    style Support fill:#fff3e0
    style Core fill:#e8f5e9
    style Base fill:#e8f5e9
    style Comp fill:#f3e5f5
    style FE fill:#f3e5f5
    style Stdlib fill:#e8f5e9
    style User fill:#fce4ec
```

## コード実行パイプライン

```mermaid
flowchart LR
    Source["ソースコード"]
    Parse["パース<br/>(JuliaSyntax)"]
    MacroExp["マクロ展開"]
    Lower["Lowering<br/>(JuliaLowering)"]
    TypeInf["型推論<br/>(Compiler)"]
    Opt["最適化<br/>(Compiler)"]
    LLVMGen["LLVM IR生成<br/>(codegen.cpp)"]
    LLVMOpt["LLVM最適化"]
    NativeCode["ネイティブコード"]
    Exec["実行"]

    Source --> Parse
    Parse --> MacroExp
    MacroExp --> Lower
    Lower --> TypeInf
    TypeInf --> Opt
    Opt --> LLVMGen
    LLVMGen --> LLVMOpt
    LLVMOpt --> NativeCode
    NativeCode --> Exec

    style Source fill:#e3f2fd
    style Parse fill:#e8f5e9
    style MacroExp fill:#e8f5e9
    style Lower fill:#e8f5e9
    style TypeInf fill:#f3e5f5
    style Opt fill:#f3e5f5
    style LLVMGen fill:#fff3e0
    style LLVMOpt fill:#fff3e0
    style NativeCode fill:#fce4ec
    style Exec fill:#fce4ec
```

## GC実装切り替え構造

```mermaid
graph TB
    Runtime["Runtime (src/)"]
    GCInterface["gc-interface.h<br/>(抽象インターフェース)"]
    StockGC["Stock GC<br/>(gc-stock.c)<br/>Mark & Sweep / Generational"]
    MMTkGC["MMTk GC<br/>(gc-mmtk.c)<br/>Memory Management Toolkit"]
    GCCommon["gc-common.c<br/>(共通ユーティリティ)"]
    GCDebug["gc-debug.c"]
    GCPages["gc-pages.c"]
    GCStacks["gc-stacks.c"]

    Runtime --> GCInterface
    GCInterface -->|選択| StockGC
    GCInterface -->|選択| MMTkGC
    StockGC --> GCCommon
    MMTkGC --> GCCommon
    StockGC --> GCDebug
    StockGC --> GCPages
    StockGC --> GCStacks

    style GCInterface fill:#e1f5fe
    style StockGC fill:#e8f5e9
    style MMTkGC fill:#fff3e0
```

## タスクスケジューリング構造

```mermaid
graph TB
    UserTask["ユーザータスク<br/>(Task)"]
    Schedule["schedule()"]
    WSQueue["ワークスティーリングキュー<br/>(work-stealing-queue.h)"]
    Scheduler["スケジューラ<br/>(scheduler.c)"]
    OSThread1["OSスレッド 1"]
    OSThread2["OSスレッド 2"]
    OSThreadN["OSスレッド N"]
    LibUV["libuv イベントループ<br/>(非同期I/O)"]
    Channel["Channel<br/>(タスク間通信)"]

    UserTask --> Schedule
    Schedule --> WSQueue
    WSQueue --> Scheduler
    Scheduler --> OSThread1
    Scheduler --> OSThread2
    Scheduler --> OSThreadN
    OSThread1 -.->|I/O待機| LibUV
    OSThread2 -.->|I/O待機| LibUV
    UserTask <-->|put!/take!| Channel
```
