---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 32
  claims_with_evidence: 27
  claims_without_evidence: 5
confidence_derived: 0.84
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.84**
  - 根拠あり：27 / 32、根拠なし：5
- 優先レビュー（高）
  1. **AWS S3配布構成の詳細**: Makefile内のリリース手順コメントから推定したが、AWS構成の詳細は未確認
  2. **julialang.org Webサーバー構成**: 外部サービスのため、ソースコードからは詳細不明
  3. **status.julialang.org 構成**: 外部サービスのため、ソースコードからは詳細不明
  4. **バックアップ設計の保持期間**: ソースコードからは保持ポリシーの直接的な根拠なし
  5. **FreeBSD対応のアーキテクチャ**: x86_64のみか他のアーキテクチャも対応するか未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Makefile`（トップレベル）- ビルドターゲット、インストール手順、リリース手順
- E-02: `Make.inc` - ビルド設定、プラットフォーム検出、依存ライブラリフラグ
- E-03: `deps/Makefile` - 依存ライブラリビルドルール
- E-04: `deps/llvm.version` - LLVM 20.1.8
- E-05: `deps/openblas.version` - OpenBLAS 0.3.30、LAPACK 3.12.1
- E-06: `deps/libuv.version` - libuv 1.48.0
- E-07: `deps/pcre.version` - PCRE2 10.47
- E-08: `deps/gmp.version` - GMP 6.3.0
- E-09: `deps/mpfr.version` - MPFR 4.2.2
- E-10: `deps/openssl.version` - OpenSSL 3.5.5
- E-11: `deps/curl.version` - libcurl 8.18.0
- E-12: `deps/libgit2.version` - libgit2 1.9.2
- E-13: `deps/libssh2.version` - libssh2 1.11.1
- E-14: `deps/nghttp2.version` - nghttp2 1.68.0
- E-15: `deps/zlib.version` - zlib 1.3.1
- E-16: `deps/zstd.version` - Zstandard 1.5.7
- E-17: `.github/workflows/Whitespace.yml` - Whitespaceチェック CI
- E-18: `.github/workflows/cffconvert.yml` - CFF検証 CI
- E-19: `.github/workflows/Typos.yml` - タイポチェック CI
- E-20: `.github/workflows/LabelCheck.yml` - ラベルチェック CI
- E-21: `.github/workflows/PrAssignee.yml` - PR担当者設定 CI
- E-22: `.github/workflows/backport-label-audit.yml` - バックポートラベル監査 CI
- E-23: `contrib/httpbin-prod-swagger-apigateway.yaml` - httpbin API Gateway設定
- E-24: `VERSION` - Julia 1.14.0-DEV
- E-25: `src/Makefile` - ランタイムソースファイル一覧、GC構成
- E-26: `contrib/pgo-lto/Makefile` - PGO/LTO最適化
- E-27: `contrib/bolt/Makefile` - BOLT最適化
- E-28: `AGENTS.md` - ビルド手順、テスト手順の記載

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Juliaバージョンは1.14.0-DEV | E-24 | ○ |
| C-02 | LLVMバージョンは20.1.8 | E-04 | ○ |
| C-03 | OpenBLASバージョンは0.3.30 | E-05 | ○ |
| C-04 | LAPACKバージョンは3.12.1 | E-05 | ○ |
| C-05 | libuvバージョンは1.48.0 | E-06 | ○ |
| C-06 | PCRE2バージョンは10.47 | E-07 | ○ |
| C-07 | GMPバージョンは6.3.0 | E-08 | ○ |
| C-08 | MPFRバージョンは4.2.2 | E-09 | ○ |
| C-09 | OpenSSLバージョンは3.5.5 | E-10 | ○ |
| C-10 | libcurlバージョンは8.18.0 | E-11 | ○ |
| C-11 | libgit2バージョンは1.9.2 | E-12 | ○ |
| C-12 | libssh2バージョンは1.11.1 | E-13 | ○ |
| C-13 | nghttp2バージョンは1.68.0 | E-14 | ○ |
| C-14 | zlibバージョンは1.3.1 | E-15 | ○ |
| C-15 | Zstandard(zstd)バージョンは1.5.7 | E-16 | ○ |
| C-16 | GitHub Actions CI/CDワークフローが6つ存在する | E-17, E-18, E-19, E-20, E-21, E-22 | ○ |
| C-17 | Whitespaceチェックのtimeoutは2分 | E-17 | ○ |
| C-18 | httpbin.julialang.orgはAmazon API Gatewayで動作 | E-23 | ○ |
| C-19 | Linux、macOS、Windows、FreeBSDの4プラットフォーム対応 | E-01, E-02 | ○ |
| C-20 | macOS最小対応バージョンはx86_64で10.14、arm64で11.0 | E-02 | ○ |
| C-21 | WindowsビルドはInno Setupでインストーラ生成 | E-01 | ○ |
| C-22 | PGO/LTO/BOLTによるビルド最適化対応あり | E-26, E-27 | ○ |
| C-23 | BinaryBuilder(JLL)またはソースビルドの2系統で依存管理 | E-02, E-03 | ○ |
| C-24 | MMTk GCバックエンドへの実験的対応あり | E-02, E-25 | ○ |
| C-25 | プロファイリング対応(OProfile, perf, Intel, Tracy, DTrace, NVTX, Apple Instruments) | E-02 | ○ |
| C-26 | make -jによる並列ビルドサポート | E-01, E-28 | ○ |
| C-27 | Clang Static Analyzerによる静的解析対応 | E-28 | ○ |
| C-28 | AWS S3でリリースバイナリが配布される | E-01 (コメント行204-205) | △ |
| C-29 | julialang.orgがダウンロードページとして機能 | E-01 (コメント行204) | △ |
| C-30 | status.julialang.orgがステータスページとして機能 | E-01 (コメント行204) | △ |
| C-31 | バックアップ（リリースバイナリ）は無期限保持 | **根拠なし** | △ |
| C-32 | FreeBSD対応アーキテクチャはx86_64 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- AWS S3の配布構成詳細（バケット名、リージョン、CDN構成等）はソースコード内に記載がない。Makefile内のリリース手順コメント（行204-205）が唯一の言及である。
  - 候補：AWS管理コンソール / インフラチームへの確認 / julialang.org管理者への問い合わせ
- julialang.orgおよびstatus.julialang.orgのサーバー構成はプロジェクトリポジトリ外で管理されている。
  - 候補：julialang.orgのインフラリポジトリ / JuliaLangオーガニゼーションの別リポジトリ
- バイナリリリースの保持ポリシーに関する明示的な記載がソースコード内に存在しない。
  - 候補：リリースプロセス文書 / AWS S3ライフサイクルポリシー設定
- FreeBSDのサポートアーキテクチャの明確な一覧がない（x86_64以外の対応状況が不明）。
  - 候補：CI/CD構成の確認 / FreeBSD CI/CDログの確認

## 5) リスクフラグ（レビュー観点）
- リスク1（中リスク）：AWS配布インフラの詳細がソースコードから読み取れない。実際の構成と乖離している可能性がある。
- リスク0（低リスク）：依存ライブラリのバージョン情報はすべてdeps/*.versionファイルから直接取得しており、信頼性が高い。
- リスク0（低リスク）：CI/CDワークフロー情報は.github/workflows/配下のYAMLファイルから直接取得しており、信頼性が高い。
- リスク1（中リスク）：外部サービス（julialang.org、status.julialang.org）の構成はプロジェクトリポジトリ外で管理されており、現在の状態との整合性を確認する必要がある。

## 6) レビュアーチェックリスト（最小）
- [ ] 依存ライブラリのバージョン番号が最新のdeps/*.versionファイルと一致しているか確認
- [ ] GitHub Actionsワークフローの一覧が.github/workflows/配下のファイルと一致しているか確認
- [ ] AWS S3配布構成の記述が実際のインフラ構成と整合しているか確認
- [ ] julialang.orgおよびstatus.julialang.orgの記述が実際のサービス構成と整合しているか確認
- [ ] 対応プラットフォーム一覧が現在のCI/CD構成で実際にビルド・テストされているものと一致しているか確認
- [ ] ビルドモード（release/debug）の記述がMake.incの設定と整合しているか確認
