# インフラ構成図

## 全体構成図

```mermaid
graph TB
    subgraph "開発者環境"
        DEV[開発者]
        LOCAL_BUILD["ローカルビルド環境<br/>make -j"]
    end

    subgraph "ソースコード管理"
        GITHUB["GitHub<br/>JuliaLang/julia"]
        GH_ACTIONS["GitHub Actions<br/>CI/CD"]
    end

    subgraph "CI/CDパイプライン"
        WS_CHECK["Whitespaceチェック<br/>ubuntu-latest"]
        TYPO_CHECK["Typosチェック<br/>ubuntu-latest"]
        CFF_CHECK["CFF検証<br/>ubuntu-latest"]
        LABEL_CHECK["ラベルチェック"]
    end

    subgraph "ビルドシステム"
        MAKE["GNU Make<br/>Makefile / Make.inc"]
        DEPS_BUILD["依存ライブラリビルド<br/>deps/Makefile"]
        BB["BinaryBuilder<br/>JLL Artifacts"]
        SRC_BUILD["ソースビルド<br/>deps/srccache"]
    end

    subgraph "配布インフラ"
        AWS_S3["AWS S3<br/>バイナリ配布"]
        JULIALANG["julialang.org<br/>ダウンロードページ"]
        JULIAUP["Juliaup<br/>バージョン管理"]
        STATUS["status.julialang.org<br/>ステータスページ"]
    end

    subgraph "テスト基盤"
        HTTPBIN["httpbin.julialang.org<br/>Amazon API Gateway"]
    end

    DEV --> GITHUB
    DEV --> LOCAL_BUILD
    GITHUB --> GH_ACTIONS
    GH_ACTIONS --> WS_CHECK
    GH_ACTIONS --> TYPO_CHECK
    GH_ACTIONS --> CFF_CHECK
    GH_ACTIONS --> LABEL_CHECK

    LOCAL_BUILD --> MAKE
    MAKE --> DEPS_BUILD
    DEPS_BUILD --> BB
    DEPS_BUILD --> SRC_BUILD

    MAKE --> AWS_S3
    AWS_S3 --> JULIALANG
    JULIALANG --> JULIAUP
    JULIALANG --> STATUS
```

## ビルドパイプライン構成図

```mermaid
graph LR
    subgraph "ビルドフェーズ"
        direction TB
        DEPS["julia-deps<br/>依存ライブラリ"]
        FLISP["julia_flisp.boot.inc<br/>FLISPブートストラップ"]
        CLI_R["julia-cli-release<br/>CLIビルド"]
        SRC_R["julia-src-release<br/>ランタイムビルド"]
        BASE["julia-base<br/>Baseライブラリ"]
        STDLIB["julia-stdlib<br/>標準ライブラリ"]
        SYSIMG["julia-sysimg-release<br/>システムイメージ"]
        CACHE["stdlibs-cache-release<br/>プリコンパイルキャッシュ"]
        RELEASE["release<br/>リリースビルド完成"]
    end

    DEPS --> FLISP
    DEPS --> CLI_R
    FLISP --> SRC_R
    CLI_R --> SRC_R
    DEPS --> BASE
    DEPS --> STDLIB
    SRC_R --> SYSIMG
    BASE --> SYSIMG
    STDLIB --> SYSIMG
    CLI_R --> SYSIMG
    SYSIMG --> CACHE
    CACHE --> RELEASE
```

## 依存ライブラリ構成図

```mermaid
graph TB
    subgraph "コアランタイム依存"
        LLVM["LLVM 20.1.8<br/>JITコンパイラ"]
        LIBUV["libuv 1.48.0<br/>非同期I/O"]
        LIBUNWIND["libunwind<br/>スタックアンワインド"]
        OPENLIBM["OpenLibm<br/>数学関数"]
        DSFMT["dSFMT<br/>乱数生成"]
        UTF8PROC["utf8proc<br/>Unicode処理"]
    end

    subgraph "数値計算依存"
        OPENBLAS["OpenBLAS 0.3.30<br/>BLAS実装"]
        LAPACK["LAPACK 3.12.1<br/>線形代数"]
        GMP["GMP 6.3.0<br/>多倍長整数"]
        MPFR["MPFR 4.2.2<br/>多倍長浮動小数点"]
        SUITESPARSE["SuiteSparse<br/>スパース行列"]
        BLASTRAMPOLINE["blastrampoline<br/>BLAS抽象化"]
    end

    subgraph "ネットワーク依存"
        OPENSSL["OpenSSL 3.5.5<br/>TLS/SSL"]
        CURL["libcurl 8.18.0<br/>HTTPクライアント"]
        LIBSSH2["libssh2 1.11.1<br/>SSHプロトコル"]
        LIBGIT2["libgit2 1.9.2<br/>Gitプロトコル"]
        NGHTTP2["nghttp2 1.68.0<br/>HTTP/2"]
    end

    subgraph "圧縮・ユーティリティ"
        ZLIB["zlib 1.3.1<br/>圧縮"]
        ZSTD["Zstandard 1.5.7<br/>高速圧縮"]
        PCRE2["PCRE2 10.47<br/>正規表現"]
        P7ZIP["p7zip<br/>7z圧縮"]
        LLD["LLD<br/>LLVMリンカ"]
    end

    CURL --> OPENSSL
    CURL --> NGHTTP2
    CURL --> ZLIB
    LIBGIT2 --> LIBSSH2
    LIBGIT2 --> OPENSSL
    LIBSSH2 --> OPENSSL
    OPENBLAS --> LAPACK
    BLASTRAMPOLINE --> OPENBLAS
```

## マルチプラットフォーム配布構成図

```mermaid
graph TB
    subgraph "ビルド成果物"
        BUILD["ビルド完了<br/>julia-release"]
    end

    subgraph "プラットフォーム別パッケージング"
        LINUX["Linux<br/>tar.gz<br/>(patchelf RPATH修正)"]
        MACOS["macOS<br/>.dmg / Framework<br/>(install_name_tool RPATH修正)"]
        WINDOWS["Windows<br/>.exe<br/>(Inno Setup インストーラ)"]
        FREEBSD["FreeBSD<br/>tar.gz<br/>(patchelf RPATH修正)"]
    end

    subgraph "配布"
        S3["AWS S3"]
        DOWNLOAD["julialang.org/downloads"]
        UP["Juliaup"]
    end

    BUILD --> LINUX
    BUILD --> MACOS
    BUILD --> WINDOWS
    BUILD --> FREEBSD

    LINUX --> S3
    MACOS --> S3
    WINDOWS --> S3
    FREEBSD --> S3

    S3 --> DOWNLOAD
    DOWNLOAD --> UP
```

## CI/CDワークフロー構成図

```mermaid
graph TB
    subgraph "トリガー"
        PUSH["push to master"]
        PR["Pull Request"]
    end

    subgraph "GitHub Actions ワークフロー"
        WS["Whitespace.yml<br/>空白文字チェック<br/>timeout: 2分"]
        TYPOS["Typos.yml<br/>タイポチェック"]
        CFF["cffconvert.yml<br/>CITATION.cff検証"]
        LABEL["LabelCheck.yml<br/>ラベル検証"]
        ASSIGNEE["PrAssignee.yml<br/>PR担当者設定"]
        BACKPORT["backport-label-audit.yml<br/>バックポートラベル監査"]
    end

    subgraph "ローカルテスト"
        MAKE_TEST["make test<br/>テストスイート実行"]
        MAKE_TESTALL["make testall<br/>全テスト実行"]
        REVISE_TEST["make test-revise-*<br/>Revise経由テスト"]
        STATIC["静的解析<br/>clang-sa / clang-tidy"]
    end

    PUSH --> WS
    PUSH --> CFF
    PR --> WS
    PR --> TYPOS
    PR --> CFF
    PR --> LABEL
    PR --> ASSIGNEE
    PR --> BACKPORT
```
