# インフラ設計書

## 概要

本ドキュメントは、Julia言語プロジェクト（バージョン 1.14.0-DEV）のビルド基盤、実行環境基盤、CI/CDパイプライン、依存ライブラリ管理、および配布インフラの設計を記載するものである。Juliaはネイティブコンパイル方式の高性能プログラミング言語であり、C/C++ランタイム（LLVM 20.1.8ベース）とJulia言語で記述された標準ライブラリから構成される。本プロジェクトはWebサービスではなく、マルチプラットフォーム対応のソフトウェア配布を主目的としたインフラ構成を採用している。

## システム構成

### 全体構成

Julia言語プロジェクトのインフラは、以下の4つの主要レイヤーで構成される。

1. **ビルド基盤**: Make（GNU Make）を中心としたビルドシステム。`Makefile`、`Make.inc`によりクロスプラットフォームビルドを実現する。
2. **CI/CDパイプライン**: GitHub Actionsによる自動化（Whitespaceチェック、CFFバリデーション、ラベルチェック、タイポチェック等）。
3. **依存ライブラリ管理**: `deps/`ディレクトリ配下でBinaryBuilder（JLL）またはソースビルドによる外部ライブラリ管理。
4. **配布インフラ**: AWS上でのバイナリ配布、Juliaupによるバージョン管理、各プラットフォーム向けインストーラ生成。

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| GitHub Actionsランナー | CI/CDジョブ実行（Whitespace、Typos、CFF検証等） | ubuntu-latest | オンデマンド |
| AWS S3 | バイナリ配布用ストレージ | -- | -- |
| julialang.org Webサーバー | ダウンロードページ、ドキュメントホスティング | -- | -- |
| httpbin.julialang.org | テスト用HTTPモックサービス（Amazon API Gateway） | -- | 1 |

### ネットワーク構成

本プロジェクトはクラウドネイティブなWebサービスではないため、専用のネットワーク構成は限定的である。

- **GitHub**: ソースコード管理、CI/CDパイプライン、Issue管理
- **AWS**: バイナリ配布（S3）、テスト用API（API Gateway）
- **julialang.org**: 公式Webサイト（ダウンロード、ドキュメント）
- **HTTPS**: 全ての外部通信はHTTPSを使用

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| LLVM | 20.1.8 | JITコンパイラバックエンド、コード生成 |
| OpenBLAS | 0.3.30 | 線形代数演算（BLAS/LAPACK） |
| LAPACK | 3.12.1 | 線形代数ルーチン |
| libuv | 1.48.0 (julia-uv2) | 非同期I/O、イベントループ |
| PCRE2 | 10.47 | 正規表現ライブラリ |
| GMP | 6.3.0 | 多倍長整数演算 |
| MPFR | 4.2.2 | 多倍長浮動小数点演算 |
| OpenSSL | 3.5.5 | TLS/SSL暗号化通信 |
| libcurl | 8.18.0 | HTTP/HTTPSクライアント |
| libgit2 | 1.9.2 | Gitプロトコル操作 |
| libssh2 | 1.11.1 | SSHプロトコル |
| nghttp2 | 1.68.0 | HTTP/2プロトコル |
| zlib | 1.3.1 | データ圧縮 |
| Zstandard (zstd) | 1.5.7 | 高速データ圧縮 |
| SuiteSparse | -- | スパース行列演算 |
| OpenLibm | -- | 数学関数ライブラリ |
| dSFMT | -- | 高速乱数生成 |
| blastrampoline | -- | BLAS抽象化レイヤー |
| utf8proc | -- | Unicode処理 |
| LLD | -- | LLVMリンカ |
| p7zip | -- | 7z圧縮/展開 |
| patchelf | -- | ELFバイナリRPATH修正（Linux/FreeBSD） |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| GitHub | ソースコードホスティング、CI/CD、Issue管理 | HTTPS (Git) |
| GitHub Actions | CI/CDパイプライン実行 | GitHub API |
| AWS S3 | リリースバイナリ配布 | HTTPS |
| Amazon API Gateway | テスト用HTTPbinモック (httpbin.julialang.org) | HTTPS (REST) |
| julialang.org | 公式サイト（ダウンロード、ドキュメント） | HTTPS |
| status.julialang.org | ステータスページ | HTTPS |
| Juliaup (GitHub) | バージョン管理ツール配布 | HTTPS |
| Mozilla CA Certificate Store | ルート証明書 | HTTPS |
| BinaryBuilder.jl | 依存ライブラリのプリビルドバイナリ提供 | HTTPS (JLL Artifacts) |

## スケーリング設計

本プロジェクトはWebサービスではないため、ランタイムスケーリングは該当しない。ただし、以下のスケーリングに関する設計が存在する。

### ビルド並列化
- `make -j` による並列ビルドをサポート
- `JULIA_THREADS` 設定によるスレッド数制御（デフォルト: 1）
- OpenBLASの `OPENBLAS_USE_THREAD:=1` によるマルチスレッド演算

### CI/CDスケーリング
- GitHub Actionsのオンデマンドランナーによる並列ジョブ実行
- 各ワークフロー（Whitespace、Typos、CFF検証等）は独立して並列実行可能

### 配布スケーリング
- AWS S3によるバイナリ配布は、S3の自動スケーリングにより高負荷時も対応可能

## 可用性設計

### ビルド環境の可用性
- BinaryBuilder（JLL）によるプリビルドバイナリ提供により、ソースビルド失敗時のフォールバックを実現
- `USE_SYSTEM_*` フラグにより、システムインストール済みライブラリの利用が可能（フォールバック）
- `USE_BINARYBUILDER` フラグによりBinaryBuilder経由のビルド済みバイナリとソースビルドの切り替えが可能

### CI/CD の可用性
- GitHub Actionsはマネージドサービスとしてマルチリージョン冗長構成
- 各ワークフローにtimeout設定あり（例: Whitespaceチェックは2分）

### 配布の可用性
- AWS S3のマルチAZ冗長ストレージによる高可用性
- julialang.orgによるダウンロードリンクの管理
- Juliaupによる複数バージョンの並行管理

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Git分散リポジトリ（GitHub） | コミット毎 | 無期限 |
| 依存ライブラリソース | deps/srccache にtarball保存 | ビルド時 | ビルド期間中 |
| リリースバイナリ | AWS S3へのアップロード | リリース毎 | 無期限（全バージョン保持） |
| ドキュメント | GitHubリポジトリ + Webサイト | コミット毎 | 無期限 |

## 監視設計

### CI/CDパイプライン監視
- GitHub Actionsのワークフロー実行結果による自動通知
- Pull Request単位でのステータスチェック
- ブランチ保護ルールによるマージ前検証

### 配布サービス監視
- status.julialang.org によるステータスモニタリング
- versions.json によるバージョン管理と配布状態の追跡

### ビルド品質監視
- `make check-whitespace` によるコード品質チェック
- Clang Static Analyzer (`clang-sa`, `clang-sagc`, `clang-tidy`) によるC/C++コード静的解析
- `make test` / `make testall` による自動テスト実行
- LLVM Assertions / Force Assertions によるデバッグビルドでの検証

## 対応プラットフォーム

| プラットフォーム | アーキテクチャ | 配布形式 | 備考 |
| --- | --- | --- | --- |
| Linux | x86_64, aarch64 | tar.gz | PATCHELFによるRPATH修正 |
| macOS (Darwin) | x86_64 (10.14+), arm64 (11.0+) | .dmg / Framework | install_name_toolによるRPATH修正、Darwin Framework対応 |
| Windows (WINNT) | x86_64 | .exe (Inno Setup) | MinGW-w64クロスコンパイル対応 |
| FreeBSD | x86_64 | tar.gz | PATCHELFによるRPATH修正 |

## ビルドシステム詳細

### ビルドモード
- **release**: 本番用ビルド（`-O3`最適化）
- **debug**: デバッグ用ビルド（`-O0`、デバッグシンボル付き）

### ビルド最適化
- **PGO (Profile-Guided Optimization)**: `contrib/pgo-lto/` によるPGO対応
- **LTO (Link-Time Optimization)**: PGOと組み合わせた最適化
- **BOLT (Binary Optimization and Layout Tool)**: `contrib/bolt/` および `contrib/pgo-lto-bolt/` による後処理最適化

### 主要ビルドターゲット
| ターゲット | 説明 |
| --- | --- |
| `julia-deps` | 全依存ライブラリのビルド |
| `julia-base` | Juliaベースライブラリのビルド |
| `julia-stdlib` | 標準ライブラリのビルド |
| `julia-src-release` / `julia-src-debug` | C/C++ランタイムのビルド |
| `julia-sysimg-release` / `julia-sysimg-debug` | システムイメージの生成 |
| `stdlibs-cache-release` / `stdlibs-cache-debug` | 標準ライブラリのプリコンパイルキャッシュ生成 |
| `binary-dist` | 配布用バイナリパッケージの作成 |
| `install` | ローカルインストール |

## 備考

- 本プロジェクトはプログラミング言語処理系であり、一般的なWebサービスインフラとは異なる構成を持つ。
- 依存ライブラリはBinaryBuilder（JLLアーティファクト）またはソースビルドの2系統で管理され、`USE_BINARYBUILDER` フラグで切り替え可能である。
- クロスコンパイルは `XC_HOST` 変数により対応し、主にWindows向けのMinGW-w64クロスビルドに使用される。
- プロファイリング機能として、OProfile、perf、Intel VTune、Tracy、DTrace、NVTX、Apple Instruments (os_log) への対応が組み込まれている。
- GCバックエンドとして、デフォルトのStockGCに加え、MMTk（Memory Management Toolkit）への実験的対応がある。
