---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 27
  claims_without_evidence: 3
confidence_derived: 0.90
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：27 / 30、根拠なし：3
- 優先レビュー（高）
  1. **TLS 1.2/1.3 バージョン指定**：OpenSSL 3.x のTLSバージョン設定はJLLラッパーのみ確認であり、実際のTLSバージョン設定は確認できていない
  2. **libuv経由のOSエントロピーソース詳細**：`uv_random` の各OS実装（getrandom/BCryptGenRandom等）はlibuv内部実装であり、Julia側のソースからは直接確認できない
  3. **外部依存ライブラリのセキュリティ管理方針**：JLLパッケージの更新プロセスの具体的手順は推測に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `stdlib/LibGit2/src/callbacks.jl` -- LibGit2認証コールバック実装
- E-02: `stdlib/LibGit2/src/types.jl` -- クレデンシャル型定義（UserPasswordCredential、SSHCredential、CachedCredentials、CredentialPayload）
- E-03: `stdlib/LibGit2/src/gitcredential.jl` -- GitCredential型とcredential helper連携
- E-04: `base/secretbuffer.jl` -- SecretBuffer実装（shred!、securezero!、定数時間比較）
- E-05: `base/util.jl` -- securezero!、getpass、winprompt実装
- E-06: `stdlib/Random/src/Random.jl` -- Randomモジュールのエントリポイント（SHA利用）
- E-07: `stdlib/Random/src/RNGs.jl` -- RandomDevice、SeedHasher、seed!実装
- E-08: `stdlib/Random/src/Xoshiro.jl` -- Xoshiro256++ PRNG実装
- E-09: `stdlib/OpenSSL_jll/src/OpenSSL_jll.jl` -- OpenSSL 3.x JLLラッパー
- E-10: `src/gc-stacks.c` -- スタックガードページ実装
- E-11: `src/cgmemmgr.cpp` -- JITコード生成メモリ保護（W^X）
- E-12: `Make.inc` -- RELROフラグ設定
- E-13: `base/libc.jl` -- Libc.getrandom! / uv_random呼び出し
- E-14: `src/jitlayers.h` -- サニタイザ対応フラグ
- E-15: `base/essentials.jl` -- @boundscheck / checkbounds実装
- E-16: `src/jlapi.c` -- jl_sigatomic_begin/end（シグナル保護）
- E-17: `base/file.jl` -- chmod/mkdir パーミッション管理
- E-18: `base/download.jl` -- Downloads.jl経由のダウンロード
- E-19: `stdlib/MozillaCACerts_jll/` -- MozillaCA証明書バンドル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LibGit2はSSH-Agent、SSH鍵ペア、ユーザ名/パスワードの順に認証を試行する | E-01 | ○ |
| C-02 | 認証プロンプト回数の上限はデフォルト3回 | E-02 | ○ |
| C-03 | CachedCredentialsはURLベースのキーでクレデンシャルをキャッシュする | E-02, E-03 | ○ |
| C-04 | SecretBufferはshred!でsecurezero!による安全な消去を行う | E-04 | ○ |
| C-05 | SecretBufferの==演算子は定数時間比較（XOR+OR）を使用する | E-04 | ○ |
| C-06 | すべてのSecretBufferは同一ハッシュ値を返す | E-04 | ○ |
| C-07 | GCファイナライザが未消去のSecretBufferを検出し警告する | E-04 | ○ |
| C-08 | バッファリサイズ時に旧データをsecurezero!で消去する | E-04 | ○ |
| C-09 | securezero!は@noinlineで修飾されコンパイラ最適化を防止する | E-05 | ○ |
| C-10 | getpassはターミナルエコーを無効化してSecretBufferを返す | E-05 | ○ |
| C-11 | winpromptはCredUIPromptForWindowsCredentialsW APIを使用する | E-05 | ○ |
| C-12 | UserPasswordCredentialのパスワードはSecretBufferで保持される | E-02 | ○ |
| C-13 | SSHCredentialのパスフレーズはSecretBufferで保持される | E-02 | ○ |
| C-14 | GitCredentialのshred!ですべてのフィールドが消去される | E-03 | ○ |
| C-15 | OpenSSL 3.xがOpenSSL_jllとして同梱される | E-09 | ○ |
| C-16 | TLS通信でTLS 1.2/1.3を使用する | E-09 | △ |
| C-17 | LibGit2のcertificate_callbackでTLS証明書検証を実施する | E-01 | ○ |
| C-18 | ssh_knownhost_checkでknown_hostsベースのホストキー検証を実施する | E-01 | ○ |
| C-19 | MozillaCACerts_jllでCA証明書バンドルを提供する | E-19 | ○ |
| C-20 | NetworkOptions.verify_hostでホスト検証をオプトアウト可能 | E-01 | ○ |
| C-21 | SeedHasherはSHA2-256/SHA2-512を使用してシードをハッシュする | E-07 | ○ |
| C-22 | RandomDeviceはLibc.getrandom!経由でuv_randomを呼び出す | E-07, E-13 | ○ |
| C-23 | uv_randomはLinuxでgetrandom(2)、WindowsでBCryptGenRandomを使用する | **根拠なし** | △ |
| C-24 | スタックガードページサイズは32768バイト（4096*8） | E-10 | ○ |
| C-25 | JITコード生成時にW^Xポリシーを実施する | E-11 | ○ |
| C-26 | LinuxビルドでRELROフラグ（-Wl,-z,relro）を使用する | E-12 | ○ |
| C-27 | AddressSanitizer、MemorySanitizer、ThreadSanitizerに対応する | E-14 | ○ |
| C-28 | @boundscheck/checkboundsで配列境界チェックを行う | E-15 | ○ |
| C-29 | jl_sigatomic_begin/endでシグナル保護領域を定義する | E-16 | ○ |
| C-30 | JLLパッケージのバージョン更新で外部依存ライブラリのセキュリティを管理する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-16（TLSバージョン）**: OpenSSL 3.x JLLの存在は確認できるが、TLSバージョン設定（1.2/1.3）の具体的な設定箇所はJulia側のソースコードからは特定できない。OpenSSLのデフォルト動作に基づく推測
  - 候補：OpenSSLのコンパイルオプション / Downloads.jl内の設定 / libcurlの設定
- **C-23（OSエントロピーソース詳細）**: `uv_random` の各OS実装詳細はlibuv内部の実装であり、Juliaプロジェクトのソースコードからは直接確認できない
  - 候補：libuvソースコード / libuv公式ドキュメント / OSのman pages
- **C-30（JLLセキュリティ管理方針）**: JLLの更新がセキュリティパッチに追従するプロセスはソースコードからは確認できない推測
  - 候補：JuliaLang/julia リリースポリシー / BinaryBuilder.jl ドキュメント / Juliaセキュリティポリシー

## 5) リスクフラグ（レビュー観点）
- リスク2（高）：`eval`/`Meta.parse`/`include` による動的コード実行にサンドボックス機構が存在しない。実行環境の隔離はOS/インフラレベルで対処が必要
- リスク1（中）：`ccall`（FFI）使用時のメモリ安全性はユーザ責任であり、不正なポインタ操作によるメモリ破壊リスクが存在する
- リスク1（中）：`@inbounds` マクロで境界チェックを明示的に無効化可能であり、ユーザコードのバグによるバッファオーバーリードの可能性がある
- リスク0（低）：Xoshiro256++/MersenneTwisterは暗号学的に安全ではないが、暗号用途には `RandomDevice` が別途提供されている
- リスク0（低）：`NetworkOptions.verify_host` でホスト検証を無効化できるが、ユーザの明示的操作が必要

## 6) レビュアーチェックリスト（最小）
- [ ] OpenSSL 3.x の実際のTLSバージョン設定が1.2/1.3であることを確認する（C-16）
- [ ] libuv の `uv_random` が各OS上でCSPRNG品質のエントロピーを使用していることを確認する（C-23）
- [ ] JLLパッケージのセキュリティアップデート追従プロセスが存在することを確認する（C-30）
- [ ] `eval`/`Meta.parse` の動的コード実行に関するセキュリティガイドライン・ドキュメントの有無を確認する
- [ ] RELROが `relro` のみで `full relro`（`-Wl,-z,now` 含む）ではないことの意図を確認する
- [ ] `SecretBuffer` の定数時間比較がサイドチャネル攻撃に対して十分であるかを確認する
