---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **BuildkiteのメインCI環境としての位置づけ**：Buildkite設定ファイル（`.buildkite/`）がリポジトリ内に見当たらず、外部管理の可能性
  2. **Buildbotの現在の利用状況**：CONTRIBUTING.mdに記載があるが、現在も活用されているかは不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/runtests.jl` - テストエントリポイント、並列実行基盤
- E-02: `test/choosetests.jl` - テスト選択ロジック、テスト名リスト（TESTNAMES）
- E-03: `test/testdefs.jl` - テスト実行関数（runtests）、環境整合性チェック
- E-04: `test/testenv.jl` - テスト環境設定、addprocs_with_testenv関数
- E-05: `test/buildkitetestjson.jl` - BuildkiteTestJSONモジュール、テスト結果JSON出力
- E-06: `test/Makefile` - テストターゲット定義、テスト実行コマンド
- E-07: `Makefile`（ルート）- test/testall/test-*/test-revise-*ターゲット
- E-08: `.github/workflows/Whitespace.yml` - ホワイトスペースチェックワークフロー
- E-09: `.github/workflows/Typos.yml` - タイポチェックワークフロー
- E-10: `.github/workflows/LabelCheck.yml` - ラベルチェックワークフロー
- E-11: `.github/workflows/cffconvert.yml` - CITATIONバリデーション
- E-12: `.codecov.yml` - Codecov設定（project/patch off）
- E-13: `doc/src/devdocs/contributing/tests.md` - テスト記述ガイドライン
- E-14: `doc/Makefile` - doctest実行ターゲット
- E-15: `stdlib/Test/src/Test.jl` - Testフレームワークのソースコード
- E-16: `test/clangsa/Makefile` - Clang静的解析テスト設定
- E-17: `test/llvmpasses/Makefile` - LLVMパステスト設定
- E-18: `test/embedding/Makefile` - 埋め込みテスト設定
- E-19: `AGENTS.md` - 開発者向けテスト実行ガイド
- E-20: `CONTRIBUTING.md` - コントリビュータガイドライン
- E-21: `test/testhelpers/` ディレクトリ - テストヘルパーモジュール群
- E-22: `test/depot/packages/` - テスト用ダミーパッケージ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テストエントリポイントは `test/runtests.jl` であり、`Test`, `Distributed` を使用する | E-01 | ○ |
| C-02 | テスト名リストは `choosetests.jl` の TESTNAMES に約80項目定義されている | E-02 | ○ |
| C-03 | テストは独立モジュール（`Test<N>Main_<name>`）内で隔離実行される | E-03 | ○ |
| C-04 | `DEPOT_PATH`, `LOAD_PATH`, `ENV`, アクティブプロジェクトの復元検証を実施する | E-03 | ○ |
| C-05 | 並列実行は `Distributed` の `addprocs` でCPUスレッド数までワーカーを起動する | E-01, E-04 | ○ |
| C-06 | テスト実行オプションは `--check-bounds=yes --startup-file=no --depwarn=error` | E-04, E-06 | ○ |
| C-07 | BuildkiteTestJSONがテスト結果をJSON形式（5000件/ファイル上限）で出力する | E-05 | ○ |
| C-08 | `make test`, `make testall`, `make test-<name>`, `make test-revise-<name>` コマンドが利用可能 | E-06, E-07 | ○ |
| C-09 | GitHub Actionsでホワイトスペースチェック（Whitespace.yml）が実行される | E-08 | ○ |
| C-10 | GitHub Actionsでタイポチェック（Typos.yml）がPR時に実行される | E-09 | ○ |
| C-11 | ラベルチェック（LabelCheck.yml）で `needs *` ラベルのマージブロックを行う | E-10 | ○ |
| C-12 | CITATION.cffのバリデーション（cffconvert.yml）が実行される | E-11 | ○ |
| C-13 | Codecovはproject/patchステータスともに `off` に設定されている | E-12 | ○ |
| C-14 | 明示的なカバレッジ数値目標は設定されていない | E-12, E-13 | ○ |
| C-15 | テスト追加はCodecovでの未テスト箇所確認を推奨している | E-13 | ○ |
| C-16 | doctestは `make -C doc doctest=true` で実行可能 | E-14, E-19 | ○ |
| C-17 | `Test` stdlibが `@test`, `@testset`, `@test_throws` 等のマクロを提供する | E-15 | ○ |
| C-18 | Clang Static Analyzerがtest/clangsa/で使用されている | E-16 | ○ |
| C-19 | LLVM litテストフレームワークがtest/llvmpasses/で使用されている | E-17 | ○ |
| C-20 | 埋め込みテストがtest/embedding/で実施される | E-18 | ○ |
| C-21 | Revise.jlによるホットリロードテスト（`make test-revise-*`）がサポートされている | E-01, E-06, E-19 | ○ |
| C-22 | `LinearAlgebra` と `Pkg` テストは時間がかかるため先頭に移動される | E-01 | ○ |
| C-23 | `ccall`, `precompile`, `SharedArrays`, `threads`, `Distributed`, `gc`, `stress` はNode 1専用 | E-01 | ○ |
| C-24 | ネットワーク依存テストはネットワーク不可時にスキップされる | E-02 | ○ |
| C-25 | テスト実行時にグローバルRNGシードが設定され失敗時に表示される | E-01 | ○ |
| C-26 | `JULIA_TEST_MAXRSS_MB` 環境変数でワーカーのメモリ制限が可能 | E-01 | ○ |
| C-27 | 長時間テスト（45分以上）に対して15分間隔でステータスメッセージを出力する | E-01 | ○ |
| C-28 | ARM環境ではProfileテストがスキップされる | E-02 | ○ |
| C-29 | Valgrind環境ではroundingテストがスキップされる | E-02 | ○ |
| C-30 | rr（Record & Replay）デバッガ下でのテスト実行がサポートされている | E-01, E-04 | ○ |
| C-31 | テスト用ヘルパーモジュール群が `test/testhelpers/` に配置されている | E-21 | ○ |
| C-32 | テスト用ダミーパッケージが `test/depot/packages/` に配置されている | E-22 | ○ |
| C-33 | `@test_broken` マクロにより既知の不具合をマークし修正検出ができる | E-15 | ○ |
| C-34 | BuildkiteがメインCIシステムとして使用されている | **根拠不足** | △ |
| C-35 | Buildbotが現在も利用されている | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **Buildkite CI設定ファイル**: リポジトリ内に `.buildkite/` ディレクトリやBuildkite固有の設定ファイルが見つからなかった。`BuildkiteTestJSON` モジュールの存在と環境変数参照（`BUILDKITE_GROUP_LABEL`, `BUILDKITE_LABEL`）からBuildkiteの使用は推測されるが、CI設定自体は外部管理されている可能性がある。
  - 候補：外部リポジトリ / Buildkite Web UI設定 / 別のCI管理リポジトリ
- **Buildbotの現在の運用状況**: `CONTRIBUTING.md` に buildbot の参照があるが、現在のCI運用においてBuildkiteとの関係・移行状況は不明。
  - 候補：廃止済み / 部分的に併用 / 特定プラットフォーム専用

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テストフレームワーク・ツールの記述 - ソースコードから直接確認可能
- **0（低リスク）**: テスト実行コマンド体系 - Makefileから直接確認可能
- **0（低リスク）**: GitHub Actionsワークフローの記述 - YAMLファイルから直接確認可能
- **1（中リスク）**: BuildkiteのメインCI位置づけ - コード内の参照から推測されるが、設定ファイルが外部管理
- **1（中リスク）**: カバレッジ方針の記述 - Codecov設定は確認済みだが、組織的なカバレッジ目標は不明
- **0（低リスク）**: テスト並列実行の仕組み - `runtests.jl` のコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] BuildkiteのCI設定が外部管理されているか確認し、メインCIの記述が正確か検証する
- [ ] Buildbotの現在の運用状況を確認し、記述を更新する必要があるか判断する
- [ ] カバレッジに関する組織的な方針・目標が別途存在しないか確認する
- [ ] テストレベルの分類（単体/結合/システム/受入）がプロジェクトの実態と一致しているか確認する
- [ ] マルチプラットフォームテスト環境の記述が最新のCI構成と一致しているか確認する
