# テスト方針書

## 概要

本ドキュメントは、Julia言語（JuliaLang/julia）プロジェクトにおけるテスト方針を定義する。Juliaは高性能な動的プログラミング言語であり、コアランタイム（C/C++）、標準ライブラリ（Julia）、コンパイラ（Julia）、およびLLVMコード生成パイプラインから構成される。本方針書では、各コンポーネントに対するテスト戦略、テスト環境、ツール、CI/CDパイプラインとの連携について記述する。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | Base/stdlib/Compilerの各機能・モジュール単位での正当性検証。`test/` ディレクトリ配下の約80個以上のテストファイルで、数値演算、文字列処理、配列操作、型システム、パーサー、GCなど個別機能を検証する。 | コア開発者、コントリビュータ |
| 結合テスト | 複数モジュール間の連携動作検証。stdlib間の依存関係テスト（`stdlib_dependencies`）、プリコンパイルテスト（`precompile`）、ローディングテスト（`loading`）などが該当する。 | コア開発者 |
| システムテスト | ランタイム全体の動作検証。C/C++レベルの埋め込みテスト（`test/embedding/`）、GC拡張テスト（`test/gcext/`）、LLVMパステスト（`test/llvmpasses/`）、トリミングテスト（`test/trimming/`）を含む。 | コア開発者、CIシステム |
| 受入テスト | リリース候補の品質保証。`make release-candidate` で全テスト実行とドキュメントのdoctest・linkcheckを統合的に実施する。 | リリースマネージャ |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | Juliaの言語機能（数値演算、文字列、配列、型推論、マルチスレッド等）の正当性検証。`test/` 配下の各 `.jl` ファイルで `@test`, `@testset`, `@test_throws` マクロを用いて記述される。 | コミット時、PR作成時、CI実行時 |
| 性能テスト | ストレステスト（`test/stress.jl`）による負荷検証。LLVMパイプラインの最適化テスト（`test/llvmpasses/pipeline-o2.jl` 等）によるコード生成品質の検証。 | CI実行時、リリース前 |
| 静的解析テスト | Clang Static Analyzer（`test/clangsa/`）によるC/C++ランタイムコードのGCルート解析、暗黙的アトミクス検出。LLVM lit テストフレームワークによるIRレベルの検証。 | ソースコード変更時（`make -C src analyze-<filename>`） |
| ドキュメントテスト | jldoctestブロックの自動検証。`make -C doc doctest=true` で実行される。Documenter.jlによるドキュメントビルドの一環として実施。 | ドキュメント変更時、リリース前 |
| ホワイトスペース・タイポチェック | `contrib/check-whitespace.jl` によるホワイトスペース検証、typosツールによるスペルチェック。 | PR作成時（GitHub Actions） |
| 埋め込みテスト | JuliaをC/C++プログラムに埋め込んだ際の動作検証（`test/embedding/`）。 | CI実行時 |
| マルチスレッドテスト | スレッドの実行テスト（`test/threads.jl`, `test/threads_exec.jl`）。マルチスレッド環境でのデータ競合やアトミクス操作の検証。 | CI実行時 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発者による個別テスト実行 | `make test-<name>` または `make test-revise-<name>` で個別テスト実行。Juliaバイナリ（`usr/bin/julia` またはjuliaup版）を使用。`--check-bounds=yes --startup-file=no --depwarn=error` オプションで実行。 |
| Buildkite CI | メインCI環境。全テストの並列実行とテスト結果のJSON出力。 | 複数ワーカープロセスによる並列テスト実行。`BuildkiteTestJSON` モジュールによるテスト結果のJSON形式出力（5000件/ファイル上限）。メモリ制限（`JULIA_TEST_MAXRSS_MB`）によるワーカー再起動。 |
| GitHub Actions | 補助的なCI環境。ホワイトスペースチェック、タイポチェック、ラベルチェック、CITATIONバリデーション。 | ubuntu-latest ランナー上で実行。Julia 1.11.6 を使用（ホワイトスペースチェック用）。 |
| マルチプラットフォーム | クロスプラットフォーム検証 | Linux（x86_64, aarch64）、macOS、Windows。ARM環境ではProfileテストをスキップ。Valgrind環境ではroundingテストをスキップ。`rr`（Record & Replay）デバッガ下での実行にも対応。 |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| Julia `Test` stdlib | 標準テストフレームワーク。`@test`, `@testset`, `@test_throws`, `@test_broken`, `@test_skip`, `@test_warn`, `@test_nowarn`, `@test_logs`, `@test_deprecated`, `@inferred` マクロを提供。 | Julia本体と同梱 |
| `Distributed` stdlib | テストの並列実行基盤。`addprocs` による複数ワーカープロセスの起動とテスト分散実行。 | Julia本体と同梱 |
| `Revise.jl` | ソースコード変更のホットリロード。システムイメージの再ビルドなしにBase/stdlibの変更をテストに反映。`make test-revise-<name>` で利用。 | 外部パッケージ |
| LLVM `lit` (LLVM Integrated Tester) | LLVMパスおよびClang静的解析のテスト実行。`test/llvmpasses/` および `test/clangsa/` のテスト駆動。 | LLVMビルドに付属 |
| Clang Static Analyzer | C/C++ランタイムコード（`src/`）のGCルート解析（`clang-sagc`）、一般的な静的解析（`clang-sa`）、コーディング規約チェック（`clang-tidy`）。 | LLVMビルドに付属 |
| Codecov | コードカバレッジ計測・可視化サービス。ただし現在はproject/patchステータスともに `off` に設定。 | 外部サービス |
| `typos` | スペルチェックツール。PRで新たに追加されたタイポを差分検出。 | 最新リリース版を動的取得 |
| `BuildkiteTestJSON` | テスト結果をBuildkite Test Analytics互換のJSON形式に変換。テスト結果の可視化・分析に使用。 | プロジェクト内蔵（`test/buildkitetestjson.jl`） |
| `Documenter.jl` | ドキュメント内のjldoctestブロックの検証。 | 外部パッケージ |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 明示的な数値目標は設定されていない。Codecov（`.codecov.yml`）でproject/patchステータスが `off` に設定されており、カバレッジゲートとしてのブロックは行わない方針。 |
| 分岐カバレッジ | 明示的な数値目標は設定されていない。 |

注記: プロジェクトのドキュメント（`doc/src/devdocs/contributing/tests.md`）では「There are never enough tests」として継続的なテスト追加を推奨しており、Codecovでの未テスト箇所（赤色ハイライト）の確認とテスト追加をコントリビュータに促している。数値目標よりもカバレッジの継続的改善を重視するアプローチを取っている。

## テストデータ

テストデータの管理方針は以下の通りである。

- **テスト内インライン定義**: 大部分のテストでは、テストデータをテストファイル内にインラインで定義する。乱数シード（`--seed=SEED` オプション）による再現性を確保しており、グローバルRNGをUInt128シードで初期化する。
- **テスト用パッケージ**: `test/depot/packages/` にテスト用のダミーパッケージ（Foo, Baz等）を配置し、パッケージロード・プリコンパイルのテストに使用する。
- **リロケーションテスト**: `test/RelocationTestPkg1` - `test/RelocationTestPkg4` でデポの再配置テスト用パッケージを管理する。
- **テストヘルパー**: `test/testhelpers/` ディレクトリにテスト用のユーティリティモジュール（`Furlongs.jl`, `OffsetDenseArrays.jl`, `withlocales.jl` 等）を配置する。
- **C/C++テストライブラリ**: `libccalltest`, `libllvmcalltest` 等のテスト用共有ライブラリをビルドプロセスの一環として生成する。
- **環境整合性チェック**: テスト実行後に`DEPOT_PATH`, `LOAD_PATH`, `ENV`, アクティブプロジェクトが元の状態に復元されていることを検証する（`testdefs.jl`）。

## 不具合管理

不具合の管理方法は以下の通りである。

- **GitHub Issues**: すべての不具合はGitHub Issues（https://github.com/JuliaLang/julia/issues）で管理する。
- **ラベル管理**: `needs tests`, `needs docs`, `needs compat annotation`, `needs more info`, `needs nanosoldier run`, `needs pkgeval` 等のラベルでPRの状態を管理する。これらの`needs *` ラベルが付いている間はマージをブロックする（GitHub Actionsの `LabelCheck.yml`）。
- **テスト失敗時の動作**: テスト失敗時にはワーカープロセスを再起動して後続テストに影響を与えない仕組みを持つ。`--exit-on-error` オプションで最初の失敗で全テスト停止も可能。`JULIA_TEST_FAILFAST=1` 環境変数で個別テスト内のfail-fast動作を制御する。
- **`@test_broken` マクロ**: 既知の不具合に対して `@test_broken` マクロを使用し、修正されたら自動的に検出（`test_unbroken`）する仕組みを持つ。
- **rr（Record & Replay）**: Linux環境での再現困難な不具合に対して、`JULIA_RR` 環境変数でrrデバッガ下でのテスト実行をサポートする。

## CI/CD連携

Juliaプロジェクトでは複数のCI/CDシステムを併用してテストを自動化している。

### Buildkite（メインCI）

- **テスト実行**: `test/runtests.jl` を起点に全テストを並列実行する。`Distributed` stdlibを利用して `Sys.EFFECTIVE_CPU_THREADS` 数までワーカーを起動する。
- **テスト結果出力**: `BuildkiteTestJSON` モジュールにより、テスト結果をBuildkite Test Analytics互換のJSON形式で出力する。1ファイルあたり最大5000件のテスト結果を含む。
- **メモリ管理**: `JULIA_TEST_MAXRSS_MB` 環境変数によりワーカーの最大RSS（Resident Set Size）を制限し、超過時にワーカーを再起動する。
- **長時間テスト検出**: 45分以上実行中のテストに対して15分間隔で状態メッセージを出力する（`JULIA_TEST_LONGRUNNING_DELAY`, `JULIA_TEST_LONGRUNNING_INTERVAL` で調整可能）。

### GitHub Actions（補助CI）

以下のワークフローがPR/pushイベントに対して実行される。

| ワークフロー | トリガー | 内容 |
| --- | --- | --- |
| `Whitespace.yml` | push(master), PR | `contrib/check-whitespace.jl` によるホワイトスペースチェック |
| `Typos.yml` | PR | `typos` ツールによる新規タイポの差分検出 |
| `LabelCheck.yml` | PR(labeled/unlabeled/opened/reopened/edited/synchronize) | `needs *` / `DO NOT MERGE` ラベルのブロック |
| `cffconvert.yml` | push(master/release-*), PR | `CITATION.cff` のバリデーション |
| `backport-label-audit.yml` | PR | バックポートラベルの監査 |

### テスト実行コマンド体系

| コマンド | 説明 |
| --- | --- |
| `make test` | デフォルトテストの実行 |
| `make testall` | 全テスト（stdlib含む）の実行 |
| `make testall1` | シングルスレッドでの全テスト実行 |
| `make test-<name>` | 個別テストの実行（例: `make test-core`） |
| `make test-revise-<name>` | Revise.jlを使用した個別テスト実行（再ビルド不要） |
| `make -C doc doctest=true` | ドキュメントのdoctest実行 |
| `make -C doc doctest=true revise=true` | Revise.jlを使用したdoctest実行 |
| `make -C src analyze-<filename>` | C/C++ソースの静的解析 |

### テスト並列実行の仕組み

テストの並列実行は以下の順序で制御される。

1. **優先実行**: `LinearAlgebra` および `Pkg` テストは時間がかかるため、テストキューの先頭に移動される。
2. **Node 1専用テスト**: `ccall`, `precompile`, `SharedArrays`, `threads`, `Distributed`, `gc`, `stress` テストはNode 1（マスタープロセス）でのみ実行される。
3. **ネットワーク依存テスト**: `Sockets`, `Downloads`, `LibCURL`, `LibGit2`, `Pkg` 等はネットワーク接続が利用可能な場合のみ実行される。
4. **テストグループ展開**: stdlib およびトップレベルパッケージ（`Compiler`, `JuliaSyntax`, `JuliaLowering`）は `testgroups` ファイルに基づいてサブテストに展開される。

## 備考

- **再現性**: テスト実行時にグローバルRNGシードが設定され、失敗時にシード値が表示される。`--seed=SEED` オプションで同じシードを指定して再実行が可能。
- **テスト隔離**: 各テストはデフォルトで独立したモジュール内（`Test<N>Main_<name>`）で実行され、テスト間の状態汚染を防ぐ。`DEPOT_PATH`, `LOAD_PATH`, `ENV`, アクティブプロジェクトの変更が検出された場合はエラーとなる。
- **Buildbot**: 旧来のビルドボット設定が https://github.com/staticfloat/julia-buildbot で管理されている。
- **テストオプション環境変数**:
  - `JULIA_TEST_FAILFAST`: テスト内fail-fast動作
  - `JULIA_TEST_USE_MULTIPLE_WORKERS`: 強制的にマルチワーカーを使用
  - `JULIA_TEST_NETWORKING_AVAILABLE`: ネットワーク可用性の強制設定
  - `JULIA_TEST_MAXRSS_MB`: ワーカーの最大メモリ制限
  - `JULIA_TEST_EXEFLAGS`: テスト実行時のJulia実行フラグ上書き
  - `JULIA_TEST_EXENAME`: テスト実行時のJulia実行ファイル上書き
  - `JULIA_TEST_CHECK_MUTATED_ENV`: ENV変更検出の有効/無効
  - `JULIA_RR`: rrデバッガのパス指定
