# ER図

## 概要

本プロジェクト（Julia言語）はリレーショナルデータベースを使用していないため、従来のER図は該当しない。
以下では、内部データストア構造体間の関連をER図形式で表現する。

## terminfo データストア関連図

```mermaid
erDiagram
    TermInfoRaw {
        Vector_String names "端末名一覧"
        BitVector flags "フラグ値リスト"
        Vector_Int numbers "数値能力リスト"
        Vector_String_Nothing strings "文字列能力リスト"
        Dict_or_Nothing extended "拡張情報セクション"
    }

    TermInfo {
        Vector_String names "端末名一覧"
        Dict_Symbol_Bool flags "フラグ能力"
        Dict_Symbol_Int numbers "数値能力"
        Dict_Symbol_String strings "文字列能力"
        Set_Symbol_or_Nothing extensions "拡張能力名"
        Dict_Symbol_Symbol aliases "エイリアスマッピング"
    }

    TermInfoFile {
        String path "ファイルパス"
        Binary content "terminfo バイナリデータ"
    }

    TermInfoFile ||--|| TermInfoRaw : "read/parse"
    TermInfoRaw ||--|| TermInfo : "construct"
```

## パッケージ管理データストア関連図

```mermaid
erDiagram
    TOMLFile {
        String path "ファイルパス"
        String content "TOML テキストデータ"
    }

    CachedTOMLDict {
        String path "TOMLファイルパス"
        UInt64 inode "inode番号"
        Float64 mtime "最終変更時刻"
        Int64 size "ファイルサイズ"
        UInt32 hash "内容ハッシュ"
        Dict_String_Any d "解析済みTOMLデータ"
    }

    TOMLCache {
        Dict_String_CachedTOMLDict d "パス別キャッシュ"
    }

    PkgLoadSpec {
        String name "パッケージ名"
        UUID uuid "一意識別子"
        String path "パッケージパス"
    }

    LoadingCache {
        Any fields "ローディングキャッシュデータ"
    }

    PkgOrigin {
        Any fields "パッケージ起源情報"
    }

    CacheFlags {
        Any fields "キャッシュフラグ"
    }

    CacheHeaderIncludes {
        Any fields "キャッシュヘッダ情報"
    }

    TOMLFile ||--|| CachedTOMLDict : "parse/cache"
    TOMLCache ||--|{ CachedTOMLDict : "manages"
    LoadingCache ||--o| TOMLCache : "uses"
    PkgLoadSpec ||--o| PkgOrigin : "tracks origin"
    PkgLoadSpec ||--o| CacheFlags : "cache settings"
    CacheHeaderIncludes ||--o| CacheFlags : "includes flags"
```

## 補足

- 上記のER図は、RDBのテーブル間リレーションではなく、Julia構造体間のデータフローおよび関連性を表現したものである。
- 実線の矢印はデータ変換・構築の関係を示し、破線はオプショナルな参照を示す。
- TermInfo系の構造体はファイルベースのterminfo データベースからの読み込みパイプラインを構成する。
- パッケージ管理系の構造体はTOMLファイルの読み込み・キャッシュ・パッケージ解決のパイプラインを構成する。
