# データベース設計書

## 概要

本ドキュメントは、Julia言語（julia-master）プロジェクトにおけるデータベース設計について記載する。

Julia言語プロジェクトはプログラミング言語のコンパイラおよび標準ライブラリの実装であり、アプリケーションレベルのリレーショナルデータベース（RDB）を使用していない。すなわち、SQLデータベーススキーマ、マイグレーションファイル、ORMモデル定義などは存在しない。

ただし、本プロジェクトには以下のようなデータの永続化・参照機構が内部的に存在する。これらは「データベース」とは異なるが、構造化データの格納・検索を行う仕組みとして本ドキュメントに記載する。

1. **terminfo データベース** -- 端末能力情報を格納するバイナリ形式のファイルベースデータストア
2. **パッケージレジストリ（TOML形式）** -- パッケージメタデータを管理するTOMLファイル群
3. **プリコンパイルキャッシュ** -- コンパイル済みモジュールのシリアライズされたバイナリキャッシュ

## テーブル一覧

本プロジェクトにはRDBテーブルは存在しない。代替として、内部データストア構造を以下に示す。

| データストア名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| TermInfoRaw | 端末能力（生データ） | terminfo バイナリファイルから読み込まれた端末の能力情報（未加工） |
| TermInfo | 端末能力（解析済み） | TermInfoRaw を解析し、名前付きの能力としてマッピングした構造体 |
| PkgLoadSpec | パッケージ読み込み仕様 | パッケージの名前、UUID、パスなどの読み込みに必要な情報 |
| CachedTOMLDict | TOMLキャッシュ | TOMLファイルの解析結果をキャッシュするミュータブル構造体 |
| TOMLCache | TOMLキャッシュ管理 | TOMLファイルの解析結果をまとめて管理するキャッシュ構造体 |
| LoadingCache | ローディングキャッシュ | パッケージ読み込み時のキャッシュ情報を管理する構造体 |
| CacheHeaderIncludes | キャッシュヘッダ | プリコンパイルキャッシュファイルのヘッダ情報を管理する構造体 |
| CacheFlags | キャッシュフラグ | プリコンパイルキャッシュの設定フラグを保持する構造体 |
| PkgOrigin | パッケージ起源情報 | パッケージの出所・バージョン情報を保持する構造体 |

## 各テーブル定義

### 1. TermInfoRaw

terminfo バイナリファイルから直接読み込んだ端末能力の生データを保持する構造体。`term(5)` 仕様に準拠したバイナリ形式を解析した結果を格納する。ファイルベースのデータストア（`/usr/share/terminfo` 等）から読み込まれる。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| names | Vector{String} | NO | 端末が知られている名前の一覧 |
| flags | BitVector | NO | フラグ値のリスト（最大TERM_FLAGS個） |
| numbers | Vector{Int} | NO | 数値能力のリスト（最大TERM_NUMBERS個） |
| strings | Vector{Union{String, Nothing}} | NO | 文字列能力のリスト（未指定はnothing） |
| extended | Union{Nothing, Dict{Symbol, Union{Bool, Int, String, Nothing}}} | YES | 拡張情報セクション（存在する場合はDict、なければnothing） |

**定義元**: `base/terminfo.jl` (33-39行目)

### 2. TermInfo

TermInfoRaw を解析し、NCurses 6.3 の既知の端末能力定義に基づいて名前付きの能力としてマッピングした構造体。実行時の端末能力参照に使用される。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| names | Vector{String} | NO | 端末が知られている名前の一覧 |
| flags | Dict{Symbol, Bool} | NO | フラグ能力のディクショナリ |
| numbers | Dict{Symbol, Int} | NO | 数値能力のディクショナリ |
| strings | Dict{Symbol, String} | NO | 文字列能力のディクショナリ |
| extensions | Union{Nothing, Set{Symbol}} | YES | 拡張能力の変数名リスト |
| aliases | Dict{Symbol, Symbol} | NO | 能力名のエイリアスマッピング |

**定義元**: `base/terminfo.jl` (63-70行目)

### 3. PkgLoadSpec

パッケージの読み込みに必要な仕様情報を保持する構造体。パッケージの名前、UUID、ファイルパスなどの情報を含む。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | String | NO | パッケージ名 |
| uuid | UUID | NO | パッケージの一意識別子 |
| path | String | NO | パッケージのファイルパス |

**定義元**: `base/loading.jl` (259行目付近)

### 4. CachedTOMLDict

TOMLファイルの解析結果をキャッシュするミュータブル構造体。ファイルの変更検知とキャッシュの有効性管理を行う。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| path | String | NO | TOMLファイルのパス |
| inode | UInt64 | NO | ファイルのinode番号 |
| mtime | Float64 | NO | ファイルの最終変更時刻 |
| size | Int64 | NO | ファイルサイズ |
| hash | UInt32 | NO | ファイル内容のハッシュ |
| d | Dict{String, Any} | NO | 解析されたTOMLデータ |

**定義元**: `base/loading.jl` (208行目付近)

### 5. TOMLCache

複数のTOMLファイルのキャッシュを一括管理する構造体。パッケージシステム全体で使用される。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| d | Dict{String, CachedTOMLDict} | NO | パス別のキャッシュデータ |

**定義元**: `base/loading.jl` (287行目付近)

### 6. LoadingCache

パッケージ読み込み処理全体で使用されるキャッシュ情報を集約して管理する構造体。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| (内部フィールド) | - | - | パッケージ読み込み時の各種キャッシュデータを保持 |

**定義元**: `base/loading.jl` (264行目付近)

### 7. CacheHeaderIncludes

プリコンパイルキャッシュファイル（.ji ファイル）のヘッダに含まれるインクルード情報を管理するミュータブル構造体。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| (内部フィールド) | - | - | キャッシュファイルのヘッダ情報（依存関係、タイムスタンプ等） |

**定義元**: `base/loading.jl` (3627行目付近)

### 8. CacheFlags

プリコンパイルキャッシュの生成・検証に使用されるフラグ情報を保持する構造体。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| (内部フィールド) | - | - | キャッシュ生成時の各種フラグ（最適化レベル、デバッグ情報等） |

**定義元**: `base/loading.jl` (1845行目付近)

### 9. PkgOrigin

パッケージの起源情報（ソース、バージョンなど）を保持するミュータブル構造体。パッケージの追跡と管理に使用される。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| (内部フィールド) | - | - | パッケージの出所、バージョン、依存関係情報 |

**定義元**: `base/loading.jl` (2707行目付近)

## 備考

- 本プロジェクトはプログラミング言語（Julia）のコンパイラおよび標準ライブラリ実装であり、従来のアプリケーション開発で使用されるリレーショナルデータベースは一切使用していない。
- 上記の「データストア」は全てJuliaの構造体（`struct` / `mutable struct`）として定義されており、インメモリでのデータ保持、またはファイルシステム上のバイナリ/テキストファイルとしての永続化が行われる。
- terminfo データベースは、OS標準のterminfo（`/usr/share/terminfo` 等）およびJulia同梱の vendored terminfo を参照するファイルベースのデータストアである。
- パッケージ関連のデータはTOML形式のテキストファイルとして管理され、SQLデータベースは使用されていない。
- プリコンパイルキャッシュは `.ji` 拡張子のバイナリファイルとしてファイルシステムに保存される。
