# バッチ設計書 1-Whitespace

## 概要

本ドキュメントは、JuliaLangリポジトリにおけるWhitespace検出GitHub Actionsワークフローのバッチ設計書である。ソースコード内のホワイトスペースエラーを自動検出し、コード品質を維持するためのCI/CDパイプラインの一部として機能する。

### 本バッチの処理概要

このバッチは、GitHub上でのプッシュおよびプルリクエスト時に自動実行され、ソースコード内のホワイトスペースに関する問題を検出するCI/CDワークフローである。

**業務上の目的・背景**：Juliaプロジェクトでは多数のコントリビューターが参加しており、各開発者のエディタ設定やOS環境の違いにより、タブ文字の混入、行末空白、非UNIX改行コード、非改行スペース（U+00A0）などのホワイトスペースエラーが発生しやすい。これらの問題はコードレビューの負荷を増大させ、不要な差分を生むため、CIパイプラインで自動的に検出し、早期にフィードバックを返すことでコードベースの一貫性を維持する。

**バッチの実行タイミング**：masterブランチへのプッシュ時、およびプルリクエストの作成・更新時に自動実行される。イベント駆動型であり、定時実行ではない。

**主要な処理内容**：
1. リポジトリのチェックアウト（actions/checkout v6.0.2）
2. Julia 1.11.6のセットアップ（julia-actions/setup-julia v2.6.1）
3. `contrib/check-whitespace.jl`スクリプトの実行によるホワイトスペースエラーの検出

**前後の処理との関連**：本バッチは独立したCIジョブであり、他のCIジョブとの直接的な依存関係はない。ただし、No.16の`check-whitespace.jl`（メンテナンスバッチ）と同一のスクリプトを利用している。開発者はローカルで`make fix-whitespace`を実行して事前にエラーを修正することが推奨されている。

**影響範囲**：リポジトリ内の対象ファイル（*.c, *.cpp, *.h, *.jl, *.md, *.yml, *Makefileなど18種類のパターン）すべてが検査対象となる。検査結果はGitHub ActionsのCI結果としてPRに表示され、エラーがある場合はPRのマージがブロックされる。

## バッチ種別

コード品質チェック（静的解析）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | GitHub Actionsイベント（push to master, pull_request） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHubリポジトリ | JuliaLang/juliaリポジトリ上で動作すること |
| ランナー環境 | ubuntu-latestが利用可能であること |
| Julia環境 | julia-actions/setup-juliaでJulia 1.11.6がインストール可能であること |

### 実行可否判定

masterブランチへのpushイベント、またはpull_requestイベントが発生した場合に自動的に実行される。パスフィルタは設定されておらず、すべてのファイル変更に対して実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| N/A | - | - | - | ワークフロー入力パラメータなし。check-whitespace.jlはARGSが空の場合、`git ls-files`で対象ファイルを自動取得する |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| git ls-files | テキスト | Gitで管理されているファイル一覧（パターンフィルタ適用後） |
| ソースコードファイル | テキスト | 検査対象の各ソースファイル（*.c, *.jl, *.mdなど） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| stderr | テキスト | 検査結果サマリーおよびエラー詳細 |
| stdout | テキスト | GitHub Actions用のアノテーション（::warning形式） |
| 終了コード | 整数 | 0: エラーなし、1: エラーあり |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（ファイル出力なし、標準出力/標準エラーのみ） |
| 出力先 | GitHub Actions実行ログ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. リポジトリチェックアウト
   └─ actions/checkout@v6.0.2でリポジトリのソースコードを取得（persist-credentials: false）
2. Julia環境セットアップ
   └─ julia-actions/setup-julia@v2.6.1でJulia 1.11.6をインストール
3. ホワイトスペースチェック実行
   └─ contrib/check-whitespace.jlを実行
      ├─ git ls-filesで対象ファイル一覧を取得（18種類のパターン）
      ├─ 各ファイルに対して以下をチェック
      │   ├─ 非UNIX改行コード（\r）の検出
      │   ├─ 非改行スペース（\ua0）の検出
      │   ├─ タブ文字の検出（許可リスト外のファイル）
      │   ├─ 末尾改行なしの検出
      │   ├─ 行末空白の検出
      │   └─ ファイル末尾の空行の検出
      └─ 結果を出力し、エラーがあれば終了コード1で終了
```

### フローチャート

```mermaid
flowchart TD
    A[ワークフロー開始] --> B[リポジトリチェックアウト]
    B --> C[Julia 1.11.6セットアップ]
    C --> D[check-whitespace.jl実行]
    D --> E[git ls-filesでファイル一覧取得]
    E --> F[各ファイルに対してループ]
    F --> G{ホワイトスペースエラー検出?}
    G -->|エラーあり| H[エラーセットに追加]
    H --> F
    G -->|エラーなし| F
    F --> I{全ファイル処理完了?}
    I -->|No| F
    I -->|Yes| J{エラーセットが空?}
    J -->|空| K[exit 0 - 成功]
    J -->|空でない| L[エラー一覧出力 + GitHub Actionsアノテーション]
    L --> M[exit 1 - 失敗]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| exit 1 | ホワイトスペースエラー | 対象ファイルにホワイトスペース問題が検出された場合 | 開発者が`contrib/check-whitespace.jl --fix`でローカル修正するか、手動で修正する |
| timeout | タイムアウト | 2分以内に処理が完了しない場合 | GitHub Actionsワークフローにより自動中断。再実行で解決しない場合は対象ファイルの確認が必要 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

ワークフローが失敗した場合、GitHub Actionsの実行ログを確認し、検出されたホワイトスペースエラーの詳細を確認する。開発者はローカルで`contrib/check-whitespace.jl --fix`を実行して自動修正するか、`make fix-whitespace`を実行して修正後に再度プッシュする。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | リポジトリ内の全対象ファイル（数千ファイル） |
| 目標処理時間 | 2分以内（timeout-minutes: 2） |
| メモリ使用量上限 | GitHub Actionsランナーの標準上限 |

## 排他制御

同一PRに対して複数のワークフロー実行が並行する場合があるが、読み取り専用の検査であるため排他制御は不要。GitHub Actionsのconcurrencyグループは設定されていない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各ステップ開始時 | GitHub Actionsのステップログに自動記録 |
| 結果ログ | 検査完了時 | "Whitespace check found no issues." または "Whitespace check found N issues:" |
| エラーログ | エラー検出時 | ファイルパス、行番号、エラー種別（tab, trailing whitespace等） |
| アノテーション | エラー検出時 | GitHub Actions ::warning形式のアノテーション |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ワークフロー実行時間 | 2分 | GitHub Actions（自動タイムアウト） |
| ワークフロー失敗 | 1回 | GitHub PR Checksタブ |

## 備考

- permissionsは空（`{}`）に設定されており、最小権限の原則に従っている
- check-whitespace.jlはタブを許可するファイル（Makefile、Make.inc、src/support/*, src/flisp/*など）を個別に管理している
- `--fix`オプションを使用するとローカルでの自動修正が可能だが、CIでは検出のみを行う
- GitHub Actions環境（`GITHUB_ACTIONS=true`）ではアノテーション形式（`::warning`）でも出力される
