# バッチ設計書 10-release-candidate

## 概要

本ドキュメントは、JuliaプロジェクトにおけるMakefileのrelease-candidateターゲットのバッチ設計書である。リリース候補の準備を一括で行い、ライセンスヘッダーの追加、ドキュメント生成（HTML/PDF）、ドキュメントテスト実行、テストスイートの実行、およびリポジトリの整合性チェックを含む包括的なリリース準備バッチである。

### 本バッチの処理概要

このバッチは、Juliaのリリース候補を準備するためのMakefileターゲットであり、リリースに必要な一連の品質保証とドキュメント生成を一括処理する。

**業務上の目的・背景**：Juliaプロジェクトは定期的にリリース候補（Release Candidate、RC）を公開し、コミュニティによるテストを経てから正式リリースを行う。リリース候補の準備には、ライセンス情報の付与、ドキュメントの完全生成と検証、テストスイートの全実行、リポジトリ状態のクリーンネスチェックなど、多数の手順が必要である。これらを手動で個別に実行するとミスが発生しやすいため、release-candidateターゲットとして一括自動化している。

**バッチの実行タイミング**：リリース候補の準備時に手動で実行される。`make release-candidate`コマンドを開発者が明示的に実行する。

**主要な処理内容**：
1. `release`ターゲットの実行（ビルド全体）
2. `testall`ターゲットの実行（全テストスイート）
3. `contrib/add_license_to_files.jl`によるライセンスヘッダー追加
4. `doc/NEWS-update.jl`によるNEWS.mdのクロスリファレンス追加
5. `make -C doc html doctest=true linkcheck=true`によるHTMLドキュメント生成（doctest + linkcheck付き）
6. `make -C doc pdf`によるPDFドキュメント生成
7. Gitリポジトリのクリーンネスチェック（未コミット変更がないことを確認）
8. リリースチェックリストの表示（手動作業項目の案内）

**前後の処理との関連**：本バッチはrelease（ビルド）とtestall（テスト）ターゲットに依存している。No.17 add_license_to_files.jl、No.26 testall、No.23 docs（HTML生成）、No.24 docs（PDF生成）、No.25 doctestと関連する。本バッチ実行後、リリースチェックリストに従って手動作業（非推奨関数の削除、バージョン参照の更新など）を行う必要がある。

**影響範囲**：リポジトリ全体に影響を与える。ライセンスヘッダーの追加、ドキュメント生成によりファイルが変更される可能性がある。テストスイートの全実行によりビルド成果物の検証が行われる。

## バッチ種別

ビルド処理（リリース準備）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース準備時） |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動（make release-candidate） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド環境 | Juliaのビルドに必要な依存関係がすべてインストールされていること |
| Juliaバイナリ | JULIA_EXECUTABLEが利用可能であること |
| Gitリポジトリ | クリーンな状態（未コミット変更なし）であることが推奨される |
| ドキュメントツール | Documenter.jl等のドキュメント生成ツールが利用可能であること |

### 実行可否判定

手動で`make release-candidate`を実行した場合に起動される。前提ターゲット（release、testall）が正常に完了している必要がある。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| N/A | - | - | - | Makefileターゲットのため、明示的な入力パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースコード全体 | 各種 | リポジトリの全ソースコードファイル |
| テストスイート | Julia | test/ディレクトリのテストファイル |
| ドキュメントソース | Markdown/Julia | doc/ディレクトリのドキュメントファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ソースファイル | テキスト | ライセンスヘッダーが追加されたファイル |
| NEWS.md | Markdown | クロスリファレンスが追加されたNEWS.md |
| doc/_build/html/ | HTML | 生成されたHTMLドキュメント |
| doc/_build/pdf/ | PDF | 生成されたPDFドキュメント |
| stdout | テキスト | リリースチェックリスト（手動作業項目） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各種（ライセンスヘッダー追加対象ファイル、ドキュメント成果物） |
| 出力先 | リポジトリ内の各ファイル、doc/_build/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. releaseターゲット実行
   └─ Juliaのリリースビルド（最適化ビルド）
2. testallターゲット実行
   └─ 全テストスイートの実行（システムイメージ検証含む）
3. ライセンスヘッダー追加
   └─ contrib/add_license_to_files.jlの実行
4. NEWS.mdクロスリファレンス更新
   └─ doc/NEWS-update.jlの実行
5. HTMLドキュメント生成
   └─ make -C doc html doctest=true linkcheck=true
      ├─ Documenterを使用したHTML生成
      ├─ ドキュメント内のJuliaコード例（doctest）の検証
      └─ リンクの有効性チェック（linkcheck）
6. PDFドキュメント生成
   └─ make -C doc pdf
7. Gitリポジトリクリーンネスチェック
   ├─ git status --porcelainで未コミット変更を確認
   └─ 変更がある場合はエラーメッセージを出力して終了（exit 1）
8. リリースチェックリスト表示
   ├─ 1. base/deprecated.jlの非推奨関数削除
   └─ 2. ソースディレクトリ内のJuliaバージョン参照の更新（README.md等）
```

### フローチャート

```mermaid
flowchart TD
    A[make release-candidate] --> B[release ターゲット実行]
    B --> C[testall ターゲット実行]
    C --> D[ライセンスヘッダー追加]
    D --> E[NEWS.md クロスリファレンス更新]
    E --> F[HTML ドキュメント生成 doctest+linkcheck]
    F --> G[PDF ドキュメント生成]
    G --> H{git status --porcelain}
    H -->|変更あり| I[エラー: リポジトリが汚れている]
    I --> J[exit 1]
    H -->|変更なし| K[リリースチェックリスト表示]
    K --> L[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| exit 1 | ビルドエラー | releaseターゲットが失敗した場合 | ビルドエラーを修正して再実行 |
| exit 1 | テスト失敗 | testallターゲットでテストが失敗した場合 | 失敗したテストを修正して再実行 |
| exit 1 | ドキュメント生成エラー | HTMLまたはPDFドキュメントの生成に失敗した場合 | ドキュメントソースを修正 |
| exit 1 | doctest失敗 | ドキュメント内のコード例が期待通りに動作しない場合 | 該当するdoctestを修正 |
| exit 1 | linkcheck失敗 | ドキュメント内のリンクが無効な場合 | リンクを修正 |
| exit 1 | リポジトリ汚れ | git status --porcelainが空でない場合 | 変更をコミットして再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

各ステップが順次実行されるため、失敗した時点で停止する。失敗箇所を特定し、修正後に再度`make release-candidate`を実行する。ビルドキャッシュが有効な場合は、成功済みのステップはスキップされる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A（ファイル変更はgit checkoutで復元可能） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | リポジトリ全体（ビルド、テスト、ドキュメント生成） |
| 目標処理時間 | 数十分〜数時間（ビルドとテスト実行を含むため） |
| メモリ使用量上限 | ビルドマシンのリソースに依存 |

## 排他制御

ビルドプロセスは排他的に実行されるべきであり、同一ビルドディレクトリで並行実行しないこと。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ビルドログ | ビルド中 | Makeの標準出力 |
| テストログ | テスト実行中 | テスト結果の詳細 |
| ドキュメントログ | ドキュメント生成中 | Documenterの出力 |
| チェックリスト | 完了時 | リリースに必要な手動作業項目 |
| エラーログ | エラー発生時 | "Git repository dirty; Verify and commit changes..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行失敗 | 1回 | make実行のターミナル出力 |

## 備考

- release-candidateターゲットは`.PHONY`として宣言されており、常に実行される
- 依存ターゲットは`release`と`testall`の2つ
- ライセンスヘッダー追加（add_license_to_files.jl）はNo.17のメンテナンスバッチと同一スクリプト
- ドキュメント生成時にdoctest=trueとlinkcheck=trueが指定されるため、処理時間が大幅に増加する
- Gitクリーンネスチェックにより、ライセンス追加やドキュメント生成で変更が発生した場合は、先にコミットする必要がある
- リリースチェックリストには以下の手動作業が含まれる：
  1. base/deprecated.jlの非推奨関数の削除
  2. ソースディレクトリ内のJuliaバージョン参照の更新（README.md等）
- ネットワードロードテスト（test/netload/*.jl）の実行はコメントアウトされている
