# バッチ設計書 11-binary-dist

## 概要

本ドキュメントは、JuliaプロジェクトにおけるMakefileの `binary-dist` ターゲットのバッチ設計書である。このターゲットは、Juliaのバイナリ配布用tarball（またはプラットフォーム固有のインストーラ）を作成するためのビルドバッチ処理を定義する。

### 本バッチの処理概要

`binary-dist` は、ビルド済みのJuliaバイナリとその依存ライブラリを集約し、エンドユーザーが利用できる配布用アーカイブ（tarball）を生成するバッチ処理である。

**業務上の目的・背景**：Juliaの各リリースにおいて、ユーザーがダウンロードして即座に利用できるバイナリパッケージを提供する必要がある。ソースからビルドする手間をユーザーに求めず、各プラットフォーム向けに事前コンパイル済みのバイナリを配布するために本バッチが存在する。リリースプロセスの中核を担うバッチであり、公式ダウンロードページで提供されるバイナリの元となる。

**バッチの実行タイミング**：リリース候補作成時および正式リリース時に手動で実行される。通常はリリースマネージャーがタグ付きコミットに対して実行する。日次や定期実行ではなく、リリースイベント駆動で実行される。

**主要な処理内容**：
1. `distclean` による既存の配布物ファイルの削除（クリーンアップ）
2. OpenBLASの `OPENBLAS_DYNAMIC_ARCH=1` 設定の検証（x86環境の場合）
3. `prefix` および `DESTDIR` の設定が未指定であることの検証
4. `make install` の実行によるビルド成果物のインストールディレクトリへのコピー
5. LICENSE.mdのコピー
6. OS固有の処理（Linux: CA証明書コピー、Windows: 不要なLLVMバイナリ削除）
7. tarファイル（gzip圧縮）の作成

**前後の処理との関連**：本バッチの実行前に、Juliaの完全なビルド（`make release` または `make`）が完了している必要がある。後続処理として、`prepare_release.sh`（No.19）によるリリースバイナリの収集・署名・アップロード処理がある。また、Windows環境では `exe` ターゲット（Inno Setupによるインストーラ生成）、macOS環境では `app` ターゲット（DMG生成）が後続処理として存在する。

**影響範囲**：ビルドディレクトリ内に `julia-$(JULIA_COMMIT)` ディレクトリと `$(JULIA_BINARYDIST_FILENAME).tar.gz` ファイルが生成される。既存の配布物ファイルは `distclean` により削除される。

## バッチ種別

ビルド成果物パッケージング / 配布物生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動（`make binary-dist`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Juliaビルド完了 | `make release` または `make` による完全なビルドが完了していること |
| OpenBLAS設定 | x86環境で `USE_SYSTEM_BLAS=0` の場合、`OPENBLAS_DYNAMIC_ARCH=1` でビルドされていること |
| prefix未設定 | `prefix` が `$(abspath julia-$(JULIA_COMMIT))` と等しいこと（デフォルト値） |
| DESTDIR未設定 | `DESTDIR` 環境変数が設定されていないこと |

### 実行可否判定

Makefile内の条件分岐により、以下の場合にビルドが中止される：
- x86環境で `OPENBLAS_DYNAMIC_ARCH` が1でない場合（エラーメッセージ表示後に `false` で失敗）
- `prefix` がデフォルト値と異なる場合（`$(error ...)` で即座に失敗）
- `DESTDIR` が設定されている場合（`$(error ...)` で即座に失敗）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| JULIA_COMMIT | 文字列 | Yes | gitコミットハッシュ | 配布物のディレクトリ名に使用されるコミット識別子 |
| JULIA_BINARYDIST_FILENAME | 文字列 | Yes | Make.incで定義 | 出力tarballのファイル名（拡張子なし） |
| OS | 文字列 | Yes | 自動検出 | ターゲットOS（Linux/WINNT/Darwin） |
| USE_SYSTEM_BLAS | 0/1 | No | 0 | システムBLASを使用するかどうか |
| OPENBLAS_DYNAMIC_ARCH | 0/1 | No | 0 | OpenBLASの動的アーキテクチャサポート |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ビルド成果物 | バイナリファイル群 | `make install` でインストールされるJuliaバイナリおよびライブラリ |
| LICENSE.md | Markdownファイル | MITライセンスファイル |
| cert.pem | PEMファイル | CA証明書バンドル（Linux環境のみ） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| `$(BUILDROOT)/$(JULIA_BINARYDIST_FILENAME).tar.gz` | gzip圧縮tarball | バイナリ配布用アーカイブ |
| `$(BUILDROOT)/julia-$(JULIA_COMMIT)/` | ディレクトリ | インストール先中間ディレクトリ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | `$(JULIA_BINARYDIST_FILENAME).tar.gz`（例: `julia-1.11.0-linux-x86_64.tar.gz`） |
| 出力先 | `$(BUILDROOT)/`（ビルドルートディレクトリ） |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. distclean（クリーンアップ）
   └─ 既存のtarball、exe、インストールディレクトリを削除
2. 前提条件チェック
   └─ OpenBLAS設定、prefix、DESTDIRの検証
3. make install
   └─ ビルド成果物をjulia-$(JULIA_COMMIT)ディレクトリにインストール
4. LICENSE.mdコピー
   └─ ライセンスファイルをインストールディレクトリにコピー
5. OS固有処理
   └─ Linux: CA証明書コピー / Windows: 不要ファイル削除
6. tarball作成
   └─ gzip圧縮tarballを生成
```

### フローチャート

```mermaid
flowchart TD
    A[binary-dist開始] --> B[distclean: 既存配布物削除]
    B --> C{USE_SYSTEM_BLAS=0 かつ x86?}
    C -->|Yes| D{OPENBLAS_DYNAMIC_ARCH=1?}
    C -->|No| F[prefix/DESTDIR検証]
    D -->|Yes| F
    D -->|No| E[エラー終了]
    F --> G{検証OK?}
    G -->|Yes| H[make install実行]
    G -->|No| E
    H --> I[LICENSE.mdコピー]
    I --> J{OS判定}
    J -->|Linux| K[CA証明書コピー]
    J -->|Windows| L[不要LLVMバイナリ削除]
    J -->|その他| M[tarball作成]
    K --> M
    L --> M
    M --> N[binary-dist完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。ファイルシステム操作のみである。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | ビルド設定エラー | OPENBLAS_DYNAMIC_ARCH!=1（x86環境） | OpenBLASを`OPENBLAS_DYNAMIC_ARCH=1`で再ビルド |
| N/A | 設定エラー | prefixがデフォルト値と異なる | prefix変数を未設定にしてから再実行 |
| N/A | 設定エラー | DESTDIRが設定されている | DESTDIR変数を未設定にしてから再実行 |
| N/A | ビルドエラー | make installが失敗 | ビルドログを確認し、ビルド環境の問題を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `distclean` を実行して中間生成物を削除する
2. エラーメッセージを確認し、前提条件を満たしているか確認する
3. 必要に応じてJulia本体を再ビルドする
4. `make binary-dist` を再実行する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | 失敗時は `distclean` で手動クリーンアップ |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のビルドにつき1つのtarball |
| 目標処理時間 | 数分〜10分程度（ビルド規模に依存） |
| メモリ使用量上限 | 特に制限なし（tarコマンドの使用量に依存） |

## 排他制御

同一ビルドディレクトリでの同時実行は不可。`distclean` が最初に実行されるため、並行実行した場合にファイルの競合が発生する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | tarball作成時 | `tar -zcvf` によるファイルリスト出力 |
| エラーログ | 前提条件不一致時 | OpenBLAS設定エラー、prefix/DESTDIRエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 終了コード != 0 | 実行者（手動実行のため） |
| 出力ファイルサイズ | 0バイト | 実行者 |

## 備考

- Windows環境では、本バッチの後に `exe` ターゲットを実行してInno Setupインストーラを生成できる
- macOS環境では、`app` ターゲットでDMGファイルを生成、`darwinframework` ターゲットでFrameworkを生成できる
- `USE_BINARYBUILDER_OPENBLAS=0` の場合、`USE_BINARYBUILDER_OBJCONV=0` が自動的に設定される（Julia issue #46579 への対応）
