# バッチ設計書 12-light-source-dist

## 概要

本ドキュメントは、JuliaプロジェクトにおけるMakefileの `light-source-dist` ターゲットのバッチ設計書である。このターゲットは、Juliaのソースコードと標準ライブラリのtarballのみを含む軽量ソース配布物を作成する。

### 本バッチの処理概要

`light-source-dist` は、Juliaのソースコード、gitトラッキング対象ファイル、標準ライブラリのソースtarball、およびビルド済みHTMLドキュメントをまとめて、軽量なソース配布用tarballを生成するバッチ処理である。

**業務上の目的・背景**：Juliaのリリース時に、ユーザーやパッケージメンテナがソースからビルドするためのソースtarballを提供する必要がある。`light-source-dist` は外部依存関係（deps/）を含まない軽量版であり、ネットワーク接続のある環境でのソースビルドを想定している。完全なソース配布物（`full-source-dist`、No.13）と比較してファイルサイズが小さく、配布が容易である。

**バッチの実行タイミング**：リリース時に手動で実行される。`prepare_release.sh`（No.19）から呼び出される場合もある。リリースプロセスのステップ8として、GitHubリリースページにアタッチするtarballの作成に使用される。

**主要な処理内容**：
1. gitバージョン情報ファイル（`base/version_git.jl`）の生成
2. 配布対象ファイルリストの作成（`light-source-dist.tmp`）
3. 標準ライブラリソースtarballのダウンロード（`stdlib getall`）
4. gitトラッキング対象ファイルの収集（`git ls-files`）
5. ビルド済みHTMLドキュメントの収集
6. プレフィックス付きgzip圧縮tarballの生成

**前後の処理との関連**：前提として、HTMLドキュメントのビルド（`$(BUILDROOT)/doc/_build/html/en/index.html`）が完了している必要がある。`full-source-dist`（No.13）は本バッチの出力ファイルリスト（`light-source-dist.tmp`）をベースとして使用する。`prepare_release.sh`（No.19）から後続処理として呼び出される。

**影響範囲**：ビルドディレクトリに `light-source-dist.tmp`、`light-source-dist.tmp1` の一時ファイルと、最終成果物として `julia-$(JULIA_VERSION)_$(JULIA_COMMIT).tar.gz` が生成される。一時的に `julia-${JULIA_COMMIT}` というシンボリックリンクが作成・削除される。

## バッチ種別

ビルド成果物パッケージング / ソース配布物生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動（`make light-source-dist`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| HTMLドキュメントビルド済み | `$(BUILDROOT)/doc/_build/html/en/index.html` が存在すること |
| in-treeビルド | ビルドディレクトリがソースディレクトリと同一であること（out-of-treeビルド非対応） |
| gitリポジトリ | `git ls-files` が実行可能なgitリポジトリであること |
| ネットワーク接続 | 標準ライブラリのソースtarballダウンロードにネットワーク接続が必要 |

### 実行可否判定

- `$(BUILDROOT)` と `$(JULIAHOME)` が異なる場合（out-of-treeビルド）、`$(error ...)` で即座にエラー終了する

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| JULIA_VERSION | 文字列 | Yes | VERSIONファイルから取得 | Juliaのバージョン番号 |
| JULIA_COMMIT | 文字列 | Yes | gitコミットハッシュ | コミット識別子 |
| BUILDROOT | パス | Yes | カレントディレクトリ | ビルドルートディレクトリ |
| JULIAHOME | パス | Yes | ソースディレクトリ | Juliaソースディレクトリ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| gitリポジトリ | ファイル群 | `git ls-files` で取得される全トラッキング対象ファイル |
| stdlib/srccache/*.tar.gz | tarball群 | 標準ライブラリのソースtarball |
| stdlib/*/StdlibArtifacts.toml | TOMLファイル群 | 標準ライブラリのアーティファクト定義 |
| doc/_build/html/ | HTMLファイル群 | ビルド済みドキュメント |
| base/version_git.jl | Juliaファイル | gitバージョン情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| `julia-$(JULIA_VERSION)_$(JULIA_COMMIT).tar.gz` | gzip圧縮tarball | 軽量ソース配布用アーカイブ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | `julia-$(JULIA_VERSION)_$(JULIA_COMMIT).tar.gz` |
| 出力先 | `$(BUILDROOT)/`（ビルドルートディレクトリ） |
| 文字コード | バイナリ（tarball内のソースファイルはUTF-8） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. version_git.jl生成
   └─ base/version_git.jlにgitバージョン情報を書き込み
2. ファイルリスト初期化
   └─ light-source-dist.tmpにbase/version_git.jlを記載
3. 標準ライブラリダウンロード
   └─ make -C stdlib getall DEPS_GIT=0 USE_BINARYBUILDER=0
4. stdlibファイルリスト追加
   └─ stdlib/srccache/*.tar.gzとstdlib/*/StdlibArtifacts.tomlを追加
5. gitファイルリスト追加
   └─ git ls-filesの出力をlight-source-dist.tmpに追加
6. ドキュメントファイルリスト追加
   └─ doc/_build/html以下の全ファイルを追加
7. プレフィックス付与
   └─ 全パスにjulia-${JULIA_COMMIT}/プレフィックスを付与
8. シンボリックリンク作成
   └─ カレントディレクトリにjulia-${JULIA_COMMIT}シンボリックリンクを作成
9. tarball生成
   └─ tar -cz --no-recursion でgzip圧縮tarballを作成
10. シンボリックリンク削除
    └─ 一時シンボリックリンクを削除
```

### フローチャート

```mermaid
flowchart TD
    A[light-source-dist開始] --> B{in-treeビルド?}
    B -->|No| C[エラー終了]
    B -->|Yes| D[version_git.jl生成]
    D --> E[ファイルリスト初期化]
    E --> F[stdlib tarballダウンロード]
    F --> G[stdlibファイルをリストに追加]
    G --> H[git ls-filesをリストに追加]
    H --> I[ドキュメントファイルをリストに追加]
    I --> J[パスにプレフィックス付与]
    J --> K[シンボリックリンク作成]
    K --> L[tarball生成]
    L --> M[シンボリックリンク削除]
    M --> N[light-source-dist完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。ファイルシステム操作のみである。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | 設定エラー | out-of-treeビルドの場合 | in-treeビルド環境で実行する |
| N/A | 前提条件エラー | HTMLドキュメント未ビルド | `make docs` を事前に実行する |
| N/A | ネットワークエラー | stdlib tarballダウンロード失敗 | ネットワーク接続を確認して再実行 |
| N/A | gitエラー | git ls-files失敗 | gitリポジトリ内で実行されているか確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 一時ファイル（`light-source-dist.tmp`、`light-source-dist.tmp1`）を手動削除する
2. 一時シンボリックリンク（`julia-${JULIA_COMMIT}`）が残っている場合は削除する
3. エラー原因を修正して再実行する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | 失敗時は一時ファイルを手動削除 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行につき1つのtarball |
| 目標処理時間 | 数分程度（ネットワーク速度とリポジトリサイズに依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一ビルドディレクトリでの同時実行は不可。一時ファイル（`light-source-dist.tmp`）およびシンボリックリンクの競合が発生する。`full-source-dist`（No.13）との同時実行も不可（`light-source-dist.tmp` を共有するため）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | out-of-treeビルド時 | `make light-source-dist does not work in out-of-tree builds` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 終了コード != 0 | 実行者（手動実行のため） |
| 出力ファイルサイズ | 0バイト | 実行者 |

## 備考

- `light-source-dist.tmp` は中間ファイルであり、`full-source-dist`（No.13）でも再利用される
- `--no-recursion` オプションにより、tarはファイルリストに明示的に記載されたファイルのみをアーカイブする
- `DEPS_GIT=0` と `USE_BINARYBUILDER=0` により、標準ライブラリのソースをtarball形式でダウンロードする
- `make clean` により `light-source-dist.tmp` および `light-source-dist.tmp1` は削除される
