# バッチ設計書 13-full-source-dist

## 概要

本ドキュメントは、JuliaプロジェクトにおけるMakefileの `full-source-dist` ターゲットのバッチ設計書である。このターゲットは、Juliaソースコードと全ての外部依存関係を含む完全なソース配布物のtarballを作成する。

### 本バッチの処理概要

`full-source-dist` は、`light-source-dist`（No.12）で収集されるJuliaソースコード・標準ライブラリに加えて、`deps/srccache/` 内の全ての外部依存関係のソースtarballを含む完全なソース配布用tarballを生成するバッチ処理である。

**業務上の目的・背景**：Juliaのリリース時に、ネットワーク接続なしでソースからビルド可能な完全自己完結型のソースtarballを提供する必要がある。Linux ディストリビューションのパッケージメンテナや、エアギャップ環境でのビルドを行うユーザー向けに、全依存関係を含むソース配布物を提供するために本バッチが存在する。

**バッチの実行タイミング**：リリース時に手動で実行される。`prepare_release.sh`（No.19）から呼び出される場合もある。Makefileのリリース手順ステップ8として、GitHubリリースページにアタッチするtarballの作成に使用される。

**主要な処理内容**：
1. `light-source-dist.tmp` の準備（`light-source-dist.tmp` ターゲットへの依存）
2. 全外部依存関係のソースダウンロード（`make -C deps getall`）
3. `deps/srccache/` 内の全アーカイブファイルをファイルリストに追加
4. プレフィックス付きgzip圧縮tarballの生成

**前後の処理との関連**：`light-source-dist.tmp` ターゲット（No.12の一部）が前提処理として必要。HTMLドキュメントのビルドも間接的な前提条件となる。`prepare_release.sh`（No.19）から後続処理として呼び出される。

**影響範囲**：ビルドディレクトリに `full-source-dist.tmp`、`full-source-dist.tmp1` の一時ファイルと、最終成果物として `julia-$(JULIA_VERSION)_$(JULIA_COMMIT)-full.tar.gz` が生成される。`deps/srccache/` に外部依存関係のソースtarballがダウンロードされる。

## バッチ種別

ビルド成果物パッケージング / 完全ソース配布物生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動（`make full-source-dist`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| HTMLドキュメントビルド済み | `light-source-dist.tmp` の依存関係経由で必要 |
| in-treeビルド | `light-source-dist.tmp` の制約を継承 |
| gitリポジトリ | `light-source-dist.tmp` の制約を継承 |
| ネットワーク接続 | 外部依存関係および標準ライブラリのダウンロードに必要 |

### 実行可否判定

`light-source-dist.tmp` ターゲットの実行可否判定を継承する。out-of-treeビルドの場合はエラー終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| JULIA_VERSION | 文字列 | Yes | VERSIONファイルから取得 | Juliaのバージョン番号 |
| JULIA_COMMIT | 文字列 | Yes | gitコミットハッシュ | コミット識別子 |
| DEPS_GIT | 0/1 | No | 0（明示指定） | git cloneによる依存関係取得を無効化 |
| USE_BINARYBUILDER | 0/1 | No | 0（明示指定） | BinaryBuilderの使用を無効化 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| light-source-dist.tmp | テキストファイル | 軽量配布物のファイルリスト |
| deps/srccache/*.tar.gz | tarball群 | 外部依存関係のソースアーカイブ（gzip） |
| deps/srccache/*.tar.bz2 | tarball群 | 外部依存関係のソースアーカイブ（bzip2） |
| deps/srccache/*.tar.xz | tarball群 | 外部依存関係のソースアーカイブ（xz） |
| deps/srccache/*.tgz | tarball群 | 外部依存関係のソースアーカイブ（tgz） |
| deps/srccache/*.zip | zipファイル群 | 外部依存関係のソースアーカイブ（zip） |
| deps/srccache/*.pem | PEMファイル群 | 証明書ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| `julia-$(JULIA_VERSION)_$(JULIA_COMMIT)-full.tar.gz` | gzip圧縮tarball | 完全ソース配布用アーカイブ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | `julia-$(JULIA_VERSION)_$(JULIA_COMMIT)-full.tar.gz` |
| 出力先 | `$(BUILDROOT)/`（ビルドルートディレクトリ） |
| 文字コード | バイナリ（tarball内のソースファイルはUTF-8） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. light-source-dist.tmp準備
   └─ light-source-dist.tmpターゲットの実行（No.12と共通）
2. 外部依存関係ダウンロード
   └─ make -C deps getall DEPS_GIT=0 USE_BINARYBUILDER=0
3. ファイルリスト作成
   └─ light-source-dist.tmpをfull-source-dist.tmpにコピー
4. 依存関係ファイル追加
   └─ deps/srccache/内の全アーカイブをリストに追加
5. プレフィックス付与
   └─ 全パスにjulia-${JULIA_COMMIT}/プレフィックスを付与
6. シンボリックリンク作成
   └─ カレントディレクトリにjulia-${JULIA_COMMIT}シンボリックリンクを作成
7. tarball生成
   └─ tar -cz --no-recursion でgzip圧縮tarballを作成（-fullサフィックス付き）
8. シンボリックリンク削除
   └─ 一時シンボリックリンクを削除
```

### フローチャート

```mermaid
flowchart TD
    A[full-source-dist開始] --> B[light-source-dist.tmp準備]
    B --> C[deps getall: 全依存関係ダウンロード]
    C --> D[light-source-dist.tmpをfull-source-dist.tmpにコピー]
    D --> E[deps/srccache/*をリストに追加]
    E --> F[パスにプレフィックス付与]
    F --> G[シンボリックリンク作成]
    G --> H[tarball生成: -full.tar.gz]
    H --> I[シンボリックリンク削除]
    I --> J[full-source-dist完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。ファイルシステム操作のみである。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | 前提条件エラー | light-source-dist.tmpの生成失敗 | light-source-distの前提条件を確認 |
| N/A | ネットワークエラー | 外部依存関係のダウンロード失敗 | ネットワーク接続を確認して再実行 |
| N/A | ディスクエラー | ディスク容量不足 | 十分なディスク容量を確保して再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 一時ファイル（`full-source-dist.tmp`、`full-source-dist.tmp1`）を手動削除する
2. 一時シンボリックリンク（`julia-${JULIA_COMMIT}`）が残っている場合は削除する
3. `deps/srccache/` の内容を確認し、不完全なダウンロードファイルを削除する
4. エラー原因を修正して再実行する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | 失敗時は一時ファイルを手動削除 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行につき1つのtarball |
| 目標処理時間 | 10分〜30分程度（ネットワーク速度と依存関係数に依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一ビルドディレクトリでの同時実行は不可。`light-source-dist`（No.12）との同時実行も不可（`light-source-dist.tmp` を共有するため）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 前提条件エラー時 | light-source-dist.tmpから継承されるエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 終了コード != 0 | 実行者（手動実行のため） |
| 出力ファイルサイズ | 0バイト | 実行者 |

## 備考

- `light-source-dist` と比較して、`deps/srccache/` 内の全依存関係ソースが追加される点が異なる
- 出力ファイル名には `-full` サフィックスが付与される（例: `julia-1.11.0_abcdef1234-full.tar.gz`）
- 旧名称 `source-dist` は非推奨であり、`full-source-dist` の使用が推奨される
- `DEPS_GIT=0` により、gitリポジトリのクローンではなくtarball形式での依存関係取得が行われる
- `USE_BINARYBUILDER=0` により、プリビルドバイナリではなくソースtarballが取得される
