# バッチ設計書 14-refresh_checksums

## 概要

本ドキュメントは、Juliaプロジェクトにおける `contrib/refresh_checksums.mk` のバッチ設計書である。このMakefileスクリプトは、BinaryBuilderの依存関係チェックサムを全プラットフォーム・全プロジェクトに対して再計算・更新するバッチ処理を定義する。

### 本バッチの処理概要

`refresh_checksums` は、Juliaが使用する全ての外部依存関係（BinaryBuilder由来のJLLパッケージおよびソースビルド用ライブラリ）のチェックサムを再計算し、`deps/checksums/` ディレクトリ内のチェックサムファイルを更新するバッチ処理である。

**業務上の目的・背景**：Juliaは多数の外部依存関係（OpenBLAS、LLVM、GMP、curl等）をBinaryBuilder経由のプリビルドバイナリまたはソースtarballとして利用している。依存関係のバージョン更新やJLLパッケージの更新時に、対応するチェックサムファイルを再生成する必要がある。手動での更新は対象プラットフォームとプロジェクトの組み合わせが膨大（18プラットフォーム x 数十プロジェクト）であるため、自動化が不可欠である。

**バッチの実行タイミング**：外部依存関係のバージョン更新時に手動で実行される。特にJLLパッケージの更新時や、新しいプラットフォームサポートの追加時に必要となる。AGENTS.mdにも「Run `make -f contrib/refresh_checksums.mk <jll>` to update the checksums」と記載されている。

**主要な処理内容**：
1. 既存のチェックサムファイルの削除（clean）
2. 各プロジェクト x 各プラットフォーム（triplet）の組み合わせに対するチェックサム計算
3. ソースビルド用チェックサムの計算
4. 標準ライブラリのチェックサム計算
5. ドキュメント用Unicodeデータのチェックサム計算
6. 並列計算結果の単一ファイルへのパッキング（pack-checksum）

**前後の処理との関連**：本バッチの出力は `deps/checksums/` ディレクトリに格納され、Juliaのビルドプロセス全体で依存関係の整合性検証に使用される。JLLパッケージの更新後、ビルド実行前に本バッチを実行する必要がある。

**影響範囲**：`deps/checksums/` ディレクトリ内の全チェックサムファイルが更新される。個別プロジェクト指定の場合は該当プロジェクトのチェックサムファイルのみ更新される。

## バッチ種別

データ生成 / チェックサム管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（依存関係更新時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動（`make -f contrib/refresh_checksums.mk [project]`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ネットワーク接続 | チェックサム計算対象のアーティファクトをダウンロードするために必要 |
| Make環境 | GNU Makeが使用可能であること |
| Juliaソースツリー | `deps/` および `stdlib/` ディレクトリが存在すること |

### 実行可否判定

特別な実行可否判定ロジックはない。ネットワークに接続されていれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| project | 文字列 | No | 全プロジェクト | 特定プロジェクト名を指定すると、そのプロジェクトのみ更新 |
| VERBOSE | 0/1 | No | 0 | 1を指定するとMake出力を詳細表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| リモートアーティファクト | バイナリ/tarball | BinaryBuilder/ソースリポジトリからダウンロードされるファイル |
| deps/Makefile | Makefile | 各依存関係のチェックサム計算ルール |
| stdlib/Makefile | Makefile | 標準ライブラリのチェックサム計算ルール |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| `deps/checksums/{project}` | テキストファイル | 各プロジェクトのチェックサム（triplet/hash形式） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | プロジェクト名（例: `openblas`, `llvm`, `gmp`） |
| 出力先 | `deps/checksums/` |
| 文字コード | ASCII |
| 区切り文字 | `triplet/hash_type/hash_value` 形式 |

## 処理フロー

### 処理シーケンス

```
1. 既存チェックサム削除（clean-{project}）
   └─ deps/checksums/{project} を削除
2. ソースチェックサム計算（checksum-{project}-src）
   └─ USE_BINARYBUILDER=0 で各プロジェクトのソースチェックサムを計算
3. BB tripletチェックサム計算（checksum-{project}-{triplet}）
   └─ 各プラットフォーム向けBBアーティファクトのチェックサムを並列計算
4. GCC展開プロジェクトのチェックサム計算
   └─ openblas、cslについてlibgfortranバージョン別に計算
5. CXX展開プロジェクトのチェックサム計算
   └─ gmp、llvm、clang、llvm-tools、lldについてcxxstring_abi別に計算
6. LLVM assertsバリアントのチェックサム計算
   └─ llvm、clang、lld、llvm-toolsのassertビルド用チェックサム
7. 標準ライブラリチェックサム計算
   └─ stdlib checksumall の実行
8. ドキュメントUnicodeデータチェックサム計算
   └─ doc checksum-unicodedata の実行
9. パッキング（pack-checksum-{project}）
   └─ 並列計算結果をソートして単一ファイルにマージ
```

### フローチャート

```mermaid
flowchart TD
    A[refresh_checksums開始] --> B{プロジェクト指定?}
    B -->|特定| C[指定プロジェクトのみ処理]
    B -->|全体| D[全プロジェクト処理]
    C --> E[clean: 既存チェックサム削除]
    D --> E
    E --> F[ソースチェックサム計算]
    F --> G[BB tripletチェックサム並列計算]
    G --> H[GCC展開プロジェクト計算]
    H --> I[CXX展開プロジェクト計算]
    I --> J[LLVM assertsバリアント計算]
    J --> K[stdlib/docチェックサム計算]
    K --> L[pack-checksum: 結果マージ]
    L --> M[refresh_checksums完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。ファイルシステム操作のみである。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | ネットワークエラー | アーティファクトのダウンロード失敗 | ネットワーク接続を確認して再実行 |
| N/A | 依存関係エラー | 指定バージョンのアーティファクトが存在しない | バージョン番号を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし（個別checksum計算は `-` プレフィックスでエラーを無視） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 失敗したプロジェクトを特定する
2. 該当プロジェクトのみを指定して再実行する（例: `make -f contrib/refresh_checksums.mk gmp`）
3. 全体再実行の場合は `make -f contrib/refresh_checksums.mk` を実行する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | プロジェクト単位 |
| コミットタイミング | pack-checksum実行時にファイルが確定 |
| ロールバック条件 | 失敗時は該当プロジェクトのチェックサムファイルが不完全な状態になる |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | BBプロジェクト11 + GCC展開2 + CXX展開5 + ソースのみ6 + stdlib + doc |
| 目標処理時間 | 数分〜数十分（ネットワーク速度とプロジェクト数に依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一プロジェクトに対する同時実行は不可。pack-checksumフェーズでのファイル競合を避けるため、llvm/llvm-tools、libsuitesparse/suitesparse等の名前が部分一致するプロジェクト間で明示的な依存関係が定義されている。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | pack-checksum時 | `making deps/checksums/{project}` |
| デバッグログ | VERBOSE=1時 | Makeの詳細出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 終了コード != 0 | 実行者（手動実行のため） |

## 備考

- 対応するBBプロジェクト: openssl, libssh2, nghttp2, mpfr, curl, libgit2, pcre, libuv, unwind, llvmunwind, dsfmt, objconv, p7zip, zlib, zstd, libsuitesparse, openlibm, blastrampoline, libtracyclient, mmtk_julia
- GCC展開プロジェクト（libgfortranバージョン別）: openblas, csl
- CXX展開プロジェクト（cxxstring_abi別）: gmp, llvm, clang, llvm-tools, lld
- ソースのみプロジェクト: patchelf, mozillacert, lapack, libwhich, utf8proc, ittapi
- 対応TRIPLETs: aarch64-apple-darwin, aarch64-linux-gnu, aarch64-linux-musl, aarch64-unknown-freebsd, armv6l-linux-gnueabihf, armv6l-linux-musleabihf, armv7l-linux-gnueabihf, armv7l-linux-musleabihf, i686-linux-gnu, i686-linux-musl, i686-w64-mingw32, powerpc64le-linux-gnu, riscv64-linux-gnu, x86_64-apple-darwin, x86_64-linux-gnu, x86_64-linux-musl, x86_64-unknown-freebsd, x86_64-w64-mingw32
- macOS/FreeBSD（CLANGトリプレット）はcxxstring_abi展開を行わない
