# バッチ設計書 15-stdlibs-cache

## 概要

本ドキュメントは、JuliaプロジェクトにおけるMakefileの `stdlibs-cache-release` / `stdlibs-cache-debug` ターゲットおよび `pkgimage.mk` のバッチ設計書である。このターゲットは、標準ライブラリのパッケージイメージキャッシュ（プリコンパイル済みキャッシュ）を生成する。

### 本バッチの処理概要

`stdlibs-cache` は、Juliaの標準ライブラリ（独立stdlib）をプリコンパイルし、パッケージイメージキャッシュとしてデポディレクトリに保存するバッチ処理である。

**業務上の目的・背景**：Juliaの標準ライブラリは起動時にロードされるが、毎回コンパイルすると起動時間が長くなる。事前にプリコンパイルしてキャッシュファイル（.ji および .so/.dylib）を生成しておくことで、初回利用時のコンパイル待ち時間を排除し、ユーザー体験を向上させる。ビルドプロセスの一部として、リリースビルドおよびデバッグビルドの両方で実行される。

**バッチの実行タイミング**：Juliaの `make release` または `make debug` のビルドプロセスの一部として自動実行される。明示的に `make stdlibs-cache-release` または `make stdlibs-cache-debug` として個別実行も可能。Juliaのシステムイメージ（sysimg）ビルド完了後に実行される。

**主要な処理内容**：
1. デポディレクトリ（`$(build_prefix)/share/julia`）の準備
2. Julia実行環境の設定（`JULIA_DEPOT_PATH`、`JULIA_LOAD_PATH`）
3. `Base.Precompilation.precompilepkgs` の実行による全独立標準ライブラリのプリコンパイル
4. 2つの設定（通常モードとbounds-checkモード）でのプリコンパイル

**前後の処理との関連**：Juliaのシステムイメージビルド（`julia-release` / `julia-debug`）が前提処理。`stdlibs-cache` の完了後に `docs` ターゲットが実行可能となる。release/debugの各メインターゲットは `julia-%` と `stdlibs-cache-%` の両方に依存する。

**影響範囲**：`$(build_prefix)/share/julia/compiled/` ディレクトリ内に全独立標準ライブラリのキャッシュファイルが生成される。`stdlib/release.image` または `stdlib/debug.image` マーカーファイルが作成される。

## バッチ種別

ビルド / プリコンパイルキャッシュ生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルド時（随時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | `make release` / `make debug` の一部として自動実行、または手動（`make stdlibs-cache-release`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| システムイメージビルド済み | `sys.$(SHLIB_EXT)` または `sys-debug.$(SHLIB_EXT)` が存在すること |
| Julia実行可能 | ビルド済みのJulia実行ファイルが利用可能であること |
| stdlib/Project.toml | 標準ライブラリのプロジェクト定義が存在すること |
| stdlib/Manifest.toml | 標準ライブラリのマニフェストファイルが存在すること |

### 実行可否判定

Makeの依存関係により自動判定される。システムイメージが存在し、stdlib関連ファイルが更新されている場合に実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| JULIA_EXECUTABLE | パス | Yes | ビルドされたJulia | プリコンパイルに使用するJulia実行ファイル |
| JULIA_CPU_TARGET | 文字列 | Yes | sysimage | CPU ターゲット設定 |
| JULIA_DEPOT_PATH | パス | Yes | `$(build_prefix)/share/julia` | デポディレクトリパス |
| JULIA_LOAD_PATH | パス | Yes | `@stdlib:$(JULIAHOME)/stdlib` | ロードパス設定 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| stdlib/Project.toml | TOMLファイル | 標準ライブラリのプロジェクト定義 |
| stdlib/Manifest.toml | TOMLファイル | 標準ライブラリの依存関係マニフェスト |
| 独立stdlibソースファイル群 | Juliaソース | 各標準ライブラリのソースコード |
| sys.$(SHLIB_EXT) | 共有ライブラリ | ビルド済みシステムイメージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| `$(build_prefix)/share/julia/compiled/` | キャッシュファイル群 | プリコンパイル済みパッケージイメージ |
| `stdlib/release.image` / `stdlib/debug.image` | マーカーファイル | ビルド完了フラグ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各stdlibのキャッシュファイル（.ji, .so/.dylib等） |
| 出力先 | `$(build_prefix)/share/julia/compiled/v{major}.{minor}/` |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. デポディレクトリ作成
   └─ $(DEPOTDIR)/compiled ディレクトリを作成
2. 環境変数設定
   └─ JULIA_DEPOT_PATH、JULIA_LOAD_PATH、JULIA_CPU_TARGET を設定
3. プリコンパイル実行（設定1: 通常モード）
   └─ CacheFlags(debug_level=2, opt_level=3) でプリコンパイル
4. プリコンパイル実行（設定2: bounds-checkモード）
   └─ CacheFlags(check_bounds=1, debug_level=2, opt_level=3) でプリコンパイル
5. マーカーファイル作成
   └─ stdlib/{release|debug}.image を touch
```

### フローチャート

```mermaid
flowchart TD
    A[stdlibs-cache開始] --> B[デポディレクトリ作成]
    B --> C[環境変数設定]
    C --> D[Julia起動]
    D --> E[Base.Precompilation.precompilepkgs実行]
    E --> F[設定1: 通常モードでプリコンパイル]
    F --> G[設定2: bounds-checkモードでプリコンパイル]
    G --> H{strict=true: 全て成功?}
    H -->|Yes| I[マーカーファイル作成]
    H -->|No| J[エラー終了]
    I --> K[stdlibs-cache完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。ファイルシステム操作のみである。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | プリコンパイルエラー | stdlibのコンパイルに失敗 | エラーログを確認し、該当stdlibのソースコードを修正 |
| N/A | システムイメージエラー | sys.soが破損または未ビルド | `make julia-release` を再実行 |
| N/A | 権限エラー | デポディレクトリへの書き込み権限不足 | ディレクトリの権限を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `make -f pkgimage.mk clean` でキャッシュを削除する
2. エラーログを確認し、問題のある標準ライブラリを特定する
3. 必要に応じてシステムイメージを再ビルドする
4. `make stdlibs-cache-release` を再実行する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 全標準ライブラリ一括（strict=true） |
| コミットタイミング | 全プリコンパイル完了時 |
| ロールバック条件 | strict=trueのため、いずれかのstdlibが失敗すると全体が失敗 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 独立標準ライブラリ全数（2設定 x N個のstdlib） |
| 目標処理時間 | 数分〜10分程度（CPU性能に依存） |
| メモリ使用量上限 | 特に制限なし（Juliaプロセスのメモリ使用量に依存） |

## 排他制御

同一デポディレクトリに対する同時実行は不可。releaseとdebugは異なるイメージファイルを使用するが、同一デポディレクトリを共有するため、並行実行は避けるべきである。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | プリコンパイル中 | Julia precompilepkgsの進捗表示 |
| エラーログ | プリコンパイル失敗時 | 失敗した標準ライブラリ名とエラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 終了コード != 0 | ビルドシステム（Makeの依存関係により後続処理が中止） |
| マーカーファイル | 未作成 | ビルドシステム |

## 備考

- `JULIA_FALLBACK_REPL := true` が設定されるが、これはバッチ実行時には影響しない
- 2つのCacheFlags設定により、通常実行用とbounds-check有効版の2種類のキャッシュが生成される
- `JULIA_CPU_TARGET=sysimage` により、システムイメージと同じCPUターゲットでプリコンパイルされる
- `--startup-file=no` により、ユーザーのスタートアップファイルの影響を受けない
- `make clean`（pkgimage.mk内）で `$(DEPOTDIR)/compiled` ディレクトリとマーカーファイルが削除される
- `JULIA_PROJECT`、`JULIA_BINDIR` は明示的に `unexport` されており、環境変数の汚染が防がれている
