# バッチ設計書 16-check-whitespace.jl

## 概要

本ドキュメントは、Juliaプロジェクトにおける `contrib/check-whitespace.jl` のバッチ設計書である。このJuliaスクリプトは、ソースコード内のホワイトスペースエラーを検出し、オプションで自動修正するメンテナンスバッチ処理である。

### 本バッチの処理概要

`check-whitespace.jl` は、Juliaリポジトリ内の指定パターンに一致するソースファイルを走査し、ホワイトスペースに関するコーディング規約違反を検出するバッチ処理である。`--fix` オプションにより自動修正も可能。

**業務上の目的・背景**：ソースコードの品質と一貫性を維持するために、ホワイトスペースに関する統一的なルールを適用する必要がある。タブとスペースの混在、行末の余白、非UNIX改行コード、非ブレーキングスペースなどの問題は、差分表示の見づらさやコンパイルエラーの原因となりうる。CI/CDパイプライン（GitHub Actions）のWhitespace.ymlワークフロー（No.1）からも呼び出され、プルリクエスト時の自動チェックに利用される。

**バッチの実行タイミング**：プルリクエスト作成・プッシュ時のGitHub Actionsワークフローから自動実行されるほか、開発者がローカルで手動実行する。`make fix-whitespace` として自動修正モードでも使用される（AGENTS.mdに記載の通り、コミット前に実行が推奨される）。

**主要な処理内容**：
1. 対象ファイルリストの取得（引数指定またはgit ls-filesからのパターンマッチ）
2. `--fix` モードの場合: タブのスペース変換、行末空白の除去、改行コードの統一、非ブレーキングスペースの変換
3. チェックモード: 非UNIX改行、非ブレーキングスペース、タブ（許可されていないファイル）、行末改行なし、行末空白、末尾空行の検出
4. GitHub Actionsのアノテーション形式での警告出力（`::warning` 形式）
5. エラーが見つかった場合は終了コード1で終了

**前後の処理との関連**：CI/CDのWhitespace.yml（No.1）から呼び出される。`make test`（No.27）の前段で実行されるホワイトスペースチェックでも使用される。開発者は `make fix-whitespace` でコミット前に自動修正を実行する。

**影響範囲**：チェックモードではファイルの変更なし（読み取り専用）。`--fix` モードでは対象パターンに一致する全ソースファイルの内容が修正される可能性がある。

## バッチ種別

コード品質検証 / メンテナンス

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | PR/プッシュ時（自動）、コミット前（手動） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | GitHub Actions（自動）、`make fix-whitespace`（手動） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Julia実行環境 | Juliaが実行可能であること |
| gitリポジトリ | 引数なしの場合、`git ls-files` が実行可能であること |

### 実行可否判定

特別な実行可否判定ロジックはない。Julia環境があれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ARGS（ファイルパス群） | 文字列配列 | No | git ls-filesの出力 | チェック対象ファイルパスのリスト |
| --fix | フラグ | No | なし | 自動修正モードを有効化 |
| GITHUB_ACTIONS | 環境変数 | No | false | trueの場合、GHAアノテーション形式で出力 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースファイル群 | テキストファイル | パターンに一致する全ソースファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| stderr | テキスト | エラーレポート（ファイルパス:行番号 -- エラー種別） |
| stdout | テキスト | GitHub Actionsアノテーション（`::warning` 形式、GHA環境のみ） |
| ソースファイル | テキスト | `--fix` モード時に修正済みファイルを上書き |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力と同じファイル（`--fix` モード時） |
| 出力先 | 入力と同じパス |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 対象ファイルリスト取得
   └─ ARGS指定がある場合はそれを使用、ない場合はgit ls-filesからパターンマッチ
2. --fixモード判定
   └─ ARGSに--fixが含まれるかチェック
3. [--fixモード] ファイル修正
   └─ 各ファイルについて: タブ変換、行末空白除去、改行正規化、NBSP変換
4. チェック実行
   └─ 各ファイルの各行について: 改行コード、NBSP、タブ、行末空白、末尾改行、末尾空行を検出
5. 結果出力
   └─ エラーなし: 終了コード0 / エラーあり: エラーリスト出力後に終了コード1
```

### フローチャート

```mermaid
flowchart TD
    A[check-whitespace開始] --> B{ファイルリスト取得}
    B -->|ARGS指定| C[引数からファイルリスト作成]
    B -->|引数なし| D[git ls-files -- patternsで取得]
    C --> E{--fixモード?}
    D --> E
    E -->|Yes| F[ファイル自動修正]
    E -->|No| G[チェック実行]
    F --> G
    G --> H{エラー検出?}
    H -->|なし| I[終了コード0]
    H -->|あり| J[エラーレポート出力]
    J --> K{GitHub Actions?}
    K -->|Yes| L[::warningアノテーション出力]
    K -->|No| M[終了コード1]
    L --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。ファイルシステム操作のみである。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード1 | ホワイトスペースエラー | ソースファイルにホワイトスペース問題が検出された | `--fix` オプションで自動修正、または手動修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（エラーは修正が必要） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーレポートを確認し、問題のあるファイルと行番号を特定する
2. `julia contrib/check-whitespace.jl --fix` で自動修正を実行する
3. 自動修正で対応できない場合は手動で修正する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位（`--fix` モード時） |
| コミットタイミング | 各ファイルの修正完了時にwrite |
| ロールバック条件 | N/A（gitによるバージョン管理で対応） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | リポジトリ内の対象パターンに一致する全ファイル |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

`--fix` モードでの同時実行は不可（ファイルの同時書き込みが発生する可能性がある）。チェックのみモードでは同時実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 成功ログ | チェック完了時（エラーなし） | `Whitespace check found no issues.` |
| エラーログ | チェック完了時（エラーあり） | `Whitespace check found N issues:` + 個別エラー |
| 修正ログ | `--fix` モード完了時 | `Fixed whitespace issues in N files.` |
| GHAアノテーション | 各エラー検出時 | `::warning title=Whitespace check,file=...,line=...::msg` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 終了コード == 1 | GitHub Actions（PR上にアノテーション表示） |

## 備考

- 対象ファイルパターン: `*.1`, `*.c`, `*.cpp`, `*.h`, `*.inc`, `*.jl`, `*.lsp`, `*.make`, `*.md`, `*.mk`, `*.rst`, `*.scm`, `*.sh`, `*.yml`, `*Makefile`
- タブが許可されるファイル: `Make.inc`, `*Makefile`, `*.make`, `*.mk`, `src/support/*`, `src/flisp/*`, `test/syntax.jl`, `test/triplequote.jl`
- `--fix` モードでのタブ変換: 行頭のタブを4スペースに変換（タブ許可ファイルを除く）
- 検出されるエラー種別: 非UNIX改行、非ブレーキングスペース（U+00A0）、タブ（非許可ファイル）、行末改行なし、行末空白、末尾空行
