# バッチ設計書 18-updateSPDX.jl

## 概要

本ドキュメントは、Juliaプロジェクトにおける `contrib/updateSPDX.jl` のバッチ設計書である。このJuliaスクリプトは、リリース時に `julia.spdx.json` のSPDXドキュメントを更新するメンテナンスバッチ処理である。

### 本バッチの処理概要

`updateSPDX.jl` は、Juliaの各リリースに合わせて、ソフトウェアパッケージデータ交換（SPDX）ドキュメントのメタデータを自動更新するバッチ処理である。

**業務上の目的・背景**：SPDX（Software Package Data Exchange）は、ソフトウェアのライセンス情報やコンポーネント情報を標準化されたフォーマットで記述するための国際規格である。Juliaプロジェクトは `julia.spdx.json` としてSPDXドキュメントを管理しており、各リリース時にバージョン情報、ドキュメントの一意識別子（UUID）、作成日時などを更新する必要がある。手動更新ではミスが発生しやすいため、自動化されている。

**バッチの実行タイミング**：リリース準備プロセスのステップ5として手動実行される。Makefileのリリース手順に「Update SPDX document by running the script contrib/updateSPDX.jl」と記載されている。

**主要な処理内容**：
1. `julia.spdx.json` の読み込みとJSON解析
2. `documentNamespace` の更新（新しいUUID4を生成）
3. `creationInfo.created` の更新（UTC現在日時）
4. パッケージ情報の走査と `SPDXRef-JuliaMain` パッケージの特定
5. `versionInfo` の更新（VERSIONファイルから取得）
6. `downloadLocation` の更新（gitタグURL）
7. 更新されたJSONの書き出し

**前後の処理との関連**：リリース手順のステップ4（VERSION番号のバンプ）の後、ステップ6（タグ作成・プッシュ）の前に実行される。本バッチの出力は `julia.spdx.json` としてリリースtarballに含まれる。

**影響範囲**：`julia.spdx.json` ファイルのみが更新される。

## バッチ種別

メンテナンス / メタデータ更新

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（各リリース時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動（`julia contrib/updateSPDX.jl`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Julia実行環境 | Juliaが実行可能であること |
| 依存パッケージ | UUIDs, Dates, JSON, TimeZones, DataStructuresパッケージが利用可能であること |
| VERSIONファイル | `../VERSION` ファイルが存在し、正しいバージョン番号が記載されていること |
| SPDXファイル | `../julia.spdx.json` が存在し、有効なJSONであること |

### 実行可否判定

特別な実行可否判定ロジックはない。前提条件が満たされていれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| N/A | - | - | - | コマンドライン引数は受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| `../julia.spdx.json` | JSONファイル | 既存のSPDXドキュメント |
| `../VERSION` | テキストファイル | Juliaバージョン番号（1行目） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| `../julia.spdx.json` | JSONファイル | 更新されたSPDXドキュメント |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | `julia.spdx.json` |
| 出力先 | プロジェクトルートディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | JSON形式（インデント: 4スペース） |

## 処理フロー

### 処理シーケンス

```
1. SPDXファイル読み込み
   └─ julia.spdx.jsonをOrderedDictとしてJSON解析
2. documentNamespace更新
   └─ 新しいUUID4を生成してURLに埋め込み
3. creationInfo.created更新
   └─ UTC現在日時をISO 8601形式で設定
4. パッケージ情報走査
   └─ packages配列からSPDXRef-JuliaMainを検索
5. versionInfo更新
   └─ VERSIONファイルの1行目を読み込んで設定
6. downloadLocation更新
   └─ git+https://github.com/JuliaLang/julia.git@v{version}形式で設定
7. JSONファイル書き出し
   └─ 4スペースインデントで整形して上書き保存
```

### フローチャート

```mermaid
flowchart TD
    A[updateSPDX開始] --> B[julia.spdx.json読み込み]
    B --> C[documentNamespace更新: UUID4生成]
    C --> D[creationInfo.created更新: UTC日時]
    D --> E[packages配列を走査]
    E --> F{SPDXID == SPDXRef-JuliaMain?}
    F -->|No| E
    F -->|Yes| G[versionInfo更新: VERSIONファイルから]
    G --> H[downloadLocation更新: gitタグURL]
    H --> I[julia.spdx.json書き出し]
    I --> J[updateSPDX完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。ファイルシステム操作のみである。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | ファイル不在エラー | julia.spdx.jsonまたはVERSIONが存在しない | ファイルの存在を確認 |
| N/A | JSON解析エラー | julia.spdx.jsonが不正なJSON | JSONの構文を修正 |
| N/A | パッケージ不在エラー | SPDXRef-JuliaMainが見つからない | SPDXファイルの構造を確認 |
| N/A | 依存パッケージエラー | JSON, TimeZones等が未インストール | パッケージをインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認する
2. 依存パッケージが不足している場合はインストールする
3. SPDXファイルの構造が変更されている場合はスクリプトを更新する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 単一ファイル（julia.spdx.json） |
| コミットタイミング | JSON書き出し完了時 |
| ロールバック条件 | N/A（gitによるバージョン管理で対応） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

特になし。単一ファイルの更新のみであり、通常は同時実行されない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| N/A | - | 標準的なログ出力は行わない |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 異常終了 | 実行者（手動実行のため） |

## 備考

- 現時点では自動更新できる項目は限定的（documentNamespace、creationInfo.created、versionInfo、downloadLocation）
- 外部依存関係の追加・削除や著作権テキストの更新は手動で行う必要がある（スクリプト内コメントに記載）
- `OrderedDict` を使用してJSONのキー順序を保持している
- `documentNamespace` のURL形式: `https://julialang.org/spdxdocs/julia-spdx-{uuid4}`
- `downloadLocation` の形式: `git+https://github.com/JuliaLang/julia.git@v{version}`
- 日時形式: ISO 8601（`yyyy-mm-ddTHH:MM:SSZ`）、UTCタイムゾーン
- 依存パッケージ: UUIDs（標準）、Dates（標準）、JSON、TimeZones、DataStructures
