# バッチ設計書 2-Typos

## 概要

本ドキュメントは、JuliaLangリポジトリにおけるTypos検出GitHub Actionsワークフローのバッチ設計書である。プルリクエスト時にソースコード内の新規タイポ（スペルミス）を検出し、コード品質の向上を支援するCI/CDパイプラインの一部として機能する。

### 本バッチの処理概要

このバッチは、プルリクエスト作成・更新時に自動実行され、変更されたファイル内の新規スペルミスを検出するCI/CDワークフローである。既存のタイポは無視し、PRで新たに導入されたタイポのみを検出するインクリメンタルな検査を行う。

**業務上の目的・背景**：Juliaプロジェクトの大規模なコードベースでは、コメント、ドキュメント、変数名などにスペルミスが混入する可能性がある。全てのタイポを一度に検出するとノイズが多くなるため、PRで新たに導入されたタイポのみを検出するインクリメンタルなアプローチを採用している。これにより開発者は自分が導入した問題のみに集中でき、コードベースの品質を段階的に改善できる。

**バッチの実行タイミング**：プルリクエストの作成・更新時に自動実行される。pushイベントでは実行されない。

**主要な処理内容**：
1. リポジトリのチェックアウトおよびベースブランチの取得
2. crate-ci/typosツールの最新リリースをダウンロード・展開
3. PR変更後のファイルに対してタイポチェックを実行（new_typos.jsonl生成）
4. ベースブランチ時点のファイルに対してタイポチェックを実行（old_typos.jsonl生成）
5. Pythonスクリプトで新旧タイポを比較し、新規かつ7文字超のタイポのみをエラーとして報告

**前後の処理との関連**：本バッチは独立したCIジョブであり、他のCIジョブとの直接的な依存関係はない。No.1のWhitespaceチェックと同様に、コード品質を維持するためのチェックの一つである。

**影響範囲**：PRで変更されたファイル（追加・変更のみ、削除ファイルは除外）が検査対象となる。検査結果はGitHub ActionsのCI結果としてPRに表示される。6文字以下の短いタイポは偽陽性の可能性があるためワーニングのみ出力し、7文字超のタイポが存在する場合にCIを失敗させる。

## バッチ種別

コード品質チェック（スペルチェック）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | GitHub Actionsイベント（pull_request） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHubリポジトリ | JuliaLang/juliaリポジトリ上で動作すること |
| ランナー環境 | ubuntu-latestが利用可能であること |
| GitHub Token | typosツールのリリース取得にGITHUB_TOKENが必要 |
| Python | ランナー環境にPython 3が利用可能であること |
| ベースブランチ | PRのベースブランチが存在し、fetchが可能であること |

### 実行可否判定

pull_requestイベントが発生した場合に自動的に実行される。全ての編集ファイルが削除された場合（NEW_FILESが空）はスキップされる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| github.base_ref | String | Yes | - | PRのベースブランチ名（GitHubが自動設定） |
| github.token | String | Yes | - | GitHub APIアクセス用トークン（GitHubが自動設定） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| git diff-index | テキスト | PRで変更されたファイル一覧（--name-only） |
| PRの変更ファイル | テキスト | 変更後のソースコードファイル |
| ベースブランチのファイル | テキスト | 変更前のソースコードファイル |
| crate-ci/typos releases API | JSON | typosツールの最新リリースバイナリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| stdout | テキスト | GitHub Actions ::warning形式のアノテーション |
| 終了コード | 整数 | 0: 新規タイポなし、1: 7文字超の新規タイポあり |
| new_typos.jsonl | JSONL | 変更後ファイルで検出されたタイポ一覧（一時ファイル） |
| old_typos.jsonl | JSONL | ベースブランチファイルで検出されたタイポ一覧（一時ファイル） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | new_typos.jsonl / old_typos.jsonl |
| 出力先 | ${{ runner.temp }}（一時ディレクトリ） |
| 文字コード | UTF-8 |
| 区切り文字 | 改行区切りJSON（JSONL形式） |

## 処理フロー

### 処理シーケンス

```
1. リポジトリチェックアウト
   └─ actions/checkout@v6.0.2でPRのソースコードを取得
2. ベースブランチ取得
   └─ git fetch --depth=1 origin $base_refでベースブランチの最新コミットを取得
3. 変更ファイル一覧の取得
   ├─ OLD_FILES: git diff-index --name-only --diff-filter=ad（追加・削除以外の変更ファイル）
   └─ NEW_FILES: git diff-index --name-only --diff-filter=d（削除以外の全変更ファイル）
4. 空チェック
   └─ NEW_FILESが空の場合はスキップして正常終了
5. typosツールのダウンロード
   ├─ gh API経由で最新リリースのURL取得
   └─ wgetでx86_64-unknown-linux-musl版バイナリをダウンロード・展開
6. 新ファイルのタイポチェック
   └─ NEW_FILESに対してtypos --format jsonを実行し、new_typos.jsonlに出力
7. 旧ファイルのタイポチェック
   ├─ git checkout FETCH_HEAD -- $OLD_FILESでベースブランチ版に切り替え
   └─ OLD_FILESに対してtypos --format jsonを実行し、old_typos.jsonlに出力
8. 差分比較（Pythonスクリプト）
   ├─ old_typos.jsonlからタイポ文字列のセットを構築
   ├─ new_typos.jsonlから新規タイポ（old setに含まれないもの）を抽出
   ├─ 各新規タイポに対して::warning形式のアノテーションを出力
   └─ 7文字超の新規タイポがある場合はexit 1
```

### フローチャート

```mermaid
flowchart TD
    A[ワークフロー開始] --> B[リポジトリチェックアウト]
    B --> C[ベースブランチfetch]
    C --> D[変更ファイル一覧取得]
    D --> E{NEW_FILESが空?}
    E -->|空| F[スキップ - exit 0]
    E -->|空でない| G[typosツールダウンロード]
    G --> H[NEW_FILESのタイポチェック]
    H --> I[ベースブランチファイルに切り替え]
    I --> J[OLD_FILESのタイポチェック]
    J --> K[Python: 新旧タイポ比較]
    K --> L{新規タイポあり?}
    L -->|7文字超あり| M[exit 1 - 失敗]
    L -->|なし or 6文字以下のみ| N[exit 0 - 成功]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| exit 1 | 新規タイポ検出 | 7文字超の新規タイポが検出された場合 | 開発者がタイポを修正するか、意図的な単語の場合は設定ファイルに除外登録する |
| timeout | タイムアウト | 5分以内に処理が完了しない場合 | GitHub Actionsにより自動中断 |
| download failure | ダウンロードエラー | typosバイナリのダウンロードに失敗した場合 | wgetが3回リトライする。解決しない場合は手動で再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 3回（wgetの--tries=3） |
| リトライ間隔 | wgetのデフォルト（接続エラー時に自動リトライ） |
| リトライ対象エラー | typosバイナリのダウンロードエラー（--retry-on-host-error --retry-connrefused） |

### 障害時対応

ワークフロー失敗時は、GitHub Actionsの実行ログで::warningアノテーションを確認し、指摘されたタイポを修正する。偽陽性の場合はtyposの設定ファイルに除外設定を追加する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | PRで変更されたファイル（通常数十ファイル） |
| 目標処理時間 | 5分以内（timeout-minutes: 5） |
| メモリ使用量上限 | GitHub Actionsランナーの標準上限 |

## 排他制御

読み取り専用の検査であり、排他制御は不要。GitHub Actionsのconcurrencyグループは設定されていない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各ステップ開始時 | GitHub Actionsのステップログに自動記録 |
| バージョンログ | typos取得後 | typos --versionの出力 |
| ワーニングログ | タイポ検出時 | `::warning file={path},line={line},col={col}::perhaps "{typo}" should be "{corrections}"` |
| 結果ログ | 処理完了時 | Pythonスクリプトの終了コードで成否を示す |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ワークフロー実行時間 | 5分 | GitHub Actions（自動タイムアウト） |
| ワークフロー失敗 | 1回 | GitHub PR Checksタブ |

## 備考

- permissionsは空（`{}`）に設定されており、GH_TOKENはgithub.tokenを使用
- typosツールはcrate-ci/typosの最新リリースをGitHub API経由で取得する（以前はuses形式だったが変更されている）
- ダウンロードはTLS 1.3を使用し、セキュアなプロトコルで行われる
- 短いタイポ（6文字以下）は偽陽性の可能性があるため、ワーニングは出力するがCIを失敗させない
- diff-filterの`ad`は「追加(a)」と「削除(d)」を除外、`d`は「削除」のみを除外する意味
