# バッチ設計書 21-new-stdlib.sh

## 概要

本ドキュメントは、Juliaリポジトリに新しい標準ライブラリのスキャフォールディングを生成するウィザードスクリプト `contrib/new-stdlib.sh` のバッチ設計書である。

### 本バッチの処理概要

本バッチは、Juliaプロジェクトに新しい標準ライブラリ（stdlib）を追加する際に必要なディレクトリ構造、設定ファイル、およびMakefile登録を自動的に生成するインタラクティブなウィザードスクリプトである。ローカルstdlibと外部GitHub hosted stdlibの両方に対応している。

**業務上の目的・背景**：Juliaの標準ライブラリを追加する作業は、複数のファイルやディレクトリの作成、Makefileへの登録、Project.tomlの生成など多くの手順を伴う。これらを手作業で行うとファイルの作成漏れやフォーマットの不整合が生じやすい。本スクリプトはこれらの手順を自動化し、一貫性のあるstdlib追加を実現する。

**バッチの実行タイミング**：新しい標準ライブラリをJuliaリポジトリに追加する際に、開発者が手動で実行する。不定期実行であり、新stdlib追加時のみ使用される。

**主要な処理内容**：
1. 対話形式で新しいstdlib名とGitHubユーザアカウント（任意）を入力受付
2. ローカルstdlibの場合：UUIDの生成、ディレクトリ構造の作成（src/、test/）、Project.toml・ソースファイル・テストファイルの生成、stdlib/Makefileへの登録、git add実行
3. 外部stdlibの場合：バージョンファイル（.version）の生成（ブランチ、SHA1、Git URL、Tar URL）、Makefileへの外部stdlib登録、git add実行
4. 後続の手動手順（test/precompile.jl、test/choosetests.jl、base/sysimg.jlへの追記）の案内表示

**前後の処理との関連**：本スクリプト実行後、開発者はtest/precompile.jl（Base.cache_dependencies）、test/choosetests.jl（net_required_for）、base/sysimg.jl（stdlibs）に手動で新stdlibを追加する必要がある。また、stdlibの依存関係順序に従ってソートされた位置に追加する必要がある。

**影響範囲**：stdlib/ディレクトリ配下のファイル構造、stdlib/Makefile、gitステージングエリアに影響する。新たに追加されたstdlibはビルドシステム全体およびテストスイートに組み込まれる。

## バッチ種別

スキャフォールディング生成 / コード自動生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（新stdlib追加時のみ） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Juliaリポジトリのクローン | Juliaソースコードリポジトリがローカルに存在すること |
| gitが利用可能 | gitコマンドが実行可能な環境であること |
| uuidgenが利用可能 | ローカルstdlibの場合、UUIDを生成するためuuidgenコマンドが必要 |
| stdlib/Makefileが存在 | STDLIBS変数またはSTDLIBS_EXT変数が定義されていること |

### 実行可否判定

スクリプトは `set -eu` により、コマンド失敗時またはundefined変数参照時に即座に停止する。入力値のバリデーションは最小限であり、名前やSHA1の妥当性チェックは行わない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NAME | 文字列 | Yes | なし | 新しいstdlibの名前（対話入力） |
| USER | 文字列 | No | 空文字列 | GitHubユーザアカウント。空の場合ローカルstdlibとして作成 |
| SHA1 | 文字列 | 条件付き | なし | 外部stdlib時のGitコミットSHA1ハッシュ（USER指定時に必須） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 標準入力（対話） | テキスト | ユーザからのstdlib名、GitHubアカウント、SHA1ハッシュの入力 |
| stdlib/Makefile | Makefile | STDLIBS変数またはSTDLIBS_EXT変数への追記対象 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| stdlib/{NAME}/Project.toml | TOML | パッケージ名とUUIDを含むプロジェクト定義ファイル（ローカル時） |
| stdlib/{NAME}/src/{NAME}.jl | Julia | モジュール定義のスケルトンファイル（ローカル時） |
| stdlib/{NAME}/test/runtests.jl | Julia | テストファイルのスケルトン（ローカル時） |
| stdlib/{NAME}.version | Makefile変数 | ブランチ、SHA1、Git URL、Tar URLの定義（外部時） |
| stdlib/Makefile | Makefile | STDLIBS変数またはSTDLIBS_EXT変数への新エントリ追加 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | stdlib名に基づく自動命名 |
| 出力先 | stdlib/配下 |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. ウィザード開始メッセージの表示
   └─ "Julia Stdlib Creator Helper Wizard" ヘッダーを表示
2. stdlib名の入力受付
   └─ read -p "Name: " NAME
3. GitHubユーザアカウントの入力受付
   └─ read -p "Github User account (empty for local): " USER
4a. ローカルstdlibパス（USERが空の場合）
   ├─ UUIDの生成（uuidgen | tr [A-Z] [a-z]）
   ├─ stdlib/Makefile の STDLIBS 変数に NAME を追加（sed）
   ├─ ディレクトリ構造の作成（mkdir: stdlib/{NAME}, src, test）
   ├─ Project.toml の生成（name, uuid）
   ├─ src/{NAME}.jl の生成（空のmodule定義）
   ├─ test/runtests.jl の生成（テストスケルトン）
   └─ git add による新規ファイルのステージング
4b. 外部stdlibパス（USERが指定された場合）
   ├─ Git SHA1ハッシュの入力受付
   ├─ stdlib/Makefile の STDLIBS_EXT 変数に NAME を追加（sed）
   ├─ {NAME}.version ファイルの生成（BRANCH, SHA1, GIT_URL, TAR_URL）
   └─ git add によるバージョンファイルのステージング
5. 後続手順の案内メッセージを表示
   └─ test/precompile.jl、test/choosetests.jl、base/sysimg.jl への手動追記を案内
6. ウィザード終了メッセージの表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[stdlib名の入力受付]
    B --> C[GitHubユーザアカウントの入力受付]
    C --> D{USERが空か?}
    D -->|空（ローカル）| E[UUID生成]
    E --> F[Makefile STDLIBS変数に追加]
    F --> G[ディレクトリ構造作成]
    G --> H[Project.toml生成]
    H --> I[ソースファイル生成]
    I --> J[テストファイル生成]
    J --> K[git add 実行]
    D -->|指定あり（外部）| L[SHA1ハッシュ入力受付]
    L --> M[Makefile STDLIBS_EXT変数に追加]
    M --> N[.versionファイル生成]
    N --> O[git add 実行]
    K --> P[後続手順の案内表示]
    O --> P
    P --> Q[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。ファイルシステム上の操作のみ行う。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | 該当なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1（set -e） | コマンド失敗 | mkdir、sed、git等のコマンドが失敗した場合 | スクリプトが即座に停止。手動でクリーンアップが必要 |
| 1（set -u） | 未定義変数 | 必要な変数が未定義の場合 | スクリプトが即座に停止。入力値を確認して再実行 |
| 該当なし | 重複名 | 既に同名のstdlibディレクトリが存在する場合 | mkdirが失敗しスクリプト停止。別名での実行が必要 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動再実行が必要） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

スクリプトが途中で失敗した場合、部分的に作成されたファイルやMakefileの変更が残る可能性がある。`git checkout -- stdlib/Makefile` および作成途中のディレクトリの手動削除が必要となる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作のためトランザクション制御なし） |
| コミットタイミング | git add後、ユーザが手動でgit commitを実行 |
| ロールバック条件 | 失敗時は手動でのファイル削除・Makefile復元が必要 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（1回の実行で1つのstdlibを作成） |
| 目標処理時間 | 数秒以内（対話入力時間を除く） |
| メモリ使用量上限 | 最小限（シェルスクリプトのため） |

## 排他制御

同時実行は想定されていない。同一のstdlib名で複数回実行した場合、mkdirが失敗するかMakefileに重複エントリが追加される可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Julia Stdlib Creator Helper Wizard" ヘッダー |
| 進捗ログ | 処理中 | 該当なし |
| 終了ログ | バッチ終了時 | "Wizard finished." および後続手順の案内 |
| エラーログ | エラー発生時 | シェルのエラーメッセージ（set -eu による自動出力） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

本バッチは開発者が手動で実行するユーティリティスクリプトであり、監視・アラートは設定されていない。

## 備考

- 本スクリプトは対話形式（`read -p`）で動作するため、自動化パイプラインでの使用には適さない
- 外部stdlib追加時のGit URL形式は `https://github.com/{USER}/{NAME}.jl.git` に固定されている
- Tar URL形式は `https://api.github.com/repos/{USER}/{NAME}.jl/tarball/$1` に固定されている
- スクリプト終了後、開発者は手動でtest/precompile.jl、test/choosetests.jl、base/sysimg.jlを更新する必要がある
- ファイルパス: `contrib/new-stdlib.sh`
