# バッチ設計書 22-print_sorted_stdlibs.jl

## 概要

本ドキュメントは、Juliaの標準ライブラリを依存関係順にソートして出力するJuliaスクリプト `contrib/print_sorted_stdlibs.jl` のバッチ設計書である。

### 本バッチの処理概要

本バッチは、Juliaの標準ライブラリ群の依存関係を解析し、依存関係の深さ順（浅い順）かつアルファベット順にソートした一覧を標準出力に出力するスクリプトである。出力はbase/sysimg.jlなどに貼り付け可能な形式で生成される。

**業務上の目的・背景**：Juliaのシステムイメージ（sysimg.jl）では、標準ライブラリを依存関係の順序に従って正しく並べる必要がある。手動で依存関係を解析してソートすることは、stdlibの数が多い場合に非現実的であり、誤りも生じやすい。本スクリプトはProject.tomlから依存関係を自動解析し、正しいソート順を提供する。

**バッチの実行タイミング**：標準ライブラリの追加・変更時、またはsysimg.jlのstdlib順序を更新する必要がある際に開発者が手動で実行する。

**主要な処理内容**：
1. 標準ライブラリディレクトリ内の全Project.tomlを読み込み、各stdlibの依存関係を解析
2. 依存関係の深さ（depth）を再帰的に計算
3. depth順、同一depthの場合はアルファベット順にソート
4. オプションに応じてJLLパッケージやsysimageパッケージをフィルタリング
5. ソート済みリストをJulia配列リテラル形式で標準出力に表示

**前後の処理との関連**：本スクリプトの出力は、base/sysimg.jlのstdlibs配列定義に使用される。新しいstdlibを追加（No.21 new-stdlib.sh）した後に本スクリプトを実行し、正しい順序を確認することが推奨される。

**影響範囲**：本スクリプト自体はファイルを変更しない読み取り専用のユーティリティである。出力結果は開発者が手動でsysimg.jl等に反映する。

## バッチ種別

データ集計 / ユーティリティ（読み取り専用解析）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（stdlib変更時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Julia実行環境 | juliaコマンドが利用可能であること |
| stdlibディレクトリ | ビルド済みまたはソースツリーのstdlibディレクトリが存在すること |
| TOMLパッケージ | Julia標準のTOMLパッケージが利用可能であること |

### 実行可否判定

stdlibディレクトリが存在し、Project.tomlファイルが読み込み可能であれば実行可能。依存関係の循環が存在する場合はdepth計算が100回のイテレーションで収束せずエラーとなる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| stdlib_dir | 文字列 | No | `usr/share/julia/stdlib/` | 標準ライブラリのディレクトリパス（第1引数） |
| --exclude-jlls | フラグ | No | false | JLLパッケージを出力から除外 |
| --exclude-sysimage | フラグ | No | false | システムイメージに含まれるパッケージを除外 |
| --only-sysimg | フラグ | No | false | システムイメージに含まれるパッケージのみ出力 |
| --help / -h | フラグ | No | false | 使用方法を表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| stdlib/*/Project.toml | TOML | 各stdlibのパッケージ名と依存関係の定義 |
| Base.loaded_modules | Julia内部 | sysimageフィルタリング時に使用するロード済みモジュール一覧 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ソート済みstdlibリストをJulia配列リテラル形式で出力 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし（標準出力のみ） |
| 出力先 | stdout |
| 文字コード | UTF-8 |
| 区切り文字 | 改行 |

出力形式の例：
```julia
    # Stdlibs sorted in dependency, then alphabetical, order by contrib/print_sorted_stdlibs.jl
    stdlibs = [
        # No dependencies
        :Artifacts,
        :Base64,
        ...
        # 1-depth packages
        :Logging,
        ...
    ]
```

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ --help, --exclude-jlls, --exclude-sysimage, --only-sysimg フラグをチェック
2. stdlibディレクトリの特定
   └─ 引数またはデフォルトパスからディレクトリを決定。vX.Yサブディレクトリの自動検出
3. Project.tomlの読み込み
   └─ stdlibディレクトリ内の全Project.tomlをTOML.parsefileで解析
4. 依存関係マップの構築
   └─ 各パッケージの名前とdeps（依存先パッケージ名のSet）をDictに格納
5. 依存関係深さの計算
   └─ project_depth関数で再帰的にdepthを算出（最大100イテレーション）
6. ソート
   └─ depth昇順、同一depthの場合はパッケージ名のアルファベット順
7. フィルタリング
   └─ --exclude-jlls, --exclude-sysimage, --only-sysimg に応じて結果をフィルタ
8. 出力
   └─ ソート済みリストをJulia配列リテラル形式でprintln
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[コマンドライン引数解析]
    B --> C[stdlibディレクトリ特定]
    C --> D[全Project.toml読み込み]
    D --> E[依存関係マップ構築]
    E --> F[依存関係深さ計算]
    F --> G{depth計算収束?}
    G -->|Yes| H[depth順+アルファベット順ソート]
    G -->|No（100回超）| I[エラー終了]
    H --> J{JLLフィルタ?}
    J -->|--exclude-jlls| K[JLLパッケージ除外]
    J -->|適用なし| L{sysimageフィルタ?}
    K --> L
    L -->|--only-sysimg| M[sysimage外パッケージ除外]
    L -->|--exclude-sysimage| N[sysimageパッケージ除外]
    L -->|適用なし| O[ソート済みリスト出力]
    M --> O
    N --> O
    O --> P[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | 該当なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 該当なし | 収束エラー | 依存関係の深さ計算が100イテレーションで収束しない場合 | 循環依存の解消が必要。error("Failed to converge...")が発生 |
| 該当なし | ファイル読込エラー | Project.tomlが不正な形式の場合 | TOML.parsefileの例外。対象ファイルを修正 |
| 該当なし | 警告 | --only-sysimgと--exclude-sysimageが同時指定 | stderrに警告を出力し、--only-sysimgを優先 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

本スクリプトは読み取り専用であるため、障害時に復旧作業は不要。エラーメッセージに基づいて入力データ（Project.toml）や依存関係を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十件（stdlibの数に依存） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小限（Project.tomlの解析データのみ） |

## 排他制御

読み取り専用スクリプトのため排他制御は不要。同時実行しても問題は発生しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし | 該当なし |
| 進捗ログ | なし | 該当なし |
| 終了ログ | なし | 該当なし |
| エラーログ | エラー発生時 | 収束エラー、警告メッセージ（stderr） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

本バッチは開発者ユーティリティであり、監視対象外である。

## 備考

- depth計算アルゴリズムは幅優先探索に類似しており、各イテレーションで依存先の依存先を展開する
- depth=0は依存関係がないパッケージ、depth=Nは最大N段の依存チェーンを持つパッケージを意味する
- `--only-sysimg` と `--exclude-sysimage` は排他的オプションであり、両方指定された場合は `--only-sysimg` が優先される（stderrに警告出力）
- デフォルトのstdlibディレクトリは `usr/share/julia/stdlib/` 配下で、`vX.Y` 形式のサブディレクトリが1つだけ存在する場合は自動的にその中に入る
- ファイルパス: `contrib/print_sorted_stdlibs.jl`
