# バッチ設計書 23-docs（HTML生成）

## 概要

本ドキュメントは、Documenterを使用してJuliaドキュメントのHTMLを生成するMakefileターゲット `make docs`（`make html`）のバッチ設計書である。

### 本バッチの処理概要

本バッチは、Juliaプロジェクトの公式ドキュメントをDocumenter.jlを使用してHTML形式で生成する。マニュアル、Base API、標準ライブラリ、開発者ドキュメントを含む包括的なHTMLドキュメントセットを生成し、Webブラウザで閲覧可能な形式で出力する。

**業務上の目的・背景**：Juliaの公式ドキュメントは、ユーザガイド、APIリファレンス、開発者ドキュメントなど多岐にわたる。これらのドキュメントをマークダウンソースから自動的にHTML形式に変換し、一貫したスタイルとナビゲーションを持つWebサイトとして公開する必要がある。本バッチはこのドキュメント生成プロセスを自動化する。

**バッチの実行タイミング**：リリースプロセスの一部として実行されるほか、ドキュメントの変更確認のために開発者が手動で実行する。CIパイプラインでも自動実行される。

**主要な処理内容**：
1. UnicodeDataファイルのダウンロードとチェックサム検証（deps）
2. Documenter.jlプロジェクトの依存関係インストール
3. 標準ライブラリドキュメントのシンボリックリンク作成
4. NEWS.mdのマークダウン変換（GitHub issue番号リンクの追加）
5. 全モジュール（Base, Core, 標準ライブラリ）のドキュメント生成
6. 外部stdlibのソースリンクURLの修正（JuliaLang/julia#43199対応）
7. オプションでデプロイ（CI環境のみ）

**前後の処理との関連**：ビルドプロセス（Juliaの実行バイナリ）が完了している必要がある。リリースプロセスにおいてはrelease-candidate（No.10）ターゲットから呼び出される。デプロイ時はdocs.julialang.orgリポジトリにプッシュされる。

**影響範囲**：doc/_build/html/en/ ディレクトリにHTML出力が生成される。デプロイ時はdocs.julialang.org GitHubリポジトリに影響する。

## バッチ種別

ドキュメント生成 / レポート生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ドキュメント更新時、リリース時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行（make docs / make html）またはCI自動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Julia実行バイナリ | ビルド済みのJulia実行ファイルが利用可能であること |
| ネットワーク接続 | UnicodeDataファイルのダウンロードに必要（初回のみ） |
| Documenter.jl | doc/依存関係としてインストールされること（自動） |
| Make.inc | Juliaビルドシステムの設定ファイルが存在すること |

### 実行可否判定

Julia実行バイナリが存在し、依存関係（UnicodeData.txt）が取得可能であれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| linkcheck | 文字列 | No | 未設定 | trueを指定するとリンクチェックを実行 |
| doctest | 文字列 | No | 未設定 | true/fix/onlyを指定するとdoctest検証を実行 |
| revise | 文字列 | No | 未設定 | trueを指定するとRevise.jlを使用して変更を反映 |
| texplatform | 文字列 | No | native | PDF生成時のTeX処理プラットフォーム |
| buildroot | パス | No | ソースツリー | ビルドルートディレクトリ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| doc/src/*.md | Markdown | ドキュメントソースファイル群 |
| stdlib/*/docs/src/index.md | Markdown | 標準ライブラリの個別ドキュメント |
| NEWS.md | Markdown | リリースノート |
| deps/srccache/UnicodeData-*.txt | テキスト | Unicodeデータファイル |
| stdlib/*.version | Makefile変数 | 外部stdlibのバージョン情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| doc/_build/html/en/ | HTML/CSS/JS | 生成されたHTMLドキュメント一式 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Documenterにより自動命名 |
| 出力先 | doc/_build/html/en/ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし（HTML形式） |

## 処理フロー

### 処理シーケンス

```
1. 依存関係の準備（deps）
   ├─ UnicodeDataファイルのダウンロード（未取得の場合）
   └─ チェックサム検証
2. Julia実行環境の準備
   ├─ Documenter.jlプロジェクトのactivateとinstantiate
   └─ 標準ライブラリモジュールのusing
3. ドキュメントソースの準備
   ├─ stdlibドキュメントのシンボリックリンク作成
   ├─ NEWS.mdのマークダウン変換（issue番号リンク追加）
   └─ 外部stdlibリモート情報の解析（.versionファイル）
4. Documenter.makedocs実行
   ├─ 全モジュール（Main, Base, Core, 標準ライブラリ）のドキュメント生成
   ├─ ページ構成（Manual, Base, Standard Library, Developer Documentation）
   └─ HTML形式でのレンダリング（prettyurls, canonical, analyticsなどの設定）
5. 外部stdlibリンクの修正
   └─ 生成済みHTMLファイル内のGitHub URLを正しいリポジトリURLに書き換え
6. 完了メッセージ出力
```

### フローチャート

```mermaid
flowchart TD
    A[make html 実行] --> B[deps: UnicodeData取得・検証]
    B --> C[Documenter.jl依存関係インストール]
    C --> D[stdlibドキュメントのsymlink作成]
    D --> E[NEWS.md変換]
    E --> F[外部stdlibリモート情報解析]
    F --> G[Documenter.makedocs実行]
    G --> H[HTMLレンダリング]
    H --> I[外部stdlibリンク修正]
    I --> J{deploy引数あり?}
    J -->|Yes| K[docs.julialang.orgへデプロイ]
    J -->|No| L[完了メッセージ出力]
    K --> L
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | 該当なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 該当なし | ダウンロードエラー | UnicodeDataファイルのダウンロード失敗 | ネットワーク接続を確認して再実行 |
| 該当なし | チェックサムエラー | UnicodeDataファイルのチェックサム不一致 | ファイルを削除して再ダウンロード |
| 該当なし | パッケージエラー | Documenter.jlの依存関係解決失敗 | deps/jlutilities/documenter/の内容を確認 |
| 該当なし | makedocsエラー | ドキュメント生成中のエラー（不正なdocstring等） | エラーメッセージに基づいてソースファイルを修正 |
| 該当なし | .versionパースエラー | 外部stdlibの.versionファイルが不正 | @warnが出力される。.versionファイルの形式を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動再実行が必要） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

`make clean` を実行して生成物を削除し、再度 `make html` を実行する。dep関連のエラーの場合はdeps/srccacheの該当ファイルを削除してから再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル生成処理） |
| コミットタイミング | 該当なし |
| ロールバック条件 | make cleanで生成物を削除可能 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百ページのドキュメント |
| 目標処理時間 | 数分〜十数分（環境に依存） |
| メモリ使用量上限 | 数GB（全stdlibモジュールのロードが必要） |

## 排他制御

同じbuildディレクトリに対する同時実行は想定されていない。並行実行するとファイルの競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Building HTML documentation." |
| 進捗ログ | 処理中 | Documenterからの進捗メッセージ |
| 終了ログ | バッチ終了時 | "Build finished. The HTML pages are in _build/html." |
| エラーログ | エラー発生時 | Documenterからのエラー/警告メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| CI実行結果 | ビルド失敗 | GitHub Actions / BuildKite |

## 備考

- Documenter.jlのHTML出力は `prettyurls`、`canonical` URL、Google Analytics等を設定可能
- `deploy` 引数を指定するとdocs.julialang.orgリポジトリへの自動デプロイが実行される
- デプロイはtagged commit、masterブランチ、release-*ブランチに応じてバージョニングされる
- Reviseモードを使用するとシステムイメージの再ビルドなしにドキュメント変更を反映可能
- 外部stdlibのソースリンクは生成後にURL書き換え処理で正しいリポジトリにリダイレクトされる
- ページのサイズ閾値は800KiB（警告は200KiB以上）に設定されている
- ファイルパス: `doc/Makefile`（htmlターゲット）、`doc/make.jl`（メインスクリプト）
