# バッチ設計書 24-docs（PDF生成）

## 概要

本ドキュメントは、Documenterを使用してJuliaドキュメントのPDFを生成するMakefileターゲット `make -C doc pdf` のバッチ設計書である。

### 本バッチの処理概要

本バッチは、JuliaプロジェクトのドキュメントをDocumenter.jlのLaTeXバックエンドを使用してPDF形式で生成する。HTML生成（No.23）と同じソースファイルを使用するが、出力形式としてLaTeXを経由してPDFを生成する点が異なる。

**業務上の目的・背景**：Juliaのドキュメントをオフライン閲覧や印刷用途のために、PDF形式でも提供する必要がある。Documenter.jlのLaTeXバックエンドを利用することで、マークダウンソースから高品質なPDFドキュメントを自動生成する。

**バッチの実行タイミング**：リリース時、またはPDF形式のドキュメントが必要な際に開発者が手動で実行する。

**主要な処理内容**：
1. UnicodeDataファイルのダウンロードとチェックサム検証（depsターゲット）
2. Documenter.jlプロジェクトの依存関係インストール
3. 標準ライブラリドキュメントのシンボリックリンク作成
4. NEWS.mdのマークダウン変換
5. Documenter.LaTeX形式でのドキュメント生成（makedocs）
6. LaTeXからPDFへの変換

**前後の処理との関連**：HTML生成（No.23）と同じ前提条件を共有する。ビルド済みのJulia実行バイナリが必要。リリースプロセスの一部としてrelease-candidateターゲットから呼び出される場合がある。

**影響範囲**：doc/_build/pdf/en/ ディレクトリにPDF出力が生成される。

## バッチ種別

ドキュメント生成 / レポート生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時、PDF必要時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行（make -C doc pdf） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Julia実行バイナリ | ビルド済みのJulia実行ファイルが利用可能であること |
| ネットワーク接続 | UnicodeDataファイルのダウンロードに必要（初回のみ） |
| Documenter.jl | 依存関係として自動インストール |
| LaTeX環境 | PDFコンパイルのためにLaTeXディストリビューションが必要（またはDocker経由） |
| Make.inc | Juliaビルドシステムの設定ファイルが存在すること |

### 実行可否判定

Julia実行バイナリとLaTeX環境（nativeまたはDocker）が利用可能であれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| texplatform | 文字列 | No | native | LaTeXプラットフォーム。"docker"を指定するとDocker経由でLaTeX処理 |
| linkcheck | 文字列 | No | 未設定 | trueを指定するとリンクチェックを実行 |
| doctest | 文字列 | No | 未設定 | true/fix/onlyを指定するとdoctest検証を実行 |
| revise | 文字列 | No | 未設定 | trueを指定するとRevise.jlを使用 |
| buildroot | パス | No | ソースツリー | ビルドルートディレクトリ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| doc/src/*.md | Markdown | ドキュメントソースファイル群 |
| stdlib/*/docs/src/index.md | Markdown | 標準ライブラリの個別ドキュメント |
| NEWS.md | Markdown | リリースノート |
| deps/srccache/UnicodeData-*.txt | テキスト | Unicodeデータファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| doc/_build/pdf/en/ | PDF/LaTeX | 生成されたPDFドキュメント |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Documenterにより自動命名 |
| 出力先 | doc/_build/pdf/en/ |
| 文字コード | UTF-8（LaTeXソース） |
| 区切り文字 | 該当なし（PDF形式） |

## 処理フロー

### 処理シーケンス

```
1. 依存関係の準備（deps）
   ├─ UnicodeDataファイルのダウンロード（未取得の場合）
   └─ チェックサム検証
2. Julia実行環境の準備
   ├─ Documenter.jlプロジェクトのactivateとinstantiate
   └─ 標準ライブラリモジュールのusing
3. ドキュメントソースの準備
   ├─ stdlibドキュメントのシンボリックリンク作成
   └─ NEWS.mdのマークダウン変換
4. PDF用ページ構成の設定
   └─ PAGES定義（Manual, Base, Standard Library, Developer Documentation + NEWS.md）
5. Documenter.makedocs実行（LaTeX形式）
   ├─ Documenter.LaTeXフォーマットの設定（platform: native/docker）
   └─ LaTeXソースの生成とPDFコンパイル
6. 完了メッセージ出力
```

### フローチャート

```mermaid
flowchart TD
    A[make pdf 実行] --> B[deps: UnicodeData取得・検証]
    B --> C[Documenter.jl依存関係インストール]
    C --> D[stdlibドキュメントsymlink作成]
    D --> E[NEWS.md変換]
    E --> F[PDF用ページ構成設定]
    F --> G[Documenter.makedocs実行 LaTeX形式]
    G --> H{texplatform}
    H -->|native| I[ネイティブLaTeXでPDFコンパイル]
    H -->|docker| J[Docker内LaTeXでPDFコンパイル]
    I --> K[完了メッセージ出力]
    J --> K
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | 該当なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 該当なし | LaTeXエラー | LaTeXコンパイルに失敗した場合 | LaTeX環境の確認、またはtexplatform=dockerでの実行 |
| 該当なし | ダウンロードエラー | UnicodeDataのダウンロード失敗 | ネットワーク接続を確認して再実行 |
| 該当なし | makedocsエラー | ドキュメント生成中のエラー | エラーメッセージに基づいてソースを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動再実行が必要） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

`make -C doc clean` を実行して生成物を削除し、再度実行する。LaTeX関連のエラーの場合はLaTeX環境の確認、またはDocker経由での実行を試みる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル生成処理） |
| コミットタイミング | 該当なし |
| ロールバック条件 | make cleanで生成物を削除可能 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百ページのドキュメント |
| 目標処理時間 | 十数分〜数十分（LaTeXコンパイルを含む） |
| メモリ使用量上限 | 数GB（Julia+LaTeX処理） |

## 排他制御

同じbuildディレクトリに対する同時実行は想定されていない。HTML生成（No.23）との同時実行も避けるべきである。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Building PDF documentation." |
| 進捗ログ | 処理中 | Documenter/LaTeXからの進捗メッセージ |
| 終了ログ | バッチ終了時 | "Build finished." |
| エラーログ | エラー発生時 | Documenter/LaTeXからのエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

## 備考

- PDF生成ではHTML生成と異なるPAGES構成が使用される（index.mdがManualセクションに含まれ、NEWS.mdがDevDocsに含まれる）
- texplatformオプションで"docker"を指定すると、DockerコンテナでLaTeXコンパイルが実行される
- PDF生成にはHTML生成よりも多くの時間とリソースが必要
- HTML生成（No.23）と共通のmake.jlスクリプトを使用し、"pdf"引数の有無で出力形式を切り替える
- ファイルパス: `doc/Makefile`（pdfターゲット）、`doc/make.jl`（メインスクリプト）
