# バッチ設計書 26-testall

## 概要

本ドキュメントは、Juliaの全テストスイートを一括実行するMakefileターゲット `make testall` のバッチ設計書である。

### 本バッチの処理概要

本バッチは、Juliaの全テストスイートを一括で実行する。実行前にシステムイメージの検証（別のシステムイメージでのJulia起動テスト）を行い、その後テストランナー（test/runtests.jl）を通じて全テストを実行する。ホワイトスペースチェックも前提として実行される。

**業務上の目的・背景**：Juliaの品質保証プロセスにおいて、全テストスイートの一括実行は、リリース前やメジャーな変更後にシステム全体の整合性を検証するために不可欠である。本バッチはこの包括的な検証を単一コマンドで実行可能にする。

**バッチの実行タイミング**：リリース前の品質検証時、またはシステム全体に影響する変更後に実行する。CIパイプラインでも使用される。日常的な開発では個別テスト（No.27 test）の使用が推奨される。

**主要な処理内容**：
1. ホワイトスペースチェックの実行（check-whitespace依存）
2. Julia実行バイナリのビルド確認（JULIA_BUILD_MODE依存）
3. システムイメージの検証（sys.soを別名でコピーし、そのイメージでJuliaを起動して正常動作を確認）
4. 検証用イメージの削除
5. test/runtests.jl を通じた全テスト（all）の実行

**前後の処理との関連**：Juliaのビルド（make）が完了していることが前提。check-whitespace（No.16）が事前に実行される。testallはrelease-candidate（No.10）ターゲットからも呼び出される。

**影響範囲**：テスト実行のみであり、ソースコードやビルド成果物を変更しない。ただしシステムイメージの一時コピー（local.so/local.dylib）が一時的に作成される。

## バッチ種別

テスト実行 / 品質検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース前、CI実行時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行（make testall）またはCI自動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Julia実行バイナリ | ビルド済みのJulia実行ファイルが存在すること |
| システムイメージ | sys.so / sys.dylibが存在すること |
| テストスイート | test/ディレクトリにテストファイルが存在すること |
| check-whitespace | ホワイトスペースチェックが成功すること |

### 実行可否判定

Julia実行バイナリとシステムイメージが正常にビルドされていれば実行可能。check-whitespaceが失敗した場合はテスト実行に進まない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| JULIA_BUILD_MODE | 文字列 | No | release | ビルドモード（release/debug） |
| JULIA_CPU_THREADS | 数値 | No | システム依存 | テスト実行時のCPUスレッド数（testall1の場合は1） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| test/runtests.jl | Julia | テストランナースクリプト |
| test/*.jl | Julia | 個別テストファイル群 |
| build_private_libdir/sys.* | バイナリ | システムイメージファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力/エラー出力 | テキスト | テスト実行結果（成功/失敗/スキップ） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし（一時ファイルlocal.soは処理中に作成・削除） |
| 出力先 | stdout / stderr |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. check-whitespace実行
   └─ ソースコードのホワイトスペースエラーを検出
2. Julia実行バイナリの確認
   └─ JULIA_BUILD_MODEに応じたビルドターゲットの確認
3. システムイメージの検証
   ├─ sys.soをlocal.soとしてコピー
   ├─ julia -J local.so -e 'true' を実行して起動テスト
   └─ local.soを削除
4. 全テスト実行
   └─ test/Makefileのallターゲットを実行
     └─ test/runtests.jl を --check-bounds=yes --startup-file=no --depwarn=error で実行
5. テスト結果の報告
```

### フローチャート

```mermaid
flowchart TD
    A[make testall 実行] --> B[check-whitespace]
    B --> C{whitespace OK?}
    C -->|Yes| D[ビルド確認]
    C -->|No| E[エラー終了]
    D --> F[sys.so を local.so にコピー]
    F --> G[julia -J local.so -e 'true' 実行]
    G --> H{起動成功?}
    H -->|Yes| I[local.so 削除]
    H -->|No| J[エラー終了]
    I --> K[test/runtests.jl all 実行]
    K --> L[テスト結果報告]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | 該当なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 該当なし | whitespace失敗 | ホワイトスペースエラーが検出された場合 | make fix-whitespaceで修正後再実行 |
| 該当なし | sysimage検証失敗 | 別名システムイメージでのJulia起動が失敗 | システムイメージの再ビルド |
| 該当なし | テスト失敗 | 個別テストケースの失敗 | 失敗テストを修正後再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

テスト失敗の場合は個別テストを `make test-<name>` で再実行して原因を特定する。システムイメージ検証失敗の場合はJuliaを再ビルドする。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（テスト実行のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百のテストケース |
| 目標処理時間 | 数十分〜数時間（環境・テスト数に依存） |
| メモリ使用量上限 | 数GB（並列テスト実行に依存） |

## 排他制御

同一ビルドディレクトリでの同時実行は想定されていない。local.soの一時ファイル作成があるため、並行実行でファイル競合が発生する。`testall1` ターゲットを使用するとシングルスレッド（JULIA_CPU_THREADS=1）で実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | テストランナーの開始メッセージ |
| 進捗ログ | 処理中 | 各テストの実行状況と結果 |
| 終了ログ | バッチ終了時 | テスト結果サマリー |
| エラーログ | エラー発生時 | 失敗テストの詳細情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| CI実行結果 | テスト失敗 | GitHub Actions / BuildKite |

## 備考

- `testall1` ターゲットを使用するとCPUスレッド数を1に制限して実行可能（デバッグ用）
- テスト実行時のJuliaオプション: `--check-bounds=yes --startup-file=no --depwarn=error`
- テストスクリプトオプション: `--buildroot=<BUILDROOT>`
- システムイメージ検証（local.soテスト）はtestallのみの機能であり、testターゲットでは実行されない
- 環境変数 `JULIA_TEST_FAILFAST=1` を設定するとテスト失敗時に即座に停止可能
- ファイルパス: `Makefile`（testallターゲット）、`test/Makefile`（allターゲット）、`test/runtests.jl`
