# バッチ設計書 27-test

## 概要

本ドキュメントは、ホワイトスペースチェック後にデフォルトテストを実行するMakefileターゲット `make test` のバッチ設計書である。

### 本バッチの処理概要

本バッチは、Juliaのデフォルトテストスイートを実行する。全テスト（testall、No.26）とは異なり、デフォルトテストセット（default）のみを実行する。また、個別テスト実行（`make test-<name>`）やReviseモードでのテスト実行（`make test-revise-<name>`）もサポートする。

**業務上の目的・背景**：日常的な開発において、コード変更の影響を迅速に確認するためにデフォルトテストセットの実行が頻繁に必要となる。全テスト実行（testall）は時間がかかるため、開発サイクルの中ではデフォルトテストや個別テストの実行が推奨される。本バッチはこれらの効率的なテスト実行手段を提供する。

**バッチの実行タイミング**：コード変更後の検証として随時実行する。CIパイプラインでも使用される。AGENTS.mdでは、テスト変更時に `make test-revise-<name>` での検証が推奨されている。

**主要な処理内容**：
1. ホワイトスペースチェック（check-whitespace依存）
2. Julia実行バイナリの確認（JULIA_BUILD_MODE依存）
3. test/runtests.jl を通じたデフォルトテスト（default）の実行
4. 個別テスト実行時は指定されたテスト名をruntests.jlに渡す
5. Reviseモード時はRevise.jlを使用してソース変更を反映

**前後の処理との関連**：Juliaのビルドが完了していることが前提。check-whitespace（No.16）が事前に実行される。ソースコード変更後のシステムイメージ再ビルド直後にはtest-revise-*の使用が推奨される（Makefileに100秒以内のヒント表示あり）。

**影響範囲**：テスト実行のみであり、ソースコードやビルド成果物を変更しない。

## バッチ種別

テスト実行 / 品質検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（コード変更時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行（make test / make test-<name>）またはCI自動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Julia実行バイナリ | ビルド済みのJulia実行ファイルが存在すること |
| システムイメージ | sys.so / sys.dylibが存在すること |
| テストスイート | test/ディレクトリにテストファイルが存在すること |

### 実行可否判定

Julia実行バイナリが正常にビルドされており、テストファイルが存在すれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| テスト名 | 文字列 | No | default | test-<name>形式で指定。省略時はdefaultテスト |
| JULIA_BUILD_MODE | 文字列 | No | release | ビルドモード（release/debug） |
| JULIA_TEST_FAILFAST | 環境変数 | No | 未設定 | 1を設定するとテスト失敗時に即座に停止 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| test/runtests.jl | Julia | テストランナースクリプト |
| test/*.jl | Julia | 個別テストファイル群 |
| test/compiler/*.jl | Julia | コンパイラ関連テスト |
| test/Compiler/*.jl | Julia | Compilerモジュール関連テスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力/エラー出力 | テキスト | テスト実行結果（成功/失敗/スキップ） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | stdout / stderr |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. check-whitespace実行
   └─ ソースコードのホワイトスペースエラーを検出
2. Julia実行バイナリの確認
   └─ JULIA_BUILD_MODEに応じたビルドターゲットの確認
3a. defaultテスト実行（make test）
   └─ test/Makefileのdefaultターゲットを実行
3b. 個別テスト実行（make test-<name>）
   ├─ sysimageが最近（100秒以内に）再ビルドされた場合はtest-revise-*のヒントを表示
   └─ test/Makefileの<name>ターゲットを実行
3c. Reviseテスト実行（make test-revise-<name>）
   └─ test/Makefileのrevise-<name>ターゲットを実行（--reviseフラグ付き）
4. テスト結果の報告
```

### フローチャート

```mermaid
flowchart TD
    A[make test 実行] --> B[check-whitespace]
    B --> C{whitespace OK?}
    C -->|Yes| D[ビルド確認]
    C -->|No| E[エラー終了]
    D --> F{実行形式}
    F -->|make test| G[defaultテスト実行]
    F -->|make test-name| H{sysimage最近再ビルド?}
    F -->|make test-revise-name| I[--revise付きテスト実行]
    H -->|100秒以内| J[test-revise-*ヒント表示]
    H -->|それ以外| K[指定テスト実行]
    J --> K
    G --> L[テスト結果報告]
    K --> L
    I --> L
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | 該当なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 該当なし | whitespace失敗 | ホワイトスペースエラー検出 | make fix-whitespaceで修正 |
| 該当なし | テスト失敗 | テストケースの失敗 | 失敗テストの原因調査と修正 |
| 該当なし | テスト不存在 | 指定されたテスト名が存在しない | テスト名の確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

テスト失敗時は `JULIA_TEST_FAILFAST=1` を設定して個別テストを再実行し、最初の失敗を特定する。Reviseモードを使用すると、再ビルドせずにソース変更をテストに反映可能。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（テスト実行のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | テストセットに依存（defaultまたは個別） |
| 目標処理時間 | 個別テスト: 数秒〜数分、default: 数分〜数十分 |
| メモリ使用量上限 | テスト内容に依存 |

## 排他制御

同一ビルドディレクトリでの同時実行は推奨されない。異なるテスト名であれば問題が生じない場合もあるが、共有リソースへのアクセスで競合する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | テストランナーの開始メッセージ |
| ヒントログ | 個別テスト実行時 | sysimageが最近再ビルドされた場合のtest-revise-*推奨メッセージ |
| 進捗ログ | 処理中 | 各テストの実行状況と結果 |
| 終了ログ | バッチ終了時 | テスト結果サマリー |
| エラーログ | エラー発生時 | 失敗テストの詳細情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| CI実行結果 | テスト失敗 | GitHub Actions / BuildKite |

## 備考

- `make test` はdefaultテストセットのみ実行し、`make testall`（No.26）は全テストを実行する
- `make test-<name>` で個別テストを実行可能。テスト名はtest/ディレクトリ内のファイル名（拡張子なし）
- `make test-revise-<name>` でRevise.jlを使用したテスト実行が可能（システムイメージ再ビルド不要）
- sysimageが100秒以内に再ビルドされた場合、`test-revise-*` の使用を推奨するヒントメッセージが表示される
- テストグループ: unicode, strings, compiler, Compiler, JuliaSyntax, JuliaLowering
- テスト実行時のJuliaオプション: `--check-bounds=yes --startup-file=no --depwarn=error`
- AGENTS.mdによると、テスト変更時は `make test-revise-<name>` で検証し、新規テストは既存ファイルに追加することが推奨される
- ファイルパス: `Makefile`（test/test-%/test-revise-%ターゲット）、`test/Makefile`
