# バッチ設計書 28-fixup-rpath.sh

## 概要

本ドキュメントは、FreeBSD/Linux環境でバイナリファイルのRPATH（ランタイムライブラリパス）からビルドディレクトリのパスを除去するシェルスクリプト `contrib/fixup-rpath.sh` のバッチ設計書である。

### 本バッチの処理概要

本バッチは、ビルドプロセスで生成されたバイナリファイルに埋め込まれたRPATH（動的ライブラリの検索パス）から、ビルドディレクトリ固有のパスを除去する。これにより、ビルド環境に依存しないポータブルなバイナリ配布物を作成する。

**業務上の目的・背景**：Juliaのビルドプロセスでは、リンク時にビルドディレクトリの絶対パスがバイナリのRPATHに埋め込まれる。このパスはビルドマシン固有であり、配布バイナリに含まれるとユーザ環境で不正なパスを参照する原因となる。本スクリプトはRPATHからビルドディレクトリパスを除去し、残りの有効なRPATHエントリのみを保持する。

**バッチの実行タイミング**：バイナリ配布物の作成時（binary-dist、No.11など）にビルドシステムから呼び出される。開発者が直接実行することもある。

**主要な処理内容**：
1. 指定ディレクトリ内の全実行可能ファイルを走査
2. 各ファイルのRPATHをpatchelfで取得
3. RPATHにビルドディレクトリパスが含まれるかチェック
4. ビルドディレクトリパスをRPATHから除去し、残りのパスで再設定

**前後の処理との関連**：Juliaのビルドが完了した後、バイナリ配布物の作成プロセスの一部として実行される。binary-dist（No.11）やインストールプロセスで使用される。

**影響範囲**：指定ディレクトリ内の実行可能ファイルのRPATHメタデータが変更される。ファイルの実行コード自体は変更されない。

## バッチ種別

バイナリ修正 / ポストビルド処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（バイナリ配布物作成時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | ビルドシステムからの呼び出し / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| patchelf | RPATHの読み取り・設定に使用するツールがインストールされていること |
| ビルド完了 | 対象ディレクトリにビルド済みバイナリが存在すること |
| Linux/FreeBSD | ELF形式のバイナリを対象とするため、Linux/FreeBSD環境が必要 |

### 実行可否判定

引数が3つ（patchelfパス、処理対象ディレクトリ、ビルドlibdir）であること。不足時はUsageメッセージを表示して終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| patchelf path | パス | Yes | なし | patchelfコマンドのパス（第1引数） |
| directory to process | パス | Yes | なし | 処理対象のディレクトリパス（第2引数） |
| build libdir | パス | Yes | なし | ビルドライブラリディレクトリのパス（除去対象）（第3引数） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 対象ディレクトリ内のバイナリ | ELF | 実行可能ファイル（-perm -111） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 対象バイナリ | ELF | RPATHが修正されたバイナリファイル |
| 標準出力 | テキスト | 各ファイルのRPATH変更ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力と同一（インプレース修正） |
| 出力先 | 入力と同一ディレクトリ |
| 文字コード | 該当なし（バイナリ） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数バリデーション
   └─ 引数が3つであることを確認。不足時はUsage表示後exit 1
2. 対象ディレクトリ内の実行可能ファイル走査
   └─ find ${executable_dir} -type f -perm -111
3. 各ファイルの処理
   ├─ patchelf --print-rpath でRPATH取得
   ├─ RPATHにbuild_libdirが含まれるかgrep -Fでチェック
   ├─ 含まれない場合はスキップ
   ├─ build_libdirをRPATHから除去（tr, grepで処理）
   ├─ 末尾のコロンを除去
   ├─ "Setting RPATH for ..." のログ出力
   └─ patchelf --set-rpath で新しいRPATHを設定
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数3つ?}
    B -->|No| C[Usage表示・exit 1]
    B -->|Yes| D[対象ディレクトリ内ファイル走査]
    D --> E[次のファイルを取得]
    E --> F[RPATHを取得]
    F --> G{build_libdirを含む?}
    G -->|No| H[スキップ]
    G -->|Yes| I[build_libdirをRPATHから除去]
    I --> J[新しいRPATHを設定]
    J --> K[ログ出力]
    K --> L{次のファイルあり?}
    H --> L
    L -->|Yes| E
    L -->|No| M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | 該当なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数不足 | 引数が3つでない場合 | 正しい引数でスクリプトを再実行 |
| 該当なし | patchelfエラー | patchelfコマンドが失敗した場合 | patchelfのインストールを確認。対象ファイルの権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

patchelfの失敗時はバイナリが不正な状態になる可能性がある。再ビルドによる復旧が確実。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位（各バイナリを個別に処理） |
| コミットタイミング | 各ファイルの処理完了時 |
| ロールバック条件 | 再ビルドが必要（部分的な修正からの復旧は困難） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百のバイナリファイル |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 最小限（シェルスクリプト） |

## 排他制御

同一ディレクトリに対する同時実行は推奨されない。同じバイナリファイルに対する並行修正は未定義の動作を引き起こす可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし | 該当なし |
| 進捗ログ | 各ファイル処理時 | "Setting RPATH for ${lib} to '${new_rpath}'" |
| 終了ログ | なし | 該当なし |
| エラーログ | 引数不足時 | "Incorrect number of arguments" とUsage |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

## 備考

- patchelfはELF形式バイナリのRPATH操作に特化したツールであり、LinuxおよびFreeBSD環境で使用される
- RPATH除去はビルドディレクトリパスのみを対象とし、他の有効なRPATHエントリは保持される
- RPATHはコロン区切りであり、build_libdirの除去後にコロン区切りのリストとして再構成される
- 処理対象は `-perm -111` （実行可能ファイル）であり、共有ライブラリも含まれる
- ファイルパス: `contrib/fixup-rpath.sh`
