# バッチ設計書 29-fixup-libgfortran.sh

## 概要

本ドキュメントは、libgfortranおよび関連ライブラリ（libgcc_s、libquadmath）の配置と動的リンクを修正するシェルスクリプト `contrib/fixup-libgfortran.sh` のバッチ設計書である。

### 本バッチの処理概要

本バッチは、Juliaのバイナリ配布物に含まれるFortran関連ライブラリ（libgfortran、libgcc_s、libquadmath）を適切な場所にコピーし、それらへの動的リンクパスを修正する。LinuxとmacOSの両方に対応しており、プラットフォームに応じたリンケージ修正を行う。

**業務上の目的・背景**：JuliaはOpenBLAS等のFortranで書かれたライブラリに依存している。これらのライブラリはlibgfortranに動的リンクされるが、配布バイナリではlibgfortranの場所がユーザ環境に依存する。本スクリプトは必要なFortranランタイムライブラリをJuliaのprivate libdirにコピーし、リンケージをRPATH/install_name_toolで修正することで、自己完結的な配布物を実現する。

**バッチの実行タイミング**：バイナリ配布物の作成時にビルドシステムから呼び出される。

**主要な処理内容**：
1. private_libdir内のlapack/blas/openblas関連ライブラリからlibgfortranの依存関係を検出
2. libgfortranからlibgcc_s/libquadmathの依存関係を検出
3. 検出されたライブラリのSONAMEとディレクトリを収集
4. 必要なライブラリをprivate_libdirにコピー
5. macOSの場合はinstall_name_toolでidentityを@rpathに変更
6. 関連する全ライブラリのリンケージをプラットフォームに応じて修正（macOS: @rpath、Linux: $ORIGIN）

**前後の処理との関連**：Juliaのビルドが完了し、OpenBLAS等のライブラリがprivate_libdirに配置された後に実行される。binary-dist（No.11）やインストールプロセスの一部として使用される。

**影響範囲**：private_libdir内のライブラリファイル（コピーの追加、RPATH/install_nameの変更）に影響する。

## バッチ種別

バイナリ修正 / ライブラリ配置修正

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（バイナリ配布物作成時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | ビルドシステムからの呼び出し / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| gfortranコンパイラ | FC環境変数で指定（デフォルト: gfortran）。ライブラリパスの解決に使用 |
| patchelf（Linux） | PATCHELF環境変数で指定（デフォルト: patchelf）。Linuxでのリンケージ修正に使用 |
| install_name_tool（macOS） | macOS標準のバイナリ修正ツール |
| otool（macOS） | macOS標準のライブラリ検査ツール |
| private_libdir | Juliaのプライベートライブラリディレクトリが存在すること |

### 実行可否判定

第1引数にprivate_libdirが指定されていること。未指定の場合はUsageメッセージを表示して終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --verbose / -v | フラグ | No | false | デバッグメッセージの出力を有効化 |
| private_libdir | パス | Yes | なし | Juliaのプライベートライブラリディレクトリ |
| FC | 環境変数 | No | gfortran | Fortranコンパイラのパス |
| PATCHELF | 環境変数 | No | patchelf | patchelfコマンドのパス（Linux用） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| private_libdir/liblapack* | 共有ライブラリ | LAPACK関連ライブラリ |
| private_libdir/libopenblas* | 共有ライブラリ | OpenBLAS関連ライブラリ |
| private_libdir/libblas* | 共有ライブラリ | BLAS関連ライブラリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| private_libdir/libgfortran* | 共有ライブラリ | コピーされたlibgfortranライブラリ |
| private_libdir/libgcc_s* | 共有ライブラリ | コピーされたlibgcc_sライブラリ |
| private_libdir/libquadmath* | 共有ライブラリ | コピーされたlibquadmathライブラリ |
| 標準出力 | テキスト | コピー操作のログ |
| 標準エラー出力 | テキスト | デバッグメッセージ（--verbose時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | SONAMEに基づく命名 |
| 出力先 | private_libdir |
| 文字コード | 該当なし（バイナリ） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数・環境の初期化
   ├─ --verboseフラグの確認
   ├─ private_libdirの取得
   └─ プラットフォーム検出（Linux/Darwin）、SHLIB_EXTの設定
2. 依存関係の検出
   ├─ lapack/blas/openblasライブラリからlibgfortranの依存を検出
   │   ├─ Linux: patchelf --print-needed で検出
   │   └─ macOS: otool -L で検出
   ├─ libgfortranからlibgcc_sの依存を検出
   └─ libgfortranからlibquadmathの依存を検出
3. ディレクトリとSONAMEの収集
   ├─ 検出されたライブラリのディレクトリパスを収集
   ├─ @rpathや相対パスの場合はgfortranコンパイラに問い合わせ
   └─ SONAME一覧を重複排除
4. ライブラリのコピー
   ├─ 各SONAMEについてprivate_libdirに未存在の場合コピー
   ├─ chmod 755で権限設定
   └─ macOS: install_name_tool -idで@rpath/SONAMEにidentity変更
5. リンケージの修正
   ├─ libopenblas, libcholmod, liblapack, およびコピーしたSONAME群を対象
   ├─ 各ライブラリのincarnation（*.so, *.so.0 等）をすべて処理
   └─ change_linkage関数でリンケージを修正
       ├─ macOS: install_name_tool -change で@rpathリンクに変更
       └─ Linux: patchelf --set-rpath $ORIGIN に設定
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数・環境初期化]
    B --> C{private_libdir指定?}
    C -->|No| D[Usage表示・exit 1]
    C -->|Yes| E[プラットフォーム検出]
    E --> F[lapack/blas/openblasからlibgfortran依存検出]
    F --> G[libgfortranからlibgcc_s/libquadmath依存検出]
    G --> H[ディレクトリ・SONAME収集と重複排除]
    H --> I[各SONAMEをprivate_libdirにコピー]
    I --> J{macOS?}
    J -->|Yes| K[install_name_tool -idでidentity変更]
    J -->|No| L[リンケージ修正処理]
    K --> L
    L --> M[関連ライブラリのリンケージ修正]
    M --> N{macOS?}
    N -->|Yes| O[install_name_tool -changeで@rpathに変更]
    N -->|No| P[patchelf --set-rpath $ORIGINに設定]
    O --> Q[バッチ終了]
    P --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | 該当なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数不足 | private_libdirが未指定 | 正しい引数でスクリプトを再実行 |
| 該当なし | ライブラリ未検出 | libgfortranの依存関係が見つからない場合 | 処理をスキップ（正常動作） |
| 該当なし | コピー失敗 | ライブラリファイルのコピーが失敗 | 権限の確認、ディスク容量の確認 |
| 該当なし | リンケージ修正失敗 | patchelf/install_name_toolが失敗 | ツールのインストールと権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

途中で失敗した場合、部分的にコピーされたライブラリが残る可能性がある。private_libdirのlibgfortran/libgcc_s/libquadmathを手動削除して再実行するか、再ビルドで復旧する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル単位の逐次処理） |
| コミットタイミング | 各ファイル操作の完了時 |
| ロールバック条件 | 手動でのファイル削除が必要 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数個〜十数個のライブラリファイル |
| 目標処理時間 | 数秒〜十数秒 |
| メモリ使用量上限 | 最小限（シェルスクリプト） |

## 排他制御

同一private_libdirに対する同時実行は推奨されない。ライブラリファイルの同時書き込みが発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし | 該当なし |
| デバッグログ | --verbose時 | "Discovered traces of libgfortran within ..."、"Got SONAMES of ..." |
| 進捗ログ | コピー時 | cp -vによるコピーログ |
| 終了ログ | なし | 該当なし |
| エラーログ | 引数不足時 | "Usage: ..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

## 備考

- Linux環境ではpatchelfを使用し、macOS環境ではotool/install_name_toolを使用する
- ライブラリパスが@rpathや相対パスの場合、gfortranコンパイラ（`$FC -print-file-name`）に問い合わせて実際のパスを解決する
- 対象ライブラリ: libopenblas, libcholmod, liblapack, libgfortran, libgcc_s, libquadmath
- uniquify関数でSONAMEとディレクトリの重複を排除している
- macOSではinstall_name_tool -changeで旧パスを@rpath/SONAMEに変更
- LinuxではRPATHを$ORIGINに設定し、同一ディレクトリからのライブラリ解決を有効化
- プラットフォーム自動検出はuname -sに基づき、Linux/Darwin以外の場合はLinuxと仮定して警告を出力
- ファイルパス: `contrib/fixup-libgfortran.sh`
