# バッチ設計書 3-LabelCheck

## 概要

本ドキュメントは、JuliaLangリポジトリにおけるLabelCheck GitHub Actionsワークフローのバッチ設計書である。PRのラベルを検査し、ブロッキングラベル（`needs *`や`DO NOT MERGE`など）が付与されたPRのマージを防止するためのCI/CDパイプラインの一部として機能する。

### 本バッチの処理概要

このバッチは、PRのラベル変更やPRの作成・更新時に自動実行され、マージをブロックすべきラベルが付与されていないかを検査するCI/CDワークフローである。

**業務上の目的・背景**：Juliaプロジェクトでは、PRのレビューやマージプロセスにおいてラベルを活用したワークフロー管理を行っている。例えば「needs docs」「needs tests」「needs decision」などのラベルは、PRがまだマージ可能な状態にないことを示す。これらのラベルが付与されたPRが誤ってマージされることを防ぐため、CIレベルでブロッキングラベルの存在を検査し、該当する場合にチェックを失敗させることで安全なマージプロセスを実現する。

**バッチの実行タイミング**：PRに対するラベル付与（labeled）、ラベル除去（unlabeled）、PR作成（opened）、再オープン（reopened）、編集（edited）、同期（synchronize）の各イベント時に自動実行される。

**主要な処理内容**：
1. yogevbd/enforce-label-actionを使用してPRのラベルを検査
2. BANNED_LABELSに定義されたブロッキングラベルの存在チェック
3. ブロッキングラベルが存在する場合、チェックを失敗させる

**前後の処理との関連**：本バッチは独立したCIジョブであり、他のバッチとの直接的な依存関係はない。ただし、No.4 PrAssigneeワークフローとともにPR管理プロセスの一環として機能する。

**影響範囲**：全てのプルリクエストが検査対象となる。ブロッキングラベルが付与されている場合、GitHub Actionsのチェックが失敗し、ブランチ保護設定と連携してPRのマージを防止する。

## バッチ種別

コード品質チェック（ラベル検査）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | GitHub Actionsイベント（pull_request: labeled, unlabeled, opened, reopened, edited, synchronize） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHubリポジトリ | JuliaLang/juliaリポジトリ上で動作すること |
| ランナー環境 | ubuntu-latestが利用可能であること |

### 実行可否判定

pull_requestイベント（labeled, unlabeled, opened, reopened, edited, synchronize）が発生した場合に自動的に実行される。条件分岐やスキップロジックはない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| BANNED_LABELS | String | Yes | 固定値 | 禁止ラベルのカンマ区切りリスト |
| BANNED_LABELS_DESCRIPTION | String | Yes | 固定値 | 禁止ラベル検出時のメッセージ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| PRラベル情報 | GitHub API | PRに付与されているラベル一覧（GitHub Actionsコンテキスト経由） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub Actions Check | ステータス | 成功（ブロッキングラベルなし）または失敗（ブロッキングラベルあり） |
| 終了コード | 整数 | 0: パス、1: ブロッキングラベル検出 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（ファイル出力なし） |
| 出力先 | GitHub Actions実行ログ |
| 文字コード | N/A |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. PRイベント受信
   └─ labeled/unlabeled/opened/reopened/edited/synchronizeイベントの検出
2. ラベル検査
   └─ yogevbd/enforce-label-action@2.2.2を使用
      ├─ BANNED_LABELSリストとPRのラベルを比較
      └─ 一致するラベルが存在する場合にチェック失敗
```

### フローチャート

```mermaid
flowchart TD
    A[PRイベント発生] --> B[enforce-label-action実行]
    B --> C{BANNED_LABELSに一致するラベルあり?}
    C -->|あり| D[チェック失敗 - BANNED_LABELS_DESCRIPTION表示]
    C -->|なし| E[チェック成功]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| check failure | ブロッキングラベル検出 | BANNED_LABELSに一致するラベルがPRに付与されている場合 | 該当ラベルの要件を満たした後にラベルを除去する |
| timeout | タイムアウト | 2分以内に処理が完了しない場合 | GitHub Actionsにより自動中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

ブロッキングラベルが検出された場合は意図通りの動作であるため、ラベルに対応する要件（テスト追加、ドキュメント追加など）を満たした後にラベルを除去すればチェックが再実行されパスする。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（対象PR） |
| 目標処理時間 | 2分以内（timeout-minutes: 2） |
| メモリ使用量上限 | GitHub Actionsランナーの標準上限 |

## 排他制御

読み取り専用の検査であり、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ステップ開始時 | GitHub Actionsのステップログに自動記録 |
| 結果ログ | 検査完了時 | ブロッキングラベルの検出有無とBANNED_LABELS_DESCRIPTION |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ワークフロー実行時間 | 2分 | GitHub Actions（自動タイムアウト） |
| チェック失敗 | 1回 | GitHub PR Checksタブ |

## 備考

- BANNED_LABELSには以下のラベルが設定されている：`needs docs`, `needs compat annotation`, `needs more info`, `needs nanosoldier run`, `needs news`, `needs pkgeval`, `needs tests`, `needs decision`, `DO NOT MERGE`, `status:DO NOT MERGE`
- permissionsはcontents: readのみに設定されている
- ワークフロー名は"Labels"だが、ファイル名はLabelCheck.ymlである
- yogevbd/enforce-label-action@2.2.2（コミットハッシュ固定：a3c219da6b8fa73f6ba62b68ff09c469b3a1c024）を使用
- REQUIRED_LABELS_ANYの設定はコメントアウトされており、現在は禁止ラベルチェックのみ有効
