# バッチ設計書 30-fixup-libstdc++.sh

## 概要

本ドキュメントは、libstdc++ライブラリの配置を修正するシェルスクリプト `contrib/fixup-libstdc++.sh` のバッチ設計書である。

### 本バッチの処理概要

本バッチは、Juliaのバイナリ配布物においてlibstdc++をJuliaのプライベートライブラリディレクトリにコピーする。libjulia-internal.soの依存関係からlibstdc++の場所を検出し、プライベートライブラリディレクトリに配置することで、システムのlibstdc++に依存しない自己完結的なバイナリ配布を実現する。

**業務上の目的・背景**：Juliaはlibstdc++に動的リンクされており、ユーザ環境のlibstdc++バージョンがビルド時のバージョンと互換でない場合に問題が発生する。特にGLIBC/libstdc++のバージョン不一致はセグメンテーション違反や予期しない動作の原因となる。本スクリプトはビルド時に使用されたlibstdc++をJuliaのプライベートディレクトリにバンドルすることで、この互換性問題を解決する。

**バッチの実行タイミング**：バイナリ配布物の作成時にビルドシステムから呼び出される。Linux環境専用のスクリプトである。

**主要な処理内容**：
1. libjulia-internal.so（またはdebug版）からlibstdc++.soの依存関係をlddで検出
2. libstdc++のフルパスとファイル名を取得
3. libstdc++がprivate_libdirに未存在の場合にコピー
4. コピーしたファイルに755パーミッションを設定

**前後の処理との関連**：Juliaのビルドが完了し、libjulia-internal.soがprivate_libdirに配置された後に実行される。fixup-libgfortran.sh（No.29）と同様のライブラリ配置修正の一環として使用される。binary-dist（No.11）のプロセスで利用される。

**影響範囲**：private_libdirにlibstdc++がコピーされる。既存のlibstdc++がprivate_libdirにある場合はコピーをスキップする。

## バッチ種別

バイナリ修正 / ライブラリ配置修正

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（バイナリ配布物作成時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | ビルドシステムからの呼び出し / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux環境 | lddコマンドが利用可能なLinux環境であること |
| libjulia-internal.so | private_libdirにlibjulia-internal.so（またはdebug版）が存在すること |
| private_libdir | Juliaのプライベートライブラリディレクトリが存在すること |
| libdir | システムライブラリディレクトリのパス |

### 実行可否判定

引数が2つ（libdir、private_libdir）であること。libjulia-internal.soまたはlibjulia-internal-debug.soがprivate_libdirに存在すること。どちらも存在しない場合はexit 2で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| libdir | パス | Yes | なし | システムライブラリディレクトリ（第1引数） |
| private_libdir | パス | Yes | なし | Juliaのプライベートライブラリディレクトリ（第2引数） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| private_libdir/libjulia-internal.so | 共有ライブラリ | Julia内部ライブラリ（libstdc++依存の検出元） |
| private_libdir/libjulia-internal-debug.so | 共有ライブラリ | Julia内部ライブラリのデバッグ版（フォールバック） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| private_libdir/libstdc++.so* | 共有ライブラリ | コピーされたlibstdc++ライブラリ |
| 標準出力 | テキスト | cp -vのコピーログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | libstdc++のSONAMEに基づく |
| 出力先 | private_libdir |
| 文字コード | 該当なし（バイナリ） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数バリデーション
   └─ 引数が2つであることを確認。不足時はUsage表示後exit 1
2. libjulia-internal.soの存在確認
   ├─ private_libdir/libjulia-internal.so を確認
   ├─ 存在しない場合、libjulia-internal-debug.so を確認
   └─ どちらも存在しない場合はexit 2
3. libstdc++.soの検出
   ├─ libjulia-internal.soに対してlddを実行
   ├─ 出力からlibstdc++.soの行をgrep
   └─ フルパスを取得（cut -d' ' -f3）
4. ファイル名とディレクトリの分離
   ├─ LIBSTD_NAME = basename
   └─ LIBSTD_DIR = dirname
5. コピー判定と実行
   ├─ private_libdir/$LIBSTD_NAMEが存在しない場合
   ├─ かつLIBSTD_DIR/$LIBSTD_NAMEが存在する場合
   ├─ cp -vでprivate_libdirにコピー
   └─ chmod 755で権限設定
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数2つ?}
    B -->|No| C[Usage表示・exit 1]
    B -->|Yes| D{libjulia-internal.so存在?}
    D -->|No| E{libjulia-internal-debug.so存在?}
    D -->|Yes| F[lddでlibstdc++検出]
    E -->|No| G[ERROR表示・exit 2]
    E -->|Yes| H[lddでlibstdc++検出（debug版）]
    F --> I[LIBSTD_NAME/LIBSTD_DIR取得]
    H --> I
    I --> J{private_libdirにlibstdc++未存在?}
    J -->|Yes| K{ソースにlibstdc++存在?}
    J -->|No| L[スキップ（既存）]
    K -->|Yes| M[cp -vでコピー]
    K -->|No| N[スキップ（ソースなし）]
    M --> O[chmod 755]
    O --> P[バッチ終了]
    L --> P
    N --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | 該当なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数不足 | 引数が2つでない場合 | 正しい引数で再実行 |
| 2 | ライブラリ未検出 | libjulia-internal.so/debug.soが共に存在しない場合 | Juliaのビルドを確認。private_libdirのパスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

exit 2の場合はJuliaのビルドが正常に完了しているか確認する。コピーに失敗した場合はディスク容量と権限を確認して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（単一ファイルのコピー処理） |
| コミットタイミング | コピー完了時 |
| ロールバック条件 | コピーされたlibstdc++を手動削除 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（libstdc++の1ファイル） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小限（シェルスクリプト） |

## 排他制御

同一private_libdirに対する同時実行でもlibstdc++の存在チェックにより重複コピーは防止される。ただし、チェックとコピーの間のrace conditionは排除されていない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし | 該当なし |
| 進捗ログ | コピー時 | cp -vによるコピーログ |
| 終了ログ | なし | 該当なし |
| エラーログ | エラー発生時 | "ERROR: Could not open libjulia-internal.so"（exit 2時）、Usage（exit 1時） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

## 備考

- 本スクリプトはLinux専用であり、macOSではlddが使用できないため動作しない
- fixup-libgfortran.sh（No.29）がFortranランタイムを処理するのに対し、本スクリプトはC++ランタイム（libstdc++）を処理する
- libjulia-internal.so を優先し、存在しない場合にlibjulia-internal-debug.so をフォールバックとして使用する
- private_libdirにlibstdc++が既に存在する場合はコピーをスキップする（冪等性）
- find_shlib関数はlddの出力を解析してlibstdc++のフルパスを取得する
- ファイルパス: `contrib/fixup-libstdc++.sh`
