# バッチ設計書 32-install.sh

## 概要

本ドキュメントは、Juliaビルドシステムにおいてファイルのコピーとパーミッション設定を一括で行うインストール用シェルスクリプト `contrib/install.sh` のバッチ設計書である。

### 本バッチの処理概要

本バッチは、UNIXの`install`コマンドに類似した機能を提供する軽量なシェルスクリプトであり、1つ以上のソースファイルをコピー先にコピーし、指定されたパーミッションを設定する。Juliaのビルドシステム全体で広く使用されるファイルインストール処理の基盤である。

**業務上の目的・背景**：Juliaのビルドシステムでは、コンパイル済みのバイナリ、ライブラリ、ドキュメントなどの成果物を最終的なインストールディレクトリに配置する必要がある。標準の`install`コマンドはプラットフォームによって動作が異なるため、本スクリプトによりクロスプラットフォームで一貫したファイルインストール動作を実現する。`cp -a`によるメタデータ保持と、シンボリックリンクに対するパーミッション変更のスキップという2つの重要な機能を備え、システムライブラリへの意図しない変更を防止する。

**バッチの実行タイミング**：`make install`実行時にMakefileから自動呼出しされる。`Make.inc`で`INSTALL_F`（パーミッション644）および`INSTALL_M`（パーミッション755）として定義され、ビルドプロセス中に頻繁に呼び出される。

**主要な処理内容**：
1. 第1引数からパーミッション値を取得する
2. 最後の引数をコピー先ディレクトリ/ファイルとして認識する
3. 中間の引数群をソースファイルとしてループ処理する
4. 各ソースファイルを`cp -a`でコピー先にコピーする
5. コピー先がディレクトリの場合はファイル名を自動解決する
6. シンボリックリンクでない場合のみ`chmod`でパーミッションを設定する

**前後の処理との関連**：ビルドシステムの`make install`ターゲットから呼び出される。ライブラリ、バイナリ、manページなどのインストール工程で使用される。後続処理として、macOS環境では`delete-all-rpaths.sh`や`fixup-rpath.sh`などのバイナリ修正スクリプトが実行される場合がある。

**影響範囲**：インストール先ディレクトリ（`$(DESTDIR)$(prefix)`配下）のファイルシステム。バイナリ（`bindir`）、共有ライブラリ（`libdir`、`private_libdir`）、manページ（`man1dir`）など広範なファイルが対象となる。

## バッチ種別

ユーティリティ処理（ファイルインストール）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド・インストール時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | Makefile内のINSTALL_F/INSTALL_M変数経由で自動呼出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| UNIX互換環境 | `cp`、`chmod`、`basename`コマンドが利用可能であること |
| ソースファイルの存在 | コピー元ファイルが存在すること |
| コピー先の書き込み権限 | コピー先ディレクトリへの書き込み権限があること |

### 実行可否判定

引数が最低2つ（パーミッション値とコピー先）必要。ソースファイルが0個の場合は何も処理せず正常終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PERMS | 数値文字列 | Yes | なし | chmodに渡すパーミッション値（例：644、755） |
| src1 [src2 ...] | ファイルパス（可変長） | Yes | なし | コピー元ファイルパス（1つ以上） |
| dest | ファイルパスまたはディレクトリパス | Yes | なし | コピー先のパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースファイル | 任意（バイナリ/テキスト） | コピー対象のファイル群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コピー先ディレクトリ/ファイル | 入力と同一形式 | パーミッションが設定されたファイルのコピー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | ソースファイルと同一（ディレクトリへのコピー時）またはdest引数で指定 |
| 出力先 | dest引数で指定されたパス |
| 文字コード | 入力と同一（バイナリコピー） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. パーミッション値取得
   └─ 第1引数をPERMS変数に格納し、引数リストからシフト
2. 引数の分離
   └─ 最後の引数をDEST（コピー先）、残りをARGS（ソースファイル群）に分離
3. ファイルコピーとパーミッション設定（各ソースファイルについてループ）
   3.1 cp -a でソースをコピー先にコピー（メタデータ保持）
   3.2 コピー先がディレクトリの場合、DESTFILEをディレクトリ+ベースネームに設定
   3.3 コピー先がファイルの場合、DESTFILEをそのままDESTに設定
   3.4 DESTFILEがシンボリックリンクでない場合のみchmodを実行
4. 正常終了
   └─ exit 0を返す
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[第1引数をPERMSに格納]
    B --> C[最後の引数をDESTに格納]
    C --> D[残りの引数をARGSに格納]
    D --> E[各ソースファイルについてループ開始]
    E --> F[cp -a SRC DEST]
    F --> G{DESTはディレクトリ?}
    G -->|Yes| H[DESTFILE = DEST/basename SRC]
    G -->|No| I[DESTFILE = DEST]
    H --> J{DESTFILEはシンボリックリンク?}
    I --> J
    J -->|Yes| K[chmodをスキップ]
    J -->|No| L[chmod PERMS DESTFILE]
    K --> M{次のソースファイルあり?}
    L --> M
    M -->|Yes| E
    M -->|No| N[exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。ファイルシステム操作のみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | cpコマンド失敗 | ソースファイルが存在しない、またはコピー先に書き込み権限がない | ソースファイルの存在確認およびコピー先のパーミッション確認 |
| N/A | chmodコマンド失敗 | ファイルのパーミッション変更権限がない | 実行ユーザーの権限を確認（root権限が必要な場合あり） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構未実装） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

スクリプトは常にexit 0を返す設計であるため、個々のcp/chmodコマンドの失敗は検出されない。ビルド成果物の不整合が疑われる場合は、`make clean`後に`make install`を再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位（各ファイルのコピーとchmodは個別に実行） |
| コミットタイミング | 各cpおよびchmod実行時に即時反映 |
| ロールバック条件 | ロールバック機構なし。`make clean && make install`で再実行 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の呼出で1〜数個のファイル。ビルド全体では数十回呼び出される |
| 目標処理時間 | 1回の呼出あたり1秒未満 |
| メモリ使用量上限 | 特に制約なし（cp/chmodのメモリ使用量に依存） |

## 排他制御

同一ファイルに対する同時書き込みが発生しないことが前提。Makefileの依存関係により順序制御される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| N/A | N/A | 本スクリプトは標準出力/標準エラーへのログ出力を行わない |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 常にexit 0（エラー検出不可） | N/A |

## 備考

- 本スクリプトは`Make.inc`で以下の2つのエイリアスとして定義される：
  - `INSTALL_F`：パーミッション644（通常ファイル用、読み取り専用）
  - `INSTALL_M`：パーミッション755（実行ファイル/ライブラリ用）
- `cp -a`はアーカイブモードでコピーを行い、シンボリックリンク、タイムスタンプ、パーミッションなどのメタデータを可能な限り保持する。
- シンボリックリンクに対するchmodスキップは、システムライブラリへのシンボリックリンクのパーミッションを意図せず変更しないための安全対策である。
- 常にexit 0を返すため、cp/chmodの個別エラーは呼び出し元に伝播しない点に注意が必要。
